/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.containerlaunch.ClasspathConstructor;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLauncher {
    private static final Logger log = LoggerFactory.getLogger(AbstractLauncher.class);
    public static final String CLASSPATH = "CLASSPATH";
    public static final String ENV_DOCKER_CONTAINER_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS";
    protected final Map<String, String> envVars = new HashMap<String, String>();
    protected final ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
    protected final List<String> commands = new ArrayList<String>(20);
    protected final Map<String, LocalResource> localResources = new HashMap<String, LocalResource>();
    protected final Map<String, String> mountPaths = new HashMap<String, String>();
    private final Map<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
    protected boolean yarnDockerMode = false;
    protected String dockerImage;
    protected String dockerNetwork;
    protected String dockerHostname;
    protected boolean runPrivilegedContainer = false;
    private ServiceContext context;

    public AbstractLauncher(ServiceContext context) {
        this.context = context;
    }

    public void setYarnDockerMode(boolean yarnDockerMode) {
        this.yarnDockerMode = yarnDockerMode;
    }

    public Map<String, String> getEnv() {
        return this.envVars;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void addLocalResource(String subPath, LocalResource resource) {
        this.localResources.put(subPath, resource);
    }

    public void addLocalResource(String subPath, LocalResource resource, String mountPath) {
        this.localResources.put(subPath, resource);
        this.mountPaths.put(subPath, mountPath);
    }

    public void addCommand(String cmd) {
        this.commands.add(cmd);
    }

    public ContainerLaunchContext completeContainerLaunch() throws IOException {
        String cmdStr = ServiceUtils.join(this.commands, " ", false);
        log.debug("Completed setting up container command {}", (Object)cmdStr);
        this.containerLaunchContext.setCommands(this.commands);
        if (log.isDebugEnabled()) {
            log.debug("Environment variables");
            for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
                log.debug("    \"{}\"=\"{}\"", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.containerLaunchContext.setEnvironment(this.envVars);
        if (log.isDebugEnabled()) {
            log.debug("Service Data size");
            for (Map.Entry<String, Object> entry : this.serviceData.entrySet()) {
                log.debug("\"{}\"=> {} bytes of data", (Object)entry.getKey(), (Object)((ByteBuffer)entry.getValue()).array().length);
            }
        }
        this.containerLaunchContext.setServiceData(this.serviceData);
        this.dumpLocalResources();
        this.containerLaunchContext.setLocalResources(this.localResources);
        if (this.context.tokens != null) {
            this.containerLaunchContext.setTokens(this.context.tokens.duplicate());
        }
        if (this.yarnDockerMode) {
            Map env = this.containerLaunchContext.getEnvironment();
            env.put("YARN_CONTAINER_RUNTIME_TYPE", "docker");
            env.put("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE", this.dockerImage);
            if (ServiceUtils.isSet(this.dockerNetwork)) {
                env.put("YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_NETWORK", this.dockerNetwork);
            }
            env.put("YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_HOSTNAME", this.dockerHostname);
            if (this.runPrivilegedContainer) {
                env.put("YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER", "true");
            }
            if (!this.mountPaths.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                if (env.get(ENV_DOCKER_CONTAINER_MOUNTS) != null) {
                    stringBuilder.append((String)env.get(ENV_DOCKER_CONTAINER_MOUNTS));
                }
                for (Map.Entry<String, String> mount : this.mountPaths.entrySet()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(mount.getKey()).append(":").append(mount.getValue()).append(":ro");
                }
                env.put(ENV_DOCKER_CONTAINER_MOUNTS, stringBuilder.toString());
            }
            log.info("yarn docker env var has been set {}", (Object)this.containerLaunchContext.getEnvironment().toString());
        }
        return this.containerLaunchContext;
    }

    public void setRetryContext(int maxRetries, int retryInterval, long failuresValidityInterval) {
        ContainerRetryContext retryContext = ContainerRetryContext.newInstance((ContainerRetryPolicy)ContainerRetryPolicy.RETRY_ON_ALL_ERRORS, null, (int)maxRetries, (int)retryInterval, (long)failuresValidityInterval);
        this.containerLaunchContext.setContainerRetryContext(retryContext);
    }

    private void dumpLocalResources() {
        if (log.isDebugEnabled()) {
            log.debug("{} resources: ", (Object)this.localResources.size());
            for (Map.Entry<String, LocalResource> entry : this.localResources.entrySet()) {
                String key = entry.getKey();
                LocalResource val = entry.getValue();
                log.debug("{} = {}", (Object)key, (Object)ServiceUtils.stringify(val.getResource()));
            }
        }
    }

    protected void propagateUsernameInInsecureCluster() throws IOException {
        String userName = UserGroupInformation.getCurrentUser().getUserName();
        this.envVars.put("HADOOP_USER_NAME", userName);
    }

    public void setClasspath(ClasspathConstructor classpath) {
        this.setEnv(CLASSPATH, classpath.buildClasspath());
    }

    public void setEnv(String var, String value) {
        Preconditions.checkArgument((var != null ? 1 : 0) != 0, (Object)"null variable name");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        this.envVars.put(var, value);
    }

    public void putEnv(Map<String, String> map) {
        this.envVars.putAll(map);
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setDockerNetwork(String dockerNetwork) {
        this.dockerNetwork = dockerNetwork;
    }

    public void setDockerHostname(String dockerHostname) {
        this.dockerHostname = dockerHostname;
    }

    public void setRunPrivilegedContainer(boolean runPrivilegedContainer) {
        this.runPrivilegedContainer = runPrivilegedContainer;
    }

    @VisibleForTesting
    public String getDockerImage() {
        return this.dockerImage;
    }
}

