/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class TestTotalOrderPartitioner {
    private static final Text[] splitStrings = new Text[]{new Text("aabbb"), new Text("babbb"), new Text("daddd"), new Text("dddee"), new Text("ddhee"), new Text("dingo"), new Text("hijjj"), new Text("n"), new Text("yak")};
    private static final String[] splitJavaStrings = new String[]{new String("aabbb"), new String("babbb"), new String("daddd"), new String("dddee"), new String("ddhee"), new String("dingo"), new String("hijjj"), new String("n"), new String("yak")};
    private static final ArrayList<Check<Text>> testStrings = new ArrayList();
    private static final ArrayList<Check<String>> testJavaStrings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Path writePartitionFile(String testname, Configuration conf, T[] splits) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path p = new Path(testdir, testname + "/_partition.lst");
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)p);
        conf.setInt("mapreduce.job.reduces", splits.length + 1);
        SequenceFile.Writer w = null;
        try {
            w = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)p), SequenceFile.Writer.keyClass(splits[0].getClass()), SequenceFile.Writer.valueClass(NullWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
            for (int i = 0; i < splits.length; ++i) {
                w.append(splits[i], (Object)NullWritable.get());
            }
        }
        finally {
            if (null != w) {
                w.close();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderWithCustomSerialization() throws Exception {
        TotalOrderPartitioner partitioner = new TotalOrderPartitioner();
        Configuration conf = new Configuration();
        conf.setStrings("io.serializations", new String[]{JavaSerialization.class.getName(), WritableSerialization.class.getName()});
        conf.setClass("mapreduce.job.output.key.comparator.class", JavaSerializationComparator.class, Comparator.class);
        Path p = TestTotalOrderPartitioner.writePartitionFile("totalordercustomserialization", conf, splitJavaStrings);
        conf.setClass("mapreduce.map.output.key.class", String.class, Object.class);
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check<String> chk : testJavaStrings) {
                Assert.assertEquals((String)((String)chk.data).toString(), (long)chk.part, (long)partitioner.getPartition((Object)((String)chk.data), (Object)nw, splitJavaStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderMemCmp() throws Exception {
        TotalOrderPartitioner partitioner = new TotalOrderPartitioner();
        Configuration conf = new Configuration();
        Path p = TestTotalOrderPartitioner.writePartitionFile("totalordermemcmp", conf, splitStrings);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check<Text> chk : testStrings) {
                Assert.assertEquals((String)((Text)chk.data).toString(), (long)chk.part, (long)partitioner.getPartition((Object)((Text)chk.data), (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderBinarySearch() throws Exception {
        TotalOrderPartitioner partitioner = new TotalOrderPartitioner();
        Configuration conf = new Configuration();
        Path p = TestTotalOrderPartitioner.writePartitionFile("totalorderbinarysearch", conf, splitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check<Text> chk : testStrings) {
                Assert.assertEquals((String)((Text)chk.data).toString(), (long)chk.part, (long)partitioner.getPartition((Object)((Text)chk.data), (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderCustomComparator() throws Exception {
        TotalOrderPartitioner partitioner = new TotalOrderPartitioner();
        Configuration conf = new Configuration();
        Text[] revSplitStrings = Arrays.copyOf(splitStrings, splitStrings.length);
        Arrays.sort(revSplitStrings, new ReverseStringComparator());
        Path p = TestTotalOrderPartitioner.writePartitionFile("totalordercustomcomparator", conf, revSplitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        conf.setClass("mapreduce.job.output.key.comparator.class", ReverseStringComparator.class, RawComparator.class);
        ArrayList<Check<Text>> revCheck = new ArrayList<Check<Text>>();
        revCheck.add(new Check<Text>(new Text("aaaaa"), 9));
        revCheck.add(new Check<Text>(new Text("aaabb"), 9));
        revCheck.add(new Check<Text>(new Text("aabbb"), 9));
        revCheck.add(new Check<Text>(new Text("aaaaa"), 9));
        revCheck.add(new Check<Text>(new Text("babbb"), 8));
        revCheck.add(new Check<Text>(new Text("baabb"), 8));
        revCheck.add(new Check<Text>(new Text("yai"), 1));
        revCheck.add(new Check<Text>(new Text("yak"), 1));
        revCheck.add(new Check<Text>(new Text("z"), 0));
        revCheck.add(new Check<Text>(new Text("ddngo"), 4));
        revCheck.add(new Check<Text>(new Text("hi"), 3));
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check check : revCheck) {
                Assert.assertEquals((String)((Text)check.data).toString(), (long)check.part, (long)partitioner.getPartition((Object)((Text)check.data), (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    static {
        testStrings.add(new Check<Text>(new Text("aaaaa"), 0));
        testStrings.add(new Check<Text>(new Text("aaabb"), 0));
        testStrings.add(new Check<Text>(new Text("aabbb"), 1));
        testStrings.add(new Check<Text>(new Text("aaaaa"), 0));
        testStrings.add(new Check<Text>(new Text("babbb"), 2));
        testStrings.add(new Check<Text>(new Text("baabb"), 1));
        testStrings.add(new Check<Text>(new Text("yai"), 8));
        testStrings.add(new Check<Text>(new Text("yak"), 9));
        testStrings.add(new Check<Text>(new Text("z"), 9));
        testStrings.add(new Check<Text>(new Text("ddngo"), 5));
        testStrings.add(new Check<Text>(new Text("hi"), 6));
        testJavaStrings = new ArrayList();
        testJavaStrings.add(new Check<String>(new String("aaaaa"), 0));
        testJavaStrings.add(new Check<String>(new String("aaabb"), 0));
        testJavaStrings.add(new Check<String>(new String("aabbb"), 1));
        testJavaStrings.add(new Check<String>(new String("aaaaa"), 0));
        testJavaStrings.add(new Check<String>(new String("babbb"), 2));
        testJavaStrings.add(new Check<String>(new String("baabb"), 1));
        testJavaStrings.add(new Check<String>(new String("yai"), 8));
        testJavaStrings.add(new Check<String>(new String("yak"), 9));
        testJavaStrings.add(new Check<String>(new String("z"), 9));
        testJavaStrings.add(new Check<String>(new String("ddngo"), 5));
        testJavaStrings.add(new Check<String>(new String("hi"), 6));
    }

    public static class ReverseStringComparator
    implements RawComparator<Text> {
        public int compare(Text a, Text b) {
            return -a.compareTo((BinaryComparable)b);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
            int n2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
            return -1 * WritableComparator.compareBytes((byte[])b1, (int)(s1 + n1), (int)(l1 - n1), (byte[])b2, (int)(s2 + n2), (int)(l2 - n2));
        }
    }

    static class Check<T> {
        T data;
        int part;

        Check(T data, int part) {
            this.data = data;
            this.part = part;
        }
    }
}

