/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server;

import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.Login;
import org.apache.hadoop.shaded.org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslServer {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.serverconfig";
    public static final String DEFAULT_LOGIN_CONTEXT_NAME = "Server";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslServer.class);
    private SaslServer saslServer;

    ZooKeeperSaslServer(Login login) {
        this.saslServer = this.createSaslServer(login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslServer createSaslServer(Login login) {
        Login login2 = login;
        synchronized (login2) {
            Subject subject = login.getSubject();
            String mechOpt = System.getProperty("zookeeper.authMech");
            LOG.debug("ZooKeeperSaslServer::createSaslServer, creating SASL server with mechOpt " + mechOpt);
            return SecurityUtils.createSaslServer(subject, "zookeeper", "zk-sasl-md5", login.callbackHandler, LOG, mechOpt);
        }
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }

    static {
        String saslProviderClassName = System.getProperty("zookeeper.saslprovider");
        if (saslProviderClassName != null) {
            try {
                Class<?> clazz = Class.forName(saslProviderClassName);
                Security.addProvider((Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("ClassNotFoundException: " + saslProviderClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.warn("InstantiationException: " + saslProviderClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("IllegalAccessException: " + saslProviderClassName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("NoSuchMethodException: " + saslProviderClassName, (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.warn("SecurityException: " + saslProviderClassName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.warn("InvocationTargetException: " + saslProviderClassName, (Throwable)e);
            }
        }
    }
}

