/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.shaded.org.apache.yetus.audience.InterfaceAudience;
import org.apache.hadoop.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.StatsTrack;
import org.apache.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.hadoop.shaded.org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.AddAuthCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CloseCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CommandNotFoundException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CreateCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.DelQuotaCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.DeleteAllCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.DeleteCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.GetAclCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.GetCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.GetConfigCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.ListQuotaCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.Ls2Command;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.LsCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.ReconfigCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.RemoveWatchesCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.SetAclCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.SetCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.SetQuotaCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.StatCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.SyncCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ZooKeeperMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperMain.class);
    static final Map<String, String> commandMap = new HashMap<String, String>();
    static final Map<String, CliCommand> commandMapCli = new HashMap<String, CliCommand>();
    protected MyCommandOptions cl = new MyCommandOptions();
    protected HashMap<Integer, String> history = new HashMap();
    protected int commandCount = 0;
    protected boolean printWatches = true;
    protected int exitCode = 0;
    protected ZooKeeper zk;
    protected String host = "";

    public boolean getPrintWatches() {
        return this.printWatches;
    }

    static void usage() {
        System.err.println("ZooKeeper -server host:port cmd args");
        ArrayList<String> cmdList = new ArrayList<String>(commandMap.keySet());
        Collections.sort(cmdList);
        for (String cmd : cmdList) {
            System.err.println("\t" + cmd + " " + commandMap.get(cmd));
        }
    }

    protected void addToHistory(int i, String cmd) {
        this.history.put(i, cmd);
    }

    public static List<String> getCommands() {
        ArrayList<String> cmdList = new ArrayList<String>(commandMap.keySet());
        Collections.sort(cmdList);
        return cmdList;
    }

    protected String getPrompt() {
        return "[zk: " + this.host + "(" + this.zk.getState() + ") " + this.commandCount + "] ";
    }

    public static void printMessage(String msg) {
        System.out.println("\n" + msg);
    }

    protected void connectToZK(String newHost) throws InterruptedException, IOException {
        boolean readOnly;
        if (this.zk != null && this.zk.getState().isAlive()) {
            this.zk.close();
        }
        this.host = newHost;
        boolean bl = readOnly = this.cl.getOption("readonly") != null;
        if (this.cl.getOption("secure") != null) {
            System.setProperty("zookeeper.client.secure", "true");
            System.out.println("Secure connection is enabled");
        }
        this.zk = new ZooKeeperAdmin(this.host, Integer.parseInt(this.cl.getOption("timeout")), (Watcher)new MyWatcher(), readOnly);
    }

    public static void main(String[] args) throws CliException, IOException, InterruptedException {
        ZooKeeperMain main = new ZooKeeperMain(args);
        main.run();
    }

    public ZooKeeperMain(String[] args) throws IOException, InterruptedException {
        this.cl.parseOptions(args);
        System.out.println("Connecting to " + this.cl.getOption("server"));
        this.connectToZK(this.cl.getOption("server"));
    }

    public ZooKeeperMain(ZooKeeper zk) {
        this.zk = zk;
    }

    void run() throws CliException, IOException, InterruptedException {
        if (this.cl.getCommand() == null) {
            System.out.println("Welcome to ZooKeeper!");
            boolean jlinemissing = false;
            try {
                String line;
                Class<?> consoleC = Class.forName("jline.console.ConsoleReader");
                Class<?> completorC = Class.forName("org.apache.hadoop.shaded.org.apache.zookeeper.JLineZNodeCompleter");
                System.out.println("JLine support is enabled");
                Object console = consoleC.getConstructor(new Class[0]).newInstance(new Object[0]);
                Object completor = completorC.getConstructor(ZooKeeper.class).newInstance(this.zk);
                Method addCompletor = consoleC.getMethod("addCompleter", Class.forName("jline.console.completer.Completer"));
                addCompletor.invoke(console, completor);
                Method readLine = consoleC.getMethod("readLine", String.class);
                while ((line = (String)readLine.invoke(console, this.getPrompt())) != null) {
                    this.executeLine(line);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Unable to start jline", (Throwable)e);
                jlinemissing = true;
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Unable to start jline", (Throwable)e);
                jlinemissing = true;
            }
            catch (InvocationTargetException e) {
                LOG.debug("Unable to start jline", (Throwable)e);
                jlinemissing = true;
            }
            catch (IllegalAccessException e) {
                LOG.debug("Unable to start jline", (Throwable)e);
                jlinemissing = true;
            }
            catch (InstantiationException e) {
                LOG.debug("Unable to start jline", (Throwable)e);
                jlinemissing = true;
            }
            if (jlinemissing) {
                String line;
                System.out.println("JLine support is disabled");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                while ((line = br.readLine()) != null) {
                    this.executeLine(line);
                }
            }
        } else {
            this.processCmd(this.cl);
        }
        System.exit(this.exitCode);
    }

    public void executeLine(String line) throws CliException, InterruptedException, IOException {
        if (!line.equals("")) {
            this.cl.parseCommand(line);
            this.addToHistory(this.commandCount, line);
            this.processCmd(this.cl);
            ++this.commandCount;
        }
    }

    private static boolean trimProcQuotas(ZooKeeper zk, String path) throws KeeperException, IOException, InterruptedException {
        if ("/zookeeper/quota".equals(path)) {
            return true;
        }
        List<String> children = zk.getChildren(path, false);
        if (children.size() == 0) {
            zk.delete(path, -1);
            String parent = path.substring(0, path.lastIndexOf(47));
            return ZooKeeperMain.trimProcQuotas(zk, parent);
        }
        return true;
    }

    public static boolean delQuota(ZooKeeper zk, String path, boolean bytes, boolean numNodes) throws KeeperException, IOException, InterruptedException {
        String parentPath = "/zookeeper/quota" + path;
        String quotaPath = "/zookeeper/quota" + path + "/zookeeper_limits";
        if (zk.exists(quotaPath, false) == null) {
            System.out.println("Quota does not exist for " + path);
            return true;
        }
        byte[] data = null;
        try {
            data = zk.getData(quotaPath, false, new Stat());
        }
        catch (KeeperException.NoNodeException ne) {
            System.err.println("quota does not exist for " + path);
            return true;
        }
        StatsTrack strack = new StatsTrack(new String(data));
        if (bytes && !numNodes) {
            strack.setBytes(-1L);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (!bytes && numNodes) {
            strack.setCount(-1);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (bytes && numNodes) {
            List<String> children = zk.getChildren(parentPath, false);
            for (String child : children) {
                zk.delete(parentPath + "/" + child, -1);
            }
            ZooKeeperMain.trimProcQuotas(zk, parentPath);
        }
        return true;
    }

    private static void checkIfParentQuota(ZooKeeper zk, String path) throws InterruptedException, KeeperException {
        String[] splits = path.split("/");
        Object quotaPath = "/zookeeper/quota";
        for (String str : splits) {
            if (str.length() == 0) continue;
            quotaPath = (String)quotaPath + "/" + str;
            List<String> children = null;
            try {
                children = zk.getChildren((String)quotaPath, false);
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("child removed during quota check", (Throwable)ne);
                return;
            }
            if (children.size() == 0) {
                return;
            }
            for (String child : children) {
                if (!"zookeeper_limits".equals(child)) continue;
                throw new IllegalArgumentException(path + " has a parent " + (String)quotaPath + " which has a quota");
            }
        }
    }

    public static boolean createQuota(ZooKeeper zk, String path, long bytes, int numNodes) throws KeeperException, IOException, InterruptedException {
        Stat initStat = zk.exists(path, false);
        if (initStat == null) {
            throw new IllegalArgumentException(path + " does not exist.");
        }
        Object quotaPath = "/zookeeper/quota";
        String realPath = "/zookeeper/quota" + path;
        try {
            List<String> children = zk.getChildren(realPath, false);
            for (String child : children) {
                if (child.startsWith("zookeeper_")) continue;
                throw new IllegalArgumentException(path + " has child " + child + " which has a quota");
            }
        }
        catch (KeeperException.NoNodeException children) {
            // empty catch block
        }
        ZooKeeperMain.checkIfParentQuota(zk, path);
        if (zk.exists((String)quotaPath, false) == null) {
            try {
                zk.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException children) {
                // empty catch block
            }
        }
        String[] splits = path.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append((String)quotaPath);
        for (int i = 1; i < splits.length; ++i) {
            sb.append("/" + splits[i]);
            quotaPath = sb.toString();
            try {
                zk.create((String)quotaPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String statPath = (String)quotaPath + "/zookeeper_stats";
        quotaPath = (String)quotaPath + "/zookeeper_limits";
        StatsTrack strack = new StatsTrack(null);
        strack.setBytes(bytes);
        strack.setCount(numNodes);
        try {
            zk.create((String)quotaPath, strack.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack stats = new StatsTrack(null);
            stats.setBytes(0L);
            stats.setCount(0);
            zk.create(statPath, stats.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ne) {
            byte[] data = zk.getData((String)quotaPath, false, new Stat());
            StatsTrack strackC = new StatsTrack(new String(data));
            if (bytes != -1L) {
                strackC.setBytes(bytes);
            }
            if (numNodes != -1) {
                strackC.setCount(numNodes);
            }
            zk.setData((String)quotaPath, strackC.toString().getBytes(), -1);
        }
        return true;
    }

    protected boolean processCmd(MyCommandOptions co) throws CliException, IOException, InterruptedException {
        boolean watch = false;
        try {
            watch = this.processZKCmd(co);
            this.exitCode = 0;
        }
        catch (CliException ex) {
            this.exitCode = ex.getExitCode();
            System.err.println(ex.getMessage());
        }
        return watch;
    }

    protected boolean processZKCmd(MyCommandOptions co) throws CliException, IOException, InterruptedException {
        String[] args = co.getArgArray();
        String cmd = co.getCommand();
        if (args.length < 1) {
            ZooKeeperMain.usage();
            throw new MalformedCommandException("No command entered");
        }
        if (!commandMap.containsKey(cmd)) {
            ZooKeeperMain.usage();
            throw new CommandNotFoundException("Command not found " + cmd);
        }
        boolean watch = false;
        LOG.debug("Processing " + cmd);
        if (cmd.equals("quit")) {
            this.zk.close();
            System.exit(this.exitCode);
        } else if (cmd.equals("redo") && args.length >= 2) {
            Integer i = Integer.decode(args[1]);
            if (this.commandCount <= i || i < 0) {
                throw new MalformedCommandException("Command index out of range");
            }
            this.cl.parseCommand(this.history.get(i));
            if (this.cl.getCommand().equals("redo")) {
                throw new MalformedCommandException("No redoing redos");
            }
            this.history.put(this.commandCount, this.history.get(i));
            this.processCmd(this.cl);
        } else if (cmd.equals("history")) {
            for (int i = this.commandCount - 10; i <= this.commandCount; ++i) {
                if (i < 0) continue;
                System.out.println(i + " - " + this.history.get(i));
            }
        } else if (cmd.equals("printwatches")) {
            if (args.length == 1) {
                System.out.println("printwatches is " + (this.printWatches ? "on" : "off"));
            } else {
                this.printWatches = args[1].equals("on");
            }
        } else if (cmd.equals("connect")) {
            if (args.length >= 2) {
                this.connectToZK(args[1]);
            } else {
                this.connectToZK(this.host);
            }
        }
        if (this.zk == null || !this.zk.getState().isAlive()) {
            System.out.println("Not connected");
            return false;
        }
        CliCommand cliCmd = commandMapCli.get(cmd);
        if (cliCmd != null) {
            cliCmd.setZk(this.zk);
            watch = cliCmd.parse(args).exec();
        } else if (!commandMap.containsKey(cmd)) {
            ZooKeeperMain.usage();
        }
        return watch;
    }

    static {
        commandMap.put("connect", "host:port");
        commandMap.put("history", "");
        commandMap.put("redo", "cmdno");
        commandMap.put("printwatches", "on|off");
        commandMap.put("quit", "");
        new CloseCommand().addToMap(commandMapCli);
        new CreateCommand().addToMap(commandMapCli);
        new DeleteCommand().addToMap(commandMapCli);
        new DeleteAllCommand().addToMap(commandMapCli);
        new DeleteAllCommand("rmr").addToMap(commandMapCli);
        new SetCommand().addToMap(commandMapCli);
        new GetCommand().addToMap(commandMapCli);
        new LsCommand().addToMap(commandMapCli);
        new Ls2Command().addToMap(commandMapCli);
        new GetAclCommand().addToMap(commandMapCli);
        new SetAclCommand().addToMap(commandMapCli);
        new StatCommand().addToMap(commandMapCli);
        new SyncCommand().addToMap(commandMapCli);
        new SetQuotaCommand().addToMap(commandMapCli);
        new ListQuotaCommand().addToMap(commandMapCli);
        new DelQuotaCommand().addToMap(commandMapCli);
        new AddAuthCommand().addToMap(commandMapCli);
        new ReconfigCommand().addToMap(commandMapCli);
        new GetConfigCommand().addToMap(commandMapCli);
        new RemoveWatchesCommand().addToMap(commandMapCli);
        for (Map.Entry<String, CliCommand> entry : commandMapCli.entrySet()) {
            commandMap.put(entry.getKey(), entry.getValue().getOptionStr());
        }
    }

    static class MyCommandOptions {
        private Map<String, String> options = new HashMap<String, String>();
        private List<String> cmdArgs = null;
        private String command = null;
        public static final Pattern ARGS_PATTERN = Pattern.compile("\\s*([^\"']\\S*|\"[^\"]*\"|'[^']*')\\s*");
        public static final Pattern QUOTED_PATTERN = Pattern.compile("^(['\"])(.*)(\\1)$");

        public MyCommandOptions() {
            this.options.put("server", "localhost:2181");
            this.options.put("timeout", "30000");
        }

        public String getOption(String opt) {
            return this.options.get(opt);
        }

        public String getCommand() {
            return this.command;
        }

        public String getCmdArgument(int index) {
            return this.cmdArgs.get(index);
        }

        public int getNumArguments() {
            return this.cmdArgs.size();
        }

        public String[] getArgArray() {
            return this.cmdArgs.toArray(new String[0]);
        }

        public boolean parseOptions(String[] args) {
            List<String> argList = Arrays.asList(args);
            Iterator<String> it = argList.iterator();
            while (it.hasNext()) {
                String opt = it.next();
                try {
                    if (opt.equals("-server")) {
                        this.options.put("server", it.next());
                    } else if (opt.equals("-timeout")) {
                        this.options.put("timeout", it.next());
                    } else if (opt.equals("-r")) {
                        this.options.put("readonly", "true");
                    }
                }
                catch (NoSuchElementException e) {
                    System.err.println("Error: no argument found for option " + opt);
                    return false;
                }
                if (opt.startsWith("-")) continue;
                this.command = opt;
                this.cmdArgs = new ArrayList<String>();
                this.cmdArgs.add(this.command);
                while (it.hasNext()) {
                    this.cmdArgs.add(it.next());
                }
                return true;
            }
            return true;
        }

        public boolean parseCommand(String cmdstring) {
            Matcher matcher = ARGS_PATTERN.matcher(cmdstring);
            LinkedList<String> args = new LinkedList<String>();
            while (matcher.find()) {
                String value = matcher.group(1);
                if (QUOTED_PATTERN.matcher(value).matches()) {
                    value = value.substring(1, value.length() - 1);
                }
                args.add(value);
            }
            if (args.isEmpty()) {
                return false;
            }
            this.command = (String)args.get(0);
            this.cmdArgs = args;
            return true;
        }
    }

    private class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (ZooKeeperMain.this.getPrintWatches()) {
                ZooKeeperMain.printMessage("WATCHER::");
                ZooKeeperMain.printMessage(event.toString());
            }
        }
    }
}

