/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListByArrayList;

public interface DiffList<T extends Comparable<Integer>>
extends Iterable<T> {
    public static final DiffList EMPTY_LIST = new DiffListByArrayList(Collections.emptyList());

    public static <T extends Comparable<Integer>> DiffList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static <T extends Comparable<Integer>> DiffList<T> unmodifiableList(final DiffList<T> diffs) {
        return new DiffList<T>(){

            @Override
            public T get(int i) {
                return diffs.get(i);
            }

            @Override
            public boolean isEmpty() {
                return diffs.isEmpty();
            }

            @Override
            public int size() {
                return diffs.size();
            }

            @Override
            public T remove(int i) {
                throw new UnsupportedOperationException("This list is unmodifiable.");
            }

            @Override
            public boolean addLast(T t) {
                throw new UnsupportedOperationException("This list is unmodifiable.");
            }

            @Override
            public void addFirst(T t) {
                throw new UnsupportedOperationException("This list is unmodifiable.");
            }

            @Override
            public int binarySearch(int i) {
                return diffs.binarySearch(i);
            }

            @Override
            public Iterator<T> iterator() {
                return diffs.iterator();
            }

            @Override
            public List<T> getMinListForRange(int startIndex, int endIndex, INodeDirectory dir) {
                return diffs.getMinListForRange(startIndex, endIndex, dir);
            }
        };
    }

    public T get(int var1);

    public boolean isEmpty();

    public int size();

    public T remove(int var1);

    public boolean addLast(T var1);

    public void addFirst(T var1);

    public int binarySearch(int var1);

    public List<T> getMinListForRange(int var1, int var2, INodeDirectory var3);
}

