/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.select.SelectBinding;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WriteOperationHelper
implements WriteOperations {
    private static final Logger LOG = LoggerFactory.getLogger(WriteOperationHelper.class);
    private final S3AFileSystem owner;
    private final Invoker invoker;
    private final Configuration conf;
    private final String bucket;
    private final S3AStatisticsContext statisticsContext;
    private final StoreContext storeContext;
    private final AuditSpanSource auditSpanSource;
    private AuditSpan auditSpan;
    private final RequestFactory requestFactory;
    private final WriteOperationHelperCallbacks writeOperationHelperCallbacks;

    protected WriteOperationHelper(S3AFileSystem owner, Configuration conf, S3AStatisticsContext statisticsContext, AuditSpanSource auditSpanSource, AuditSpan auditSpan, WriteOperationHelperCallbacks writeOperationHelperCallbacks) {
        this.owner = owner;
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.conf = conf;
        this.statisticsContext = statisticsContext;
        this.storeContext = owner.createStoreContext();
        this.bucket = owner.getBucket();
        this.auditSpanSource = auditSpanSource;
        this.auditSpan = (AuditSpan)Preconditions.checkNotNull((Object)auditSpan);
        this.requestFactory = owner.getRequestFactory();
        this.writeOperationHelperCallbacks = writeOperationHelperCallbacks;
    }

    void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        LOG.info("{}: Retried {}: {}", new Object[]{text, retries, ex.toString()});
        LOG.debug("Stack", (Throwable)ex);
        this.owner.operationRetried(text, ex, retries, idempotent);
    }

    @Override
    public <T> T retry(String action, String path, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        this.activateAuditSpan();
        return this.invoker.retry(action, path, idempotent, operation);
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    private AuditSpan activateAuditSpan() {
        return this.auditSpan.activate();
    }

    private void deactivateAuditSpan() {
        this.auditSpan.deactivate();
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String destKey, InputStream inputStream, long length, PutObjectOptions options) {
        this.activateAuditSpan();
        ObjectMetadata objectMetadata = this.newObjectMetadata(length);
        return this.getRequestFactory().newPutObjectRequest(destKey, objectMetadata, options, inputStream);
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String dest, File sourceFile, PutObjectOptions options) {
        org.apache.hadoop.util.Preconditions.checkState((sourceFile.length() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"File length is too big for a single PUT upload");
        this.activateAuditSpan();
        ObjectMetadata objectMetadata = this.newObjectMetadata((int)sourceFile.length());
        PutObjectRequest putObjectRequest = this.getRequestFactory().newPutObjectRequest(dest, objectMetadata, options, sourceFile);
        return putObjectRequest;
    }

    @Override
    public void writeSuccessful(long length) {
    }

    @Override
    public void writeFailed(Exception ex) {
        LOG.debug("Write to {} failed", (Object)this, (Object)ex);
    }

    @Override
    public ObjectMetadata newObjectMetadata(long length) {
        return this.getRequestFactory().newObjectMetadata(length);
    }

    @Override
    public String initiateMultiPartUpload(String destKey, PutObjectOptions options) throws IOException {
        LOG.debug("Initiating Multipart upload to {}", (Object)destKey);
        try (AuditSpan span = this.activateAuditSpan();){
            String string = (String)this.retry("initiate MultiPartUpload", destKey, true, () -> {
                InitiateMultipartUploadRequest initiateMPURequest = this.getRequestFactory().newMultipartUploadRequest(destKey, options);
                return this.owner.initiateMultipartUpload(initiateMPURequest).getUploadId();
            });
            return string;
        }
    }

    private CompleteMultipartUploadResult finalizeMultipartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, PutObjectOptions putOptions, Invoker.Retried retrying) throws IOException {
        if (partETags.isEmpty()) {
            throw new PathIOException(destKey, "No upload parts in multipart upload");
        }
        try (AuditSpan span = this.activateAuditSpan();){
            CompleteMultipartUploadResult uploadResult = (CompleteMultipartUploadResult)this.invoker.retry("Completing multipart upload", destKey, true, retrying, () -> {
                CompleteMultipartUploadRequest request = this.getRequestFactory().newCompleteMultipartUploadRequest(destKey, uploadId, partETags);
                return this.writeOperationHelperCallbacks.completeMultipartUpload(request);
            });
            this.owner.finishedWrite(destKey, length, uploadResult.getETag(), uploadResult.getVersionId(), putOptions);
            CompleteMultipartUploadResult completeMultipartUploadResult = uploadResult;
            return completeMultipartUploadResult;
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMPUwithRetries(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount, PutObjectOptions putOptions) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, putOptions, (text, e, r, i) -> errorCount.incrementAndGet());
    }

    @Override
    public void abortMultipartUpload(String destKey, String uploadId, boolean shouldRetry, Invoker.Retried retrying) throws IOException {
        if (shouldRetry) {
            this.invoker.retry("Aborting multipart upload ID " + uploadId, destKey, true, retrying, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        } else {
            Invoker.once("Aborting multipart upload ID " + uploadId, destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        }
    }

    @Override
    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        this.invoker.retry("Aborting multipart commit", upload.getKey(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(upload)));
    }

    @Override
    public int abortMultipartUploadsUnderPath(String prefix) throws IOException {
        LOG.debug("Aborting multipart uploads under {}", (Object)prefix);
        int count = 0;
        List<MultipartUpload> multipartUploads = this.listMultipartUploads(prefix);
        LOG.debug("Number of outstanding uploads: {}", (Object)multipartUploads.size());
        for (MultipartUpload upload : multipartUploads) {
            try {
                this.abortMultipartUpload(upload);
                ++count;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Already aborted: {}", (Object)upload.getKey(), (Object)e);
            }
        }
        return count;
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        this.activateAuditSpan();
        return this.owner.listMultipartUploads(prefix);
    }

    @Override
    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.abortMultipartUpload(destKey, uploadId, true, this.invoker.getRetryCallback());
    }

    @Override
    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, Long offset) throws IOException {
        return (UploadPartRequest)Invoker.once("upload part request", destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.getRequestFactory().newUploadPartRequest(destKey, uploadId, partNumber, size, uploadStream, sourceFile, offset)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOperationHelper {bucket=").append(this.bucket);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest, PutObjectOptions putOptions) throws IOException {
        return (PutObjectResult)this.retry("Writing Object", putObjectRequest.getKey(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.putObjectDirect(putObjectRequest, putOptions)));
    }

    @Override
    public void uploadObject(PutObjectRequest putObjectRequest, PutObjectOptions putOptions) throws IOException {
        this.retry("Writing Object", putObjectRequest.getKey(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.putObjectDirect(putObjectRequest, putOptions)));
    }

    @Override
    public void revertCommit(String destKey) throws IOException {
        Invoker.once("revert commit", destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            Path destPath = this.owner.keyToQualifiedPath(destKey);
            this.owner.deleteObjectAtPath(destPath, destKey, true);
        }));
    }

    @Override
    public CompleteMultipartUploadResult commitUpload(String destKey, String uploadId, List<PartETag> partETags, long length) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, PutObjectOptions.keepingDirs(), Invoker.NO_OP);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws IOException {
        return (UploadPartResult)this.retry("upload part #" + request.getPartNumber() + " upload ID " + request.getUploadId(), request.getKey(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.uploadPart(request)));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public SelectObjectContentRequest newSelectRequest(Path path) {
        try (AuditSpan span = this.getAuditSpan();){
            SelectObjectContentRequest selectObjectContentRequest = this.getRequestFactory().newSelectRequest(this.storeContext.pathToKey(path));
            return selectObjectContentRequest;
        }
    }

    @Override
    public SelectObjectContentResult select(Path source, SelectObjectContentRequest request, String action) throws IOException {
        String bucketName = request.getBucketName();
        org.apache.hadoop.util.Preconditions.checkArgument((boolean)this.bucket.equals(bucketName), (String)"wrong bucket: %s", (Object[])new Object[]{bucketName});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating select call {} {}", (Object)source, (Object)request.getExpression());
            LOG.debug(SelectBinding.toString(request));
        }
        return (SelectObjectContentResult)this.invoker.retry(action, source.toString(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            DurationInfo ignored = new DurationInfo(LOG, "S3 Select operation", new Object[0]);
            try {
                SelectObjectContentResult selectObjectContentResult = this.writeOperationHelperCallbacks.selectObjectContent(request);
                return selectObjectContentResult;
            }
            catch (AmazonS3Exception e) {
                LOG.error("Failure of S3 Select request against {}", (Object)source);
                LOG.debug("S3 Select request against {}:\n{}", new Object[]{source, SelectBinding.toString(request), e});
                throw e;
            }
            finally {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }));
    }

    public AuditSpan createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return this.auditSpanSource.createSpan(operation, path1, path2);
    }

    @Override
    public void incrementWriteOperations() {
        this.owner.incrementWriteOperations();
    }

    @Override
    public void close() throws IOException {
        this.deactivateAuditSpan();
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public static interface WriteOperationHelperCallbacks {
        public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest var1);

        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest var1);
    }
}

