/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.InvalidQueueNameException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)QueueManager.class.getName());
    public static final String ROOT_QUEUE = "root";
    private final FairScheduler scheduler;
    private final Collection<FSLeafQueue> leafQueues = new CopyOnWriteArrayList<FSLeafQueue>();
    private final Map<String, FSQueue> queues = new HashMap<String, FSQueue>();
    private Set<IncompatibleQueueRemovalTask> incompatibleQueuesPendingRemoval = new HashSet<IncompatibleQueueRemovalTask>();
    private FSParentQueue rootQueue;

    public QueueManager(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public FSParentQueue getRootQueue() {
        return this.rootQueue;
    }

    public void initialize() {
        this.rootQueue = new FSParentQueue(ROOT_QUEUE, this.scheduler, null);
        this.rootQueue.setDynamic(false);
        this.queues.put(this.rootQueue.getName(), this.rootQueue);
        FSLeafQueue defaultQueue = this.getLeafQueue("default", true);
        defaultQueue.setDynamic(false);
        this.rootQueue.reinit(true);
    }

    public FSLeafQueue getLeafQueue(String name, boolean create) {
        return this.getLeafQueue(name, create, null, true);
    }

    public FSLeafQueue getLeafQueue(String name, boolean create, ApplicationId applicationId) {
        return this.getLeafQueue(name, create, applicationId, true);
    }

    private FSLeafQueue getLeafQueue(String name, boolean create, ApplicationId applicationId, boolean recomputeSteadyShares) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.LEAF, recomputeSteadyShares, applicationId);
        if (queue instanceof FSParentQueue) {
            return null;
        }
        return (FSLeafQueue)queue;
    }

    public boolean removeLeafQueue(String name) {
        return !Boolean.FALSE.equals(this.removeEmptyIncompatibleQueues(name = QueueManager.ensureRootPrefix(name), FSQueueType.PARENT).orElse(null));
    }

    public FSParentQueue getParentQueue(String name, boolean create) {
        return this.getParentQueue(name, create, true);
    }

    public FSParentQueue getParentQueue(String name, boolean create, boolean recomputeSteadyShares) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.PARENT, recomputeSteadyShares, null);
        if (queue instanceof FSLeafQueue) {
            return null;
        }
        return (FSParentQueue)queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSQueue getQueue(String name, boolean create, FSQueueType queueType, boolean recomputeSteadyShares, ApplicationId applicationId) {
        FSQueue queue;
        boolean recompute = recomputeSteadyShares;
        name = QueueManager.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            queue = this.queues.get(name);
            if (queue == null && create) {
                queue = this.createQueue(name, queueType);
            } else {
                recompute = false;
            }
            if (applicationId != null && queue instanceof FSLeafQueue) {
                ((FSLeafQueue)queue).addAssignedApp(applicationId);
            }
        }
        if (recompute && queue != null) {
            this.rootQueue.recomputeSteadyShares();
        }
        return queue;
    }

    @VisibleForTesting
    FSQueue createQueue(String name, FSQueueType queueType) {
        ArrayList<String> newQueueNames = new ArrayList<String>();
        FSParentQueue parent = this.buildNewQueueList(name, newQueueNames);
        FSQueue queue = null;
        if (parent != null) {
            queue = this.createNewQueues(queueType, parent, newQueueNames);
        }
        return queue;
    }

    private FSParentQueue buildNewQueueList(String name, List<String> newQueueNames) {
        newQueueNames.add(name);
        int sepIndex = name.length();
        FSParentQueue parent = null;
        while (sepIndex != -1) {
            int prevSepIndex = sepIndex;
            String node = name.substring((sepIndex = name.lastIndexOf(46, sepIndex - 1)) + 1, prevSepIndex);
            if (!this.isQueueNameValid(node)) {
                throw new InvalidQueueNameException("Illegal node name at offset " + (sepIndex + 1) + " for queue name " + name);
            }
            String curName = name.substring(0, sepIndex);
            FSQueue queue = this.queues.get(curName);
            if (queue == null) {
                newQueueNames.add(0, curName);
                continue;
            }
            if (!(queue instanceof FSParentQueue)) break;
            parent = (FSParentQueue)queue;
            break;
        }
        return parent;
    }

    private FSQueue createNewQueues(FSQueueType queueType, FSParentQueue topParent, List<String> newQueueNames) {
        AllocationConfiguration queueConf = this.scheduler.getAllocationConfiguration();
        Iterator<String> i = newQueueNames.iterator();
        FSParentQueue parent = topParent;
        FSQueue queue = null;
        while (i.hasNext()) {
            FSParentQueue newParent = null;
            String queueName = i.next();
            SchedulingPolicy childPolicy = this.scheduler.getAllocationConfiguration().getSchedulingPolicy(queueName);
            if (!parent.getPolicy().isChildPolicyAllowed(childPolicy)) {
                LOG.error("Can't create queue '" + queueName + "',the child scheduling policy is not allowed by parent queue!");
                return null;
            }
            if (!i.hasNext() && queueType != FSQueueType.PARENT) {
                FSLeafQueue leafQueue = new FSLeafQueue(queueName, this.scheduler, parent);
                leafQueue.setLabel(leafQueue.refreshLabel());
                leafQueue.setDefaultLabel(queueConf.getDefaultQueueLabel());
                leafQueue.updateLabel();
                this.leafQueues.add(leafQueue);
                queue = leafQueue;
            } else {
                if (childPolicy instanceof FifoPolicy) {
                    LOG.error("Can't create queue '" + queueName + "', since " + "FIFO" + " is only for leaf queues.");
                    return null;
                }
                queue = newParent = new FSParentQueue(queueName, this.scheduler, parent);
            }
            parent.addChildQueue(queue);
            this.setChildResourceLimits(parent, queue, queueConf);
            this.queues.put(queue.getName(), queue);
            parent = newParent;
        }
        return queue;
    }

    private void setChildResourceLimits(FSParentQueue parent, FSQueue child, AllocationConfiguration queueConf) {
        ConfigurableResource maxChild;
        Map<FSQueueType, Set<String>> configuredQueues = queueConf.getConfiguredQueues();
        if (!configuredQueues.get((Object)FSQueueType.LEAF).contains(child.getName()) && !configuredQueues.get((Object)FSQueueType.PARENT).contains(child.getName()) && (maxChild = parent.getMaxChildQueueResource()) != null) {
            child.setMaxShare(maxChild);
        }
    }

    private Optional<Boolean> removeEmptyIncompatibleQueues(String queueToCreate, FSQueueType queueType) {
        if ((queueToCreate = QueueManager.ensureRootPrefix(queueToCreate)).equals(ROOT_QUEUE) || queueToCreate.startsWith("root.default.")) {
            return Optional.empty();
        }
        FSQueue queue = this.queues.get(queueToCreate);
        if (queue != null) {
            if (queue instanceof FSLeafQueue) {
                if (queueType == FSQueueType.LEAF) {
                    return Optional.empty();
                }
                return Optional.of(this.removeQueueIfEmpty(queue));
            }
            if (queueType == FSQueueType.PARENT) {
                return Optional.empty();
            }
            return Optional.of(this.removeQueueIfEmpty(queue));
        }
        int sepIndex = queueToCreate.length();
        sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        while (sepIndex != -1) {
            String prefixString = queueToCreate.substring(0, sepIndex);
            FSQueue prefixQueue = this.queues.get(prefixString);
            if (prefixQueue != null && prefixQueue instanceof FSLeafQueue) {
                return Optional.of(this.removeQueueIfEmpty(prefixQueue));
            }
            sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEmptyDynamicQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            HashSet<FSParentQueue> parentQueuesToCheck = new HashSet<FSParentQueue>();
            for (FSQueue queue : this.getQueues()) {
                boolean removed;
                if (!queue.isDynamic() || !queue.getChildQueues().isEmpty() || !(removed = this.removeQueueIfEmpty(queue)) || !queue.getParent().isDynamic()) continue;
                parentQueuesToCheck.add(queue.getParent());
            }
            while (!parentQueuesToCheck.isEmpty()) {
                FSParentQueue queue = (FSParentQueue)parentQueuesToCheck.iterator().next();
                if (queue.isEmpty()) {
                    this.removeQueue(queue);
                    if (queue.getParent().isDynamic()) {
                        parentQueuesToCheck.add(queue.getParent());
                    }
                }
                parentQueuesToCheck.remove(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingIncompatibleQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            for (IncompatibleQueueRemovalTask removalTask : ImmutableSet.copyOf(this.incompatibleQueuesPendingRemoval)) {
                removalTask.execute();
            }
        }
    }

    private boolean removeQueueIfEmpty(FSQueue queue) {
        if (queue.isEmpty()) {
            this.removeQueue(queue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeQueue(FSQueue queue) {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            if (queue instanceof FSLeafQueue) {
                this.leafQueues.remove(queue);
            } else {
                for (FSQueue childQueue : queue.getChildQueues()) {
                    this.removeQueue(childQueue);
                }
            }
            this.queues.remove(queue.getName());
            FSParentQueue parent = queue.getParent();
            parent.removeChildQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSQueue getQueue(String name) {
        name = QueueManager.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        name = QueueManager.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSLeafQueue> getLeafQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.leafQueues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSQueue> getQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return ImmutableList.copyOf(this.queues.values());
        }
    }

    private static String ensureRootPrefix(String name) {
        if (!name.startsWith("root.") && !name.equals(ROOT_QUEUE)) {
            name = "root." + name;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllocationConfiguration(AllocationConfiguration queueConf) {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            if (!this.rootQueue.verifyAndSetPolicyFromConf(queueConf)) {
                LOG.error("Setting scheduling policies for existing queues failed!");
            }
            this.ensureQueueExistsAndIsCompatibleAndIsStatic(queueConf, FSQueueType.LEAF);
            this.ensureQueueExistsAndIsCompatibleAndIsStatic(queueConf, FSQueueType.PARENT);
        }
        this.rootQueue.reinit(true);
        this.rootQueue.recomputeSteadyShares();
    }

    private void ensureQueueExistsAndIsCompatibleAndIsStatic(AllocationConfiguration queueConf, FSQueueType queueType) {
        for (String name : queueConf.getConfiguredQueues().get((Object)queueType)) {
            Boolean removed = this.removeEmptyIncompatibleQueues(name, queueType).orElse(null);
            if (Boolean.FALSE.equals(removed)) {
                this.incompatibleQueuesPendingRemoval.add(new IncompatibleQueueRemovalTask(name, queueType));
                continue;
            }
            FSQueue queue = this.getQueue(name, true, queueType, false, null);
            if (queue == null) continue;
            queue.setDynamic(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setQueuesToDynamic(Set<String> queueNames) {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            for (String queueName : queueNames) {
                this.queues.get(queueName).setDynamic(true);
            }
        }
    }

    @VisibleForTesting
    boolean isQueueNameValid(String node) {
        return !node.isEmpty() && node.equals(FairSchedulerUtilities.trimQueueName(node));
    }

    private final class IncompatibleQueueRemovalTask {
        private final String queueToCreate;
        private final FSQueueType queueType;

        private IncompatibleQueueRemovalTask(String queueToCreate, FSQueueType queueType) {
            this.queueToCreate = queueToCreate;
            this.queueType = queueType;
        }

        private void execute() {
            FSQueue queue;
            Boolean removed = QueueManager.this.removeEmptyIncompatibleQueues(this.queueToCreate, this.queueType).orElse(null);
            if (Boolean.TRUE.equals(removed) && (queue = QueueManager.this.getQueue(this.queueToCreate, true, this.queueType, false, null)) != null && ((QueueManager)QueueManager.this).scheduler.allocConf.configuredQueues.values().stream().anyMatch(s -> s.contains(this.queueToCreate))) {
                queue.setDynamic(false);
            }
            if (!Boolean.FALSE.equals(removed)) {
                QueueManager.this.incompatibleQueuesPendingRemoval.remove(this);
            }
        }
    }
}

