/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.finance.portfolio.EquilibriumModel;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.BasicMatrix;

public final class FixedWeightsPortfolio
extends EquilibriumModel {
    private final BasicMatrix myWeights;

    public FixedWeightsPortfolio(FinancePortfolio.Context aContext, FinancePortfolio weightsPortfolio) {
        super(aContext);
        this.myWeights = (BasicMatrix)FinancePortfolio.MATRIX_FACTORY.columns(weightsPortfolio.getWeights());
    }

    public FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium, BasicMatrix assetWeightsInColumn) {
        super(aMarketEquilibrium);
        this.myWeights = assetWeightsInColumn;
    }

    private FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myWeights = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio.Context targetReturns) {
        this.calibrate(this.myWeights, targetReturns.getAssetReturns());
    }

    public void calibrate(List<? extends Number> targetReturns) {
        this.calibrate(this.myWeights, (BasicMatrix)FinancePortfolio.MATRIX_FACTORY.columns(targetReturns));
    }

    @Override
    protected BasicMatrix calculateAssetReturns() {
        return this.calculateAssetReturns(this.myWeights);
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        return this.myWeights;
    }
}

