/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.CustomOutputCommitter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRAppWithCombiner {
    protected static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static FileSystem localFs;
    private static final Logger LOG;

    @BeforeClass
    public static void setup() throws IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(TestMRJobs.class.getName(), 3);
            Configuration conf = new Configuration();
            conf.setBoolean("yarn.webapp.api-service.enable", false);
            mrCluster.init(conf);
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), TestMRJobs.APP_JAR);
        localFs.setPermission(TestMRJobs.APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
    }

    @Test
    public void testCombinerShouldUpdateTheReporter() throws Exception {
        JobConf conf = new JobConf(mrCluster.getConfig());
        int numMaps = 5;
        int numReds = 2;
        Path in = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "testCombinerShouldUpdateTheReporter-in");
        Path out = new Path(mrCluster.getTestWorkDir().getAbsolutePath(), "testCombinerShouldUpdateTheReporter-out");
        TestMRAppWithCombiner.createInputOutPutFolder(in, out, numMaps);
        conf.setJobName("test-job-with-combiner");
        conf.setMapperClass(IdentityMapper.class);
        conf.setCombinerClass(MyCombinerToCheckReporter.class);
        conf.setReducerClass(IdentityReducer.class);
        Job.addFileToClassPath((Path)TestMRJobs.APP_JAR, (Configuration)conf, (FileSystem)TestMRJobs.APP_JAR.getFileSystem((Configuration)conf));
        conf.setOutputCommitter(CustomOutputCommitter.class);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{in});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)out);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReds);
        TestMRAppWithCombiner.runJob(conf);
    }

    static void createInputOutPutFolder(Path inDir, Path outDir, int numMaps) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        for (int i = 0; i < numMaps; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
    }

    static boolean runJob(JobConf conf) throws Exception {
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        return jobClient.monitorAndPrintJob(conf, job);
    }

    static {
        conf = new Configuration();
        LOG = LoggerFactory.getLogger(TestMRAppWithCombiner.class);
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
    }

    class MyCombinerToCheckReporter<K, V>
    extends IdentityReducer<K, V> {
        MyCombinerToCheckReporter() {
        }

        public void reduce(K key, Iterator<V> values, OutputCollector<K, V> output, Reporter reporter) throws IOException {
            if (Reporter.NULL == reporter) {
                Assert.fail((String)"A valid Reporter should have been used but, Reporter.NULL is used");
            }
        }
    }
}

