/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyFilter;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DiffInfo;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.FileListingEntry;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.ProducerConsumer;
import org.apache.hadoop.tools.util.WorkReport;
import org.apache.hadoop.tools.util.WorkRequest;
import org.apache.hadoop.tools.util.WorkRequestProcessor;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCopyListing
extends CopyListing {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleCopyListing.class);
    public static final int DEFAULT_FILE_STATUS_SIZE = 1000;
    public static final boolean DEFAULT_RANDOMIZE_FILE_LISTING = true;
    private long totalPaths = 0L;
    private long totalDirs = 0L;
    private long totalBytesToCopy = 0L;
    private int numListstatusThreads = 1;
    private final int fileStatusLimit;
    private final boolean randomizeFileListing;
    private final int maxRetries = 3;
    private CopyFilter copyFilter;
    private DistCpSync distCpSync;
    public static Map<String, Set<String>> loopLocator = new HashMap<String, Set<String>>();
    private final Random rnd = new Random();

    protected SimpleCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.numListstatusThreads = this.getConf().getInt("distcp.liststatus.threads", 1);
        this.fileStatusLimit = Math.max(1, this.getConf().getInt("distcp.simplelisting.file.status.size", 1000));
        this.randomizeFileListing = this.getConf().getBoolean("distcp.simplelisting.randomize.files", true);
        LOG.debug("numListstatusThreads={}, fileStatusLimit={}, randomizeFileListing={}", new Object[]{this.numListstatusThreads, this.fileStatusLimit, this.randomizeFileListing});
        this.copyFilter = CopyFilter.getCopyFilter(this.getConf());
        this.copyFilter.initialize();
    }

    @VisibleForTesting
    protected SimpleCopyListing(Configuration configuration, Credentials credentials, int numListstatusThreads, int fileStatusLimit, boolean randomizeFileListing) {
        super(configuration, credentials);
        this.numListstatusThreads = numListstatusThreads;
        this.fileStatusLimit = Math.max(1, fileStatusLimit);
        this.randomizeFileListing = randomizeFileListing;
    }

    protected SimpleCopyListing(Configuration configuration, Credentials credentials, DistCpSync distCpSync) {
        this(configuration, credentials);
        this.distCpSync = distCpSync;
    }

    @Override
    protected void validatePaths(DistCpContext context) throws IOException, CopyListing.InvalidInputException {
        Credentials credentials;
        Path targetPath = context.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(this.getConf());
        boolean targetExists = false;
        boolean targetIsFile = false;
        try {
            targetIsFile = targetFS.getFileStatus(targetPath).isFile();
            targetExists = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        targetPath = targetFS.makeQualified(targetPath);
        boolean targetIsReservedRaw = Path.getPathWithoutSchemeAndAuthority((Path)targetPath).toString().startsWith("/.reserved/raw");
        if (targetIsFile) {
            if (context.getSourcePaths().size() > 1) {
                throw new CopyListing.InvalidInputException("Multiple source being copied to a file: " + targetPath);
            }
            Path srcPath = context.getSourcePaths().get(0);
            FileSystem sourceFS = srcPath.getFileSystem(this.getConf());
            if (!sourceFS.isFile(srcPath)) {
                throw new CopyListing.InvalidInputException("Cannot copy " + srcPath + ", which is not a file to " + targetPath);
            }
        }
        if (context.shouldAtomicCommit() && targetExists) {
            throw new CopyListing.InvalidInputException("Target path for atomic-commit already exists: " + targetPath + ". Cannot atomic-commit to pre-existing target-path.");
        }
        for (Path path : context.getSourcePaths()) {
            FileSystem fs = path.getFileSystem(this.getConf());
            if (!fs.exists(path)) {
                throw new CopyListing.InvalidInputException(path + " doesn't exist");
            }
            if (Path.getPathWithoutSchemeAndAuthority((Path)path).toString().startsWith("/.reserved/raw")) {
                if (targetIsReservedRaw) continue;
                String msg = "The source path '" + path + "' starts with " + "/.reserved/raw" + " but the target path '" + targetPath + "' does not. Either all or none of the paths must have this prefix.";
                throw new CopyListing.InvalidInputException(msg);
            }
            if (!targetIsReservedRaw) continue;
            String msg = "The target path '" + targetPath + "' starts with " + "/.reserved/raw" + " but the source path '" + path + "' does not. Either all or none of the paths must have this prefix.";
            throw new CopyListing.InvalidInputException(msg);
        }
        if (targetIsReservedRaw) {
            context.setPreserveRawXattrs(true);
            this.getConf().setBoolean("distcp.preserve.rawxattrs", true);
        }
        if ((credentials = this.getCredentials()) != null) {
            Path[] inputPaths = context.getSourcePaths().toArray(new Path[1]);
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])inputPaths, (Configuration)this.getConf());
        }
    }

    @Override
    protected void doBuildListing(Path pathToListingFile, DistCpContext context) throws IOException {
        if (context.shouldUseSnapshotDiff()) {
            this.doBuildListingWithSnapshotDiff(this.getWriter(pathToListingFile), context);
        } else {
            this.doBuildListing(this.getWriter(pathToListingFile), context);
        }
    }

    private Path getPathWithSchemeAndAuthority(Path path) throws IOException {
        String authority;
        FileSystem fs = path.getFileSystem(this.getConf());
        String scheme = path.toUri().getScheme();
        if (scheme == null) {
            scheme = fs.getUri().getScheme();
        }
        if ((authority = path.toUri().getAuthority()) == null) {
            authority = fs.getUri().getAuthority();
        }
        return new Path(scheme, authority, this.makeQualified(path).toUri().getPath());
    }

    private void addToFileListing(SequenceFile.Writer fileListWriter, Path sourceRoot, Path path, DistCpContext context) throws IOException {
        sourceRoot = this.getPathWithSchemeAndAuthority(sourceRoot);
        path = this.getPathWithSchemeAndAuthority(path);
        path = this.makeQualified(path);
        FileSystem sourceFS = sourceRoot.getFileSystem(this.getConf());
        FileStatus fileStatus = sourceFS.getFileStatus(path);
        FileListingEntry listingEntry = DistCpUtils.getOriginalFileStatus(fileStatus, this.getConf(), context.shouldKeepLinks(), loopLocator);
        boolean preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
        boolean preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
        boolean preserveRawXAttrs = context.shouldPreserveRawXattrs();
        String relativePathPrefix = listingEntry.getSourceRealPath().getPath().equals((Object)sourceRoot) ? "" : "/" + listingEntry.getSourceRealPath().getPath().getName();
        DistCpUtils.toCopyListingFileStatus(sourceFS, listingEntry, preserveAcls, preserveXAttrs, preserveRawXAttrs, context.getBlocksPerChunk());
        this.writeToFileListingRoot(fileListWriter, listingEntry, sourceRoot, context, relativePathPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void doBuildListingWithSnapshotDiff(SequenceFile.Writer fileListWriter, DistCpContext context) throws IOException {
        ArrayList<DiffInfo> diffList = this.distCpSync.prepareDiffListForCopyListing();
        Path sourceRoot = context.getSourcePaths().get(0);
        FileSystem sourceFS = sourceRoot.getFileSystem(this.getConf());
        boolean traverseDirectory = this.getConf().getBoolean("distcp.diff.copy.listing.traverse.directory", true);
        try {
            ArrayList fileStatuses = Lists.newArrayList();
            for (DiffInfo diff : diffList) {
                diff.setTarget(new Path(context.getSourcePaths().get(0), diff.getTarget()));
                if (diff.getType() == SnapshotDiffReport.DiffType.MODIFY) {
                    this.addToFileListing(fileListWriter, sourceRoot, diff.getTarget(), context);
                    continue;
                }
                if (diff.getType() != SnapshotDiffReport.DiffType.CREATE) continue;
                this.addCreateDiffsToFileListing(fileListWriter, context, sourceRoot, sourceFS, fileStatuses, diff, traverseDirectory);
            }
            if (this.randomizeFileListing) {
                this.writeToFileListing(fileStatuses, fileListWriter);
            }
            fileListWriter.close();
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private void addCreateDiffsToFileListing(SequenceFile.Writer fileListWriter, DistCpContext context, Path sourceRoot, FileSystem sourceFS, List<FileStatusInfo> fileStatuses, DiffInfo diff, boolean traverseDirectory) throws IOException {
        this.addToFileListing(fileListWriter, sourceRoot, diff.getTarget(), context);
        if (traverseDirectory) {
            String relativePathPrefix;
            FileStatus sourceStatus = sourceFS.getFileStatus(diff.getTarget());
            FileListingEntry listingEntryRoot = DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), context.shouldKeepLinks(), loopLocator);
            String string = relativePathPrefix = listingEntryRoot.getSourceRealPath().getPath().equals((Object)sourceStatus) ? "" : "/" + listingEntryRoot.getSourceRealPath().getPath().getName();
            if (listingEntryRoot.getSourceRealPath().isDirectory()) {
                LOG.debug("Adding source dir for traverse: {}", (Object)sourceStatus.getPath());
                HashSet<String> excludeList = this.distCpSync.getTraverseExcludeList(diff.getSource(), context.getSourcePaths().get(0));
                ArrayList<FileListingEntry> sourceDirs = new ArrayList<FileListingEntry>();
                sourceDirs.add(listingEntryRoot);
                new TraverseDirectory(fileListWriter, sourceFS, sourceDirs, relativePathPrefix, context, excludeList, fileStatuses).traverseDirectory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void doBuildListing(SequenceFile.Writer fileListWriter, DistCpContext context) throws IOException {
        if (context.getNumListstatusThreads() > 0) {
            this.numListstatusThreads = context.getNumListstatusThreads();
        }
        try {
            ArrayList statusList = Lists.newArrayList();
            for (Path path : context.getSourcePaths()) {
                boolean explore;
                FileSystem sourceFS = path.getFileSystem(this.getConf());
                boolean preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
                boolean preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
                boolean preserveRawXAttrs = context.shouldPreserveRawXattrs();
                boolean keepLinks = context.shouldKeepLinks();
                path = this.makeQualified(path);
                FileStatus rootStatus = sourceFS.getFileStatus(path);
                FileListingEntry listingEntryRoot = DistCpUtils.getOriginalFileStatus(rootStatus, this.getConf(), keepLinks, loopLocator);
                FileStatus[] sourceFiles = sourceFS.listStatus(listingEntryRoot.getSourceRealPath().getPath());
                Path sourcePathRoot = this.computeSourceRootPath(listingEntryRoot.getSourceRealPath(), context);
                String relativePathPrefix = listingEntryRoot.getSourceRealPath().getPath().equals((Object)sourcePathRoot) ? "" : "/" + listingEntryRoot.getSourceRealPath().getPath().getName();
                boolean bl = explore = sourceFiles != null && sourceFiles.length > 0;
                if (!explore || rootStatus.isDirectory() || rootStatus.isSymlink() && listingEntryRoot.getSourceRealPath().isDirectory() || rootStatus.isSymlink() && keepLinks) {
                    DistCpUtils.toCopyListingFileStatus(sourceFS, listingEntryRoot, preserveAcls, preserveXAttrs, preserveRawXAttrs, context.getBlocksPerChunk());
                    this.writeToFileListingRoot(fileListWriter, listingEntryRoot, sourcePathRoot, context, relativePathPrefix);
                }
                if (!explore || keepLinks && rootStatus.isSymlink()) continue;
                ArrayList<FileListingEntry> sourceDirs = new ArrayList<FileListingEntry>();
                for (FileStatus sourceStatus : sourceFiles) {
                    LOG.debug("Recording source-path: {} for copy.", (Object)sourceStatus.getPath());
                    FileListingEntry listingEntry = DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), keepLinks, loopLocator);
                    DistCpUtils.toCopyListingFileStatus(sourceFS, listingEntry, preserveAcls && listingEntry.getSourceRealPath().isDirectory(), preserveXAttrs && listingEntry.getSourceRealPath().isDirectory(), preserveRawXAttrs && listingEntry.getSourceRealPath().isDirectory(), context.getBlocksPerChunk());
                    if (this.randomizeFileListing) {
                        for (CopyListingFileStatus fs : listingEntry.getCopyListingFileStatus()) {
                            this.addToFileListing(statusList, new FileStatusInfo(fs, sourcePathRoot), fileListWriter);
                        }
                    } else {
                        this.writeToFileListing(fileListWriter, listingEntry, relativePathPrefix + DistCpUtils.getRelativePath(listingEntry), true);
                    }
                    if (!listingEntry.getSourceRealPath().isDirectory()) continue;
                    LOG.debug("Adding source dir for traverse: {}", (Object)listingEntry.getSourceRealPath().getPath());
                    sourceDirs.add(listingEntry);
                }
                new TraverseDirectory(fileListWriter, sourceFS, sourceDirs, sourcePathRoot.toString(), context, null, statusList).traverseDirectory();
            }
            if (this.randomizeFileListing) {
                this.writeToFileListing(statusList, fileListWriter);
            }
            fileListWriter.close();
            this.printStats();
            LOG.info("Build file listing completed.");
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private void addToFileListing(List<FileStatusInfo> fileStatusInfoList, FileStatusInfo statusInfo, SequenceFile.Writer fileListWriter) throws IOException {
        fileStatusInfoList.add(statusInfo);
        if (fileStatusInfoList.size() > this.fileStatusLimit) {
            this.writeToFileListing(fileStatusInfoList, fileListWriter);
        }
    }

    @VisibleForTesting
    void setSeedForRandomListing(long seed) {
        this.rnd.setSeed(seed);
    }

    private void writeToFileListing(List<FileStatusInfo> fileStatusInfoList, SequenceFile.Writer fileListWriter) throws IOException {
        Collections.shuffle(fileStatusInfoList, this.rnd);
        for (FileStatusInfo fileStatusInfo : fileStatusInfoList) {
            LOG.debug("Adding {}", (Object)fileStatusInfo.fileStatus.getPath());
            this.writeToFileListing(fileListWriter, fileStatusInfo.fileStatus, fileStatusInfo.sourceRootPath);
        }
        LOG.debug("Number of paths written to fileListing={}", (Object)fileStatusInfoList.size());
        fileStatusInfoList.clear();
    }

    private Path computeSourceRootPath(FileStatus sourceStatus, DistCpContext context) throws IOException {
        boolean simpleFile;
        boolean solitaryFile;
        Path target = context.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean targetPathExists = context.isTargetPathExists();
        boolean bl = solitaryFile = context.getSourcePaths().size() == 1 && !sourceStatus.isDirectory() && (!sourceStatus.isSymlink() || !DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), context.shouldKeepLinks(), loopLocator).getSourceRealPath().isDirectory());
        if (solitaryFile) {
            return sourceStatus.getPath();
        }
        boolean specialHandling = context.getSourcePaths().size() == 1 && !targetPathExists || context.shouldSyncFolder() || context.shouldOverwrite();
        boolean bl2 = simpleFile = !sourceStatus.isDirectory() && (!sourceStatus.isSymlink() || !DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), context.shouldKeepLinks(), loopLocator).getSourceRealPath().isDirectory());
        if (specialHandling && (sourceStatus.isDirectory() || !simpleFile) || simpleFile || sourceStatus.getPath().isRoot()) {
            return sourceStatus.getPath();
        }
        return sourceStatus.getPath().getParent();
    }

    protected boolean shouldCopy(Path path) {
        return this.copyFilter.shouldCopy(path);
    }

    @Override
    protected long getBytesToCopy() {
        return this.totalBytesToCopy;
    }

    @Override
    protected long getNumberOfPaths() {
        return this.totalPaths;
    }

    private Path makeQualified(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(this.getConf());
        fs.delete(pathToListFile, false);
        return SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CopyListingFileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
    }

    private void printStats() {
        LOG.info("Paths (files+dirs) cnt = {}; dirCnt = {}", (Object)this.totalPaths, (Object)this.totalDirs);
    }

    private void maybePrintStats() {
        if (this.totalPaths % 100000L == 0L) {
            this.printStats();
        }
    }

    private void writeToFileListingRoot(SequenceFile.Writer fileListWriter, FileListingEntry listingEntry, Path sourcePathRoot, DistCpContext context, String relativePathPrefix) throws IOException {
        boolean skipRootPath;
        boolean syncOrOverwrite = context.shouldSyncFolder() || context.shouldOverwrite();
        boolean bl = skipRootPath = syncOrOverwrite && !context.shouldUpdateRoot();
        if (listingEntry.getSourceRealPath().getPath().equals((Object)sourcePathRoot) && listingEntry.getSourceRealPath().isDirectory() && skipRootPath) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skip " + listingEntry.getSourceRealPath().getPath());
            }
            return;
        }
        this.writeToFileListing(fileListWriter, listingEntry, relativePathPrefix, true);
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, CopyListingFileStatus fileStatus, Path sourcePathRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("REL PATH: " + DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath()) + ", FULL PATH: " + fileStatus.getPath());
        }
        if (!this.shouldCopy(fileStatus.getPath())) {
            return;
        }
        FileSystem fs = sourcePathRoot.getFileSystem(this.getConf());
        FileStatus srcFileStatus = fs.getFileStatus(sourcePathRoot);
        if (srcFileStatus.isFile() && !fileStatus.isDirectory() && sourcePathRoot.equals((Object)fileStatus.getPath())) {
            fileListWriter.append((Writable)new Text("/" + fileStatus.getPath().getName()), (Writable)fileStatus);
        } else {
            fileListWriter.append((Writable)new Text(DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getSourceLink() != null ? fileStatus.getSourceLink() : fileStatus.getPath())), (Writable)fileStatus);
        }
        fileListWriter.sync();
        if (!fileStatus.isDirectory()) {
            this.totalBytesToCopy += fileStatus.getSizeToCopy();
        } else {
            ++this.totalDirs;
        }
        ++this.totalPaths;
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, FileListingEntry listingEntry, String path, boolean isRelative) throws IOException {
        for (CopyListingFileStatus fileStatus : listingEntry.getCopyListingFileStatus()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RELATIVE TARGET PATH: " + path + ", REAL FILE PATH: " + fileStatus.getPath());
            }
            if (!this.shouldCopy(fileStatus.getPath())) {
                return;
            }
            if (!isRelative && !path.isBlank()) {
                path = DistCpUtils.getRelativePath(new Path(path), listingEntry.getSourceLinkPath() == null ? fileStatus.getPath() : listingEntry.getSourceLinkPath());
            }
            fileListWriter.append((Writable)new Text(path), (Writable)this.getFileListingValue(fileStatus));
            fileListWriter.sync();
            if (!fileStatus.isDirectory()) {
                this.totalBytesToCopy += fileStatus.getSizeToCopy();
            } else {
                ++this.totalDirs;
            }
            ++this.totalPaths;
            this.maybePrintStats();
        }
    }

    private final class TraverseDirectory {
        private SequenceFile.Writer fileListWriter;
        private FileSystem sourceFS;
        private ArrayList<FileListingEntry> sourceDirs;
        private String sourceRootPath;
        private DistCpContext context;
        private HashSet<String> excludeList;
        private List<FileStatusInfo> fileStatuses;
        private final boolean preserveAcls;
        private final boolean preserveXAttrs;
        private final boolean preserveRawXattrs;

        private TraverseDirectory(SequenceFile.Writer fileListWriter, FileSystem sourceFS, ArrayList<FileListingEntry> sourceDirs, String sourceRootPath, DistCpContext context, HashSet<String> excludeList, List<FileStatusInfo> fileStatuses) {
            this.fileListWriter = fileListWriter;
            this.sourceFS = sourceFS;
            this.sourceDirs = sourceDirs;
            this.sourceRootPath = sourceRootPath;
            this.context = context;
            this.excludeList = excludeList;
            this.fileStatuses = fileStatuses;
            this.preserveAcls = context.shouldPreserve(DistCpOptions.FileAttribute.ACL);
            this.preserveXAttrs = context.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
            this.preserveRawXattrs = context.shouldPreserveRawXattrs();
        }

        public void traverseDirectory() throws IOException {
            if (this.context.shouldUseIterator()) {
                try (DurationInfo ignored = new DurationInfo(LOG, "Building listing using iterator mode for %s", new Object[]{this.sourceRootPath});){
                    this.traverseDirectoryLegacy();
                }
            }
            try (DurationInfo ignored = new DurationInfo(LOG, "Building listing using multi threaded approach for %s", new Object[]{this.sourceRootPath});){
                this.traverseDirectoryMultiThreaded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void traverseDirectoryMultiThreaded() throws IOException {
            assert (SimpleCopyListing.this.numListstatusThreads > 0);
            LOG.debug("Starting thread pool of {} listStatus workers.", (Object)SimpleCopyListing.this.numListstatusThreads);
            ProducerConsumer<FileListingEntry, List<FileListingEntry>> workers = new ProducerConsumer<FileListingEntry, List<FileListingEntry>>(SimpleCopyListing.this.numListstatusThreads);
            try {
                for (int i = 0; i < SimpleCopyListing.this.numListstatusThreads; ++i) {
                    workers.addWorker(new FileStatusProcessor(this.sourceFS, this.excludeList));
                }
                for (FileListingEntry entry : this.sourceDirs) {
                    workers.put(new WorkRequest<FileListingEntry>(entry, 0));
                }
                while (workers.hasWork()) {
                    try {
                        WorkReport workResult = workers.take();
                        int retry = workResult.getRetry();
                        List childs = (List)workResult.getItem();
                        for (FileListingEntry child : childs) {
                            LOG.debug("Recording source-path: {} for copy.", (Object)child.getSourceRealPath().getPath());
                            boolean isChildDirectory = child.getSourceRealPath().isDirectory();
                            if (workResult.getSuccess()) {
                                boolean isTmpChildDirectory = child.getSourceRealPath().isDirectory();
                                DistCpUtils.toCopyListingFileStatus(this.sourceFS, child, this.preserveAcls && isTmpChildDirectory, this.preserveXAttrs && isTmpChildDirectory, this.preserveRawXattrs && isTmpChildDirectory, this.context.getBlocksPerChunk());
                                if (SimpleCopyListing.this.randomizeFileListing) {
                                    for (CopyListingFileStatus fs : child.getCopyListingFileStatus()) {
                                        SimpleCopyListing.this.addToFileListing(this.fileStatuses, new FileStatusInfo(fs, new Path(this.sourceRootPath)), this.fileListWriter);
                                    }
                                } else {
                                    SimpleCopyListing.this.writeToFileListing(this.fileListWriter, child, this.sourceRootPath, false);
                                }
                            }
                            if (retry < 3) {
                                if (!isChildDirectory) continue;
                                LOG.debug("Traversing into source dir: {}", (Object)child.getSourceRealPath().getPath());
                                workers.put(new WorkRequest<FileListingEntry>(child, retry));
                                continue;
                            }
                            LOG.error("Giving up on {} after {} retries.", (Object)child.getSourceRealPath().getPath(), (Object)retry);
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Could not get item from childQueue. Retrying...");
                    }
                }
            }
            finally {
                workers.shutdown();
            }
        }

        private void traverseDirectoryLegacy() throws IOException {
            Stack<FileListingEntry> pathStack = new Stack<FileListingEntry>();
            for (FileListingEntry entry : this.sourceDirs) {
                FileListingEntry tmpFS = DistCpUtils.getOriginalFileStatus(entry.getSourceRealPath(), SimpleCopyListing.this.getConf(), entry.isKeepLink(), loopLocator);
                if (this.excludeList != null && this.excludeList.contains(tmpFS.getSourceRealPath().getPath().toUri().getPath())) continue;
                pathStack.add(tmpFS);
            }
            while (!pathStack.isEmpty()) {
                this.prepareListing(((FileListingEntry)pathStack.pop()).getSourceRealPath().getPath());
            }
        }

        private void prepareListing(Path path) throws IOException {
            LOG.debug("Recording source-path: {} for copy.", (Object)path);
            RemoteIterator listStatus = RemoteIterators.filteringRemoteIterator((RemoteIterator)this.sourceFS.listStatusIterator(path), i -> this.excludeList == null || !this.excludeList.contains(i.getPath().toUri().getPath()));
            while (listStatus.hasNext()) {
                FileStatus childFS = (FileStatus)listStatus.next();
                FileListingEntry child = DistCpUtils.getOriginalFileStatus(childFS, SimpleCopyListing.this.getConf(), this.context.shouldKeepLinks(), loopLocator);
                boolean childDirectory = child.getSourceRealPath().isDirectory();
                DistCpUtils.toCopyListingFileStatus(this.sourceFS, child, this.preserveAcls && childDirectory, this.preserveXAttrs && childDirectory, this.preserveRawXattrs && childDirectory, this.context.getBlocksPerChunk());
                if (SimpleCopyListing.this.randomizeFileListing) {
                    for (CopyListingFileStatus fs : child.getCopyListingFileStatus()) {
                        SimpleCopyListing.this.addToFileListing(this.fileStatuses, new FileStatusInfo(fs, new Path(this.sourceRootPath)), this.fileListWriter);
                    }
                } else {
                    SimpleCopyListing.this.writeToFileListing(this.fileListWriter, child, this.sourceRootPath, false);
                }
                if (!childDirectory) continue;
                LOG.debug("Traversing into source dir: {}", (Object)child.getSourceRealPath().getPath());
                this.prepareListing(child.getSourceRealPath().getPath());
            }
            IOStatisticsLogging.logIOStatisticsAtDebug((Logger)LOG, (String)"RemoteIterator Statistics: {}", (Object)listStatus);
        }
    }

    private static class FileStatusProcessor
    implements WorkRequestProcessor<FileListingEntry, List<FileListingEntry>> {
        private FileSystem fileSystem;
        private HashSet<String> excludeList;

        public FileStatusProcessor(FileSystem fileSystem, HashSet<String> excludeList) {
            this.fileSystem = fileSystem;
            this.excludeList = excludeList;
        }

        private FileStatus[] getFileStatus(Path path) throws IOException {
            FileStatus[] fileStatuses = this.fileSystem.listStatus(path);
            if (this.excludeList != null && this.excludeList.size() > 0) {
                ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
                for (FileStatus status : fileStatuses) {
                    if (this.excludeList.contains(status.getPath().toUri().getPath())) continue;
                    fileStatusList.add(status);
                }
                fileStatuses = fileStatusList.toArray(new FileStatus[fileStatusList.size()]);
            }
            return fileStatuses;
        }

        @Override
        public WorkReport<List<FileListingEntry>> processItem(WorkRequest<FileListingEntry> workRequest) {
            FileListingEntry parent = workRequest.getItem();
            int retry = workRequest.getRetry();
            WorkReport<List<FileListingEntry>> result = null;
            try {
                if (retry > 0) {
                    int sleepSeconds = 2;
                    for (int i = 1; i < retry; ++i) {
                        sleepSeconds *= 2;
                    }
                    try {
                        Thread.sleep(1000 * sleepSeconds);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted while sleeping in exponential backoff.");
                    }
                }
                FileStatus[] childFileStatusList = this.fileSystem.listStatus(parent.getSourceRealPath().getPath());
                ArrayList<FileListingEntry> childEntryList = new ArrayList<FileListingEntry>();
                for (FileStatus status : childFileStatusList) {
                    FileListingEntry childListingEntry = DistCpUtils.getOriginalFileStatus(status, new Configuration(), parent.isKeepLink(), loopLocator);
                    childListingEntry.setParent(parent);
                    childEntryList.add(childListingEntry);
                }
                result = new WorkReport(childEntryList, retry, true);
            }
            catch (FileNotFoundException fnf) {
                LOG.error("FileNotFoundException exception in listStatus: {}", (Object)fnf.getMessage());
                result = new WorkReport<List<FileListingEntry>>(new ArrayList(), retry, true, fnf);
            }
            catch (Exception e) {
                LOG.error("Exception in listStatus. Will send for retry.");
                ArrayList<FileListingEntry> childEntryList = new ArrayList<FileListingEntry>();
                childEntryList.add(parent);
                result = new WorkReport(childEntryList, retry + 1, false, e);
            }
            return result;
        }
    }

    private static class FileStatusInfo {
        private CopyListingFileStatus fileStatus;
        private Path sourceRootPath;

        FileStatusInfo(CopyListingFileStatus fileStatus, Path sourceRootPath) {
            this.fileStatus = fileStatus;
            this.sourceRootPath = sourceRootPath;
        }
    }
}

