/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3ListResult {
    private ListObjectsResponse v1Result;
    private ListObjectsV2Response v2Result;

    protected S3ListResult(ListObjectsResponse v1, ListObjectsV2Response v2) {
        this.v1Result = v1;
        this.v2Result = v2;
    }

    public static S3ListResult v1(ListObjectsResponse result) {
        return new S3ListResult(Objects.requireNonNull(result), null);
    }

    public static S3ListResult v2(ListObjectsV2Response result) {
        return new S3ListResult(null, Objects.requireNonNull(result));
    }

    public boolean isV1() {
        return this.v1Result != null;
    }

    public ListObjectsResponse getV1() {
        return this.v1Result;
    }

    public ListObjectsV2Response getV2() {
        return this.v2Result;
    }

    public List<S3Object> getS3Objects() {
        if (this.isV1()) {
            return this.v1Result.contents();
        }
        return this.v2Result.contents();
    }

    public boolean isTruncated() {
        if (this.isV1()) {
            return this.v1Result.isTruncated();
        }
        return this.v2Result.isTruncated();
    }

    public List<CommonPrefix> getCommonPrefixes() {
        if (this.isV1()) {
            return this.v1Result.commonPrefixes();
        }
        return this.v2Result.commonPrefixes();
    }

    private List<String> objectKeys() {
        return this.getS3Objects().stream().map(S3Object::key).collect(Collectors.toList());
    }

    public boolean hasPrefixesOrObjects() {
        return !this.getCommonPrefixes().isEmpty() || !this.getS3Objects().isEmpty();
    }

    public boolean representsEmptyDirectory(String dirKey) {
        List<String> keys = this.objectKeys();
        return keys.size() == 1 && keys.contains(dirKey) && this.getCommonPrefixes().isEmpty();
    }

    public void logAtDebug(Logger log) {
        List<CommonPrefix> prefixes = this.getCommonPrefixes();
        List<S3Object> s3Objects = this.getS3Objects();
        log.debug("Prefix count = {}; object count={}", (Object)prefixes.size(), (Object)s3Objects.size());
        for (S3Object s3Object : s3Objects) {
            log.debug("Summary: {} {}", (Object)s3Object.key(), (Object)s3Object.size());
        }
        for (CommonPrefix prefix : prefixes) {
            log.debug("Prefix: {}", (Object)prefix.prefix());
        }
    }
}

