/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.ojalgo.access.IndexMapper;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public abstract class TimeIndex<T extends Comparable<? super T>> {
    public static final TimeIndex<Calendar> CALENDAR = new TimeIndex<Calendar>(){

        @Override
        public IndexMapper<Calendar> from(final Calendar reference) {
            return new IndexMapper<Calendar>(){

                @Override
                public long toIndex(Calendar key) {
                    return key.getTimeInMillis() - reference.getTimeInMillis();
                }

                @Override
                public Calendar toKey(long index) {
                    long tmpTimeInMillis = index + reference.getTimeInMillis();
                    GregorianCalendar retVal = new GregorianCalendar();
                    retVal.setTimeInMillis(tmpTimeInMillis);
                    return retVal;
                }
            };
        }

        @Override
        public IndexMapper<Calendar> from(final Calendar reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<Calendar>(){

                @Override
                public long toIndex(Calendar key) {
                    return (key.getTimeInMillis() - reference.getTimeInMillis()) / resolution.toDurationInMillis();
                }

                @Override
                public Calendar toKey(long index) {
                    long tmpTimeInMillis = index * resolution.toDurationInMillis() + reference.getTimeInMillis();
                    GregorianCalendar retVal = new GregorianCalendar();
                    retVal.setTimeInMillis(tmpTimeInMillis);
                    return retVal;
                }
            };
        }

        @Override
        public IndexMapper<Calendar> plain() {
            return new IndexMapper<Calendar>(){

                @Override
                public long toIndex(Calendar key) {
                    return key.getTimeInMillis();
                }

                @Override
                public Calendar toKey(long index) {
                    GregorianCalendar retVal = new GregorianCalendar();
                    retVal.setTimeInMillis(index);
                    return retVal;
                }
            };
        }

        @Override
        public IndexMapper<Calendar> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<Calendar>(){

                @Override
                public long toIndex(Calendar key) {
                    return key.getTimeInMillis() / resolution.toDurationInMillis();
                }

                @Override
                public Calendar toKey(long index) {
                    long tmpTimeInMillis = index * resolution.toDurationInMillis();
                    GregorianCalendar retVal = new GregorianCalendar();
                    retVal.setTimeInMillis(tmpTimeInMillis);
                    return retVal;
                }
            };
        }
    };
    public static final TimeIndex<CalendarDate> CALENDAR_DATE = new TimeIndex<CalendarDate>(){

        @Override
        public IndexMapper<CalendarDate> from(final CalendarDate reference) {
            return new IndexMapper<CalendarDate>(){

                @Override
                public long toIndex(CalendarDate key) {
                    return key.millis - reference.millis;
                }

                @Override
                public CalendarDate toKey(long index) {
                    return new CalendarDate(index + reference.millis);
                }
            };
        }

        @Override
        public IndexMapper<CalendarDate> from(final CalendarDate reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<CalendarDate>(){

                @Override
                public long toIndex(CalendarDate key) {
                    return (key.millis - reference.millis) / resolution.toDurationInMillis();
                }

                @Override
                public CalendarDate toKey(long index) {
                    return new CalendarDate(index * resolution.toDurationInMillis() + reference.millis);
                }
            };
        }

        @Override
        public IndexMapper<CalendarDate> plain() {
            return new IndexMapper<CalendarDate>(){

                @Override
                public long toIndex(CalendarDate key) {
                    return key.millis;
                }

                @Override
                public CalendarDate toKey(long index) {
                    return new CalendarDate(index);
                }
            };
        }

        @Override
        public IndexMapper<CalendarDate> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<CalendarDate>(){

                @Override
                public long toIndex(CalendarDate key) {
                    return key.millis / resolution.toDurationInMillis();
                }

                @Override
                public CalendarDate toKey(long index) {
                    return new CalendarDate(index * resolution.toDurationInMillis());
                }
            };
        }
    };
    public static final TimeIndex<Date> DATE = new TimeIndex<Date>(){

        @Override
        public IndexMapper<Date> from(final Date reference) {
            return new IndexMapper<Date>(){

                @Override
                public long toIndex(Date key) {
                    return key.getTime() - reference.getTime();
                }

                @Override
                public Date toKey(long index) {
                    return new Date(index + reference.getTime());
                }
            };
        }

        @Override
        public IndexMapper<Date> from(final Date reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<Date>(){

                @Override
                public long toIndex(Date key) {
                    return (key.getTime() - reference.getTime()) / resolution.toDurationInMillis();
                }

                @Override
                public Date toKey(long index) {
                    return new Date(index * resolution.toDurationInMillis() + reference.getTime());
                }
            };
        }

        @Override
        public IndexMapper<Date> plain() {
            return new IndexMapper<Date>(){

                @Override
                public long toIndex(Date key) {
                    return key.getTime();
                }

                @Override
                public Date toKey(long index) {
                    return new Date(index);
                }
            };
        }

        @Override
        public IndexMapper<Date> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<Date>(){

                @Override
                public long toIndex(Date key) {
                    return key.getTime() / resolution.toDurationInMillis();
                }

                @Override
                public Date toKey(long index) {
                    return new Date(index * resolution.toDurationInMillis());
                }
            };
        }
    };
    public static final TimeIndex<Instant> INSTANT = new TimeIndex<Instant>(){

        @Override
        public IndexMapper<Instant> from(final Instant reference) {
            return new IndexMapper<Instant>(){

                @Override
                public long toIndex(Instant key) {
                    return reference.until(key, ChronoUnit.NANOS);
                }

                @Override
                public Instant toKey(long index) {
                    return reference.plus(index, ChronoUnit.NANOS);
                }
            };
        }

        @Override
        public IndexMapper<Instant> from(final Instant reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<Instant>(){
                private final long myResolution;
                {
                    this.myResolution = resolution.toDurationInNanos();
                }

                @Override
                public long toIndex(Instant key) {
                    return reference.until(key, ChronoUnit.NANOS) / this.myResolution;
                }

                @Override
                public Instant toKey(long index) {
                    return reference.plus(index * this.myResolution, ChronoUnit.NANOS);
                }
            };
        }

        @Override
        public IndexMapper<Instant> plain() {
            return new IndexMapper<Instant>(){

                @Override
                public long toIndex(Instant key) {
                    return key.toEpochMilli();
                }

                @Override
                public Instant toKey(long index) {
                    return Instant.ofEpochMilli(index);
                }
            };
        }

        @Override
        public IndexMapper<Instant> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<Instant>(){
                private final long myResolution;
                {
                    this.myResolution = resolution.toDurationInMillis();
                }

                @Override
                public long toIndex(Instant key) {
                    return key.toEpochMilli() / this.myResolution;
                }

                @Override
                public Instant toKey(long index) {
                    return Instant.ofEpochMilli(index * this.myResolution);
                }
            };
        }
    };
    public static final TimeIndex<LocalDate> LOCAL_DATE = new TimeIndex<LocalDate>(){

        @Override
        public IndexMapper<LocalDate> from(final LocalDate reference) {
            return new IndexMapper<LocalDate>(){
                private final long myReference;
                {
                    this.myReference = reference.toEpochDay();
                }

                @Override
                public long toIndex(LocalDate key) {
                    return key.toEpochDay() - this.myReference;
                }

                @Override
                public LocalDate toKey(long index) {
                    return LocalDate.ofEpochDay(this.myReference + index);
                }
            };
        }

        @Override
        public IndexMapper<LocalDate> from(final LocalDate reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalDate>(){
                private final long myReference;
                private final long myResolution;
                {
                    this.myReference = reference.toEpochDay() * DAY_SIZE;
                    this.myResolution = resolution.toDurationInMillis();
                }

                @Override
                public long toIndex(LocalDate key) {
                    return (DAY_SIZE * key.toEpochDay() - this.myReference) / this.myResolution;
                }

                @Override
                public LocalDate toKey(long index) {
                    return LocalDate.ofEpochDay((this.myReference + index * this.myResolution) / DAY_SIZE);
                }
            };
        }

        @Override
        public IndexMapper<LocalDate> plain() {
            return new IndexMapper<LocalDate>(){

                @Override
                public long toIndex(LocalDate key) {
                    return key.toEpochDay();
                }

                @Override
                public LocalDate toKey(long index) {
                    return LocalDate.ofEpochDay(index);
                }
            };
        }

        @Override
        public IndexMapper<LocalDate> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalDate>(){
                private final long myResolution;
                {
                    this.myResolution = resolution.toDurationInMillis();
                }

                @Override
                public long toIndex(LocalDate key) {
                    return DAY_SIZE * key.toEpochDay() / this.myResolution;
                }

                @Override
                public LocalDate toKey(long index) {
                    return LocalDate.ofEpochDay(index * this.myResolution / DAY_SIZE);
                }
            };
        }
    };
    public static final TimeIndex<LocalDateTime> LOCAL_DATE_TIME = new TimeIndex<LocalDateTime>(){

        @Override
        public IndexMapper<LocalDateTime> from(final LocalDateTime reference) {
            return new IndexMapper<LocalDateTime>(){
                private final long myReference;
                {
                    this.myReference = reference.toInstant(ZoneOffset.UTC).toEpochMilli();
                }

                @Override
                public long toIndex(LocalDateTime key) {
                    return key.toInstant(ZoneOffset.UTC).toEpochMilli() - this.myReference;
                }

                @Override
                public LocalDateTime toKey(long index) {
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.myReference + index), ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<LocalDateTime> from(final LocalDateTime reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalDateTime>(){
                private final long myReference;
                private final long myResolution;
                {
                    this.myReference = reference.toEpochSecond(ZoneOffset.UTC);
                    this.myResolution = resolution.toDurationInMillis();
                }

                @Override
                public long toIndex(LocalDateTime key) {
                    return (key.toEpochSecond(ZoneOffset.UTC) - this.myReference) / this.myResolution;
                }

                @Override
                public LocalDateTime toKey(long index) {
                    return LocalDateTime.ofEpochSecond(this.myReference + index * this.myResolution, 0, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<LocalDateTime> plain() {
            return new IndexMapper<LocalDateTime>(){

                @Override
                public long toIndex(LocalDateTime key) {
                    return key.toInstant(ZoneOffset.UTC).toEpochMilli();
                }

                @Override
                public LocalDateTime toKey(long index) {
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(index), ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<LocalDateTime> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalDateTime>(){
                private final long myResolution;
                {
                    this.myResolution = resolution.toDurationInMillis();
                }

                @Override
                public long toIndex(LocalDateTime key) {
                    return key.toEpochSecond(ZoneOffset.UTC) / this.myResolution;
                }

                @Override
                public LocalDateTime toKey(long index) {
                    return LocalDateTime.ofEpochSecond(index * this.myResolution, 0, ZoneOffset.UTC);
                }
            };
        }
    };
    public static final TimeIndex<LocalTime> LOCAL_TIME = new TimeIndex<LocalTime>(){

        @Override
        public IndexMapper<LocalTime> from(final LocalTime reference) {
            return new IndexMapper<LocalTime>(){
                final long myReference;
                {
                    this.myReference = reference.toNanoOfDay();
                }

                @Override
                public long toIndex(LocalTime key) {
                    return key.toNanoOfDay() - this.myReference;
                }

                @Override
                public LocalTime toKey(long index) {
                    return LocalTime.ofNanoOfDay(this.myReference + index);
                }
            };
        }

        @Override
        public IndexMapper<LocalTime> from(final LocalTime reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalTime>(){
                final long myReference;
                final long myResolution;
                {
                    this.myReference = reference.toNanoOfDay();
                    this.myResolution = resolution.toDurationInNanos();
                }

                @Override
                public long toIndex(LocalTime key) {
                    return (key.toNanoOfDay() - this.myReference) / this.myResolution;
                }

                @Override
                public LocalTime toKey(long index) {
                    return LocalTime.ofNanoOfDay(this.myReference + index * this.myResolution);
                }
            };
        }

        @Override
        public IndexMapper<LocalTime> plain() {
            return new IndexMapper<LocalTime>(){

                @Override
                public long toIndex(LocalTime key) {
                    return key.toNanoOfDay();
                }

                @Override
                public LocalTime toKey(long index) {
                    return LocalTime.ofNanoOfDay(index);
                }
            };
        }

        @Override
        public IndexMapper<LocalTime> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<LocalTime>(){
                final long myResolution;
                {
                    this.myResolution = resolution.toDurationInNanos();
                }

                @Override
                public long toIndex(LocalTime key) {
                    return key.toNanoOfDay() / this.myResolution;
                }

                @Override
                public LocalTime toKey(long index) {
                    return LocalTime.ofNanoOfDay(index * this.myResolution);
                }
            };
        }
    };
    public static final TimeIndex<OffsetDateTime> OFFSET_DATE_TIME = new TimeIndex<OffsetDateTime>(){

        @Override
        public IndexMapper<OffsetDateTime> from(final OffsetDateTime reference) {
            return new IndexMapper<OffsetDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                private final ZoneOffset myOffset;
                {
                    this.myDelegate = INSTANT.from(reference.toInstant());
                    this.myOffset = reference.getOffset();
                }

                @Override
                public long toIndex(OffsetDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public OffsetDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myOffset != null) {
                        return OffsetDateTime.ofInstant(tmpInstant, this.myOffset);
                    }
                    return OffsetDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<OffsetDateTime> from(final OffsetDateTime reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<OffsetDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                private final ZoneOffset myOffset;
                {
                    this.myDelegate = INSTANT.from(reference.toInstant(), resolution);
                    this.myOffset = reference.getOffset();
                }

                @Override
                public long toIndex(OffsetDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public OffsetDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myOffset != null) {
                        return OffsetDateTime.ofInstant(tmpInstant, this.myOffset);
                    }
                    return OffsetDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<OffsetDateTime> plain() {
            return new IndexMapper<OffsetDateTime>(){
                private final IndexMapper<Instant> myDelegate = INSTANT.plain();
                private transient ZoneOffset myOffset = null;

                @Override
                public long toIndex(OffsetDateTime key) {
                    this.myOffset = key.getOffset();
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public OffsetDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myOffset != null) {
                        return OffsetDateTime.ofInstant(tmpInstant, this.myOffset);
                    }
                    return OffsetDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<OffsetDateTime> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<OffsetDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                {
                    this.myDelegate = INSTANT.plain(resolution);
                }

                @Override
                public long toIndex(OffsetDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public OffsetDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    return OffsetDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }
    };
    public static final TimeIndex<ZonedDateTime> ZONED_DATE_TIME = new TimeIndex<ZonedDateTime>(){

        @Override
        public IndexMapper<ZonedDateTime> from(final ZonedDateTime reference) {
            return new IndexMapper<ZonedDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                private final ZoneId myZone;
                {
                    this.myDelegate = INSTANT.from(reference.toInstant());
                    this.myZone = reference.getZone();
                }

                @Override
                public long toIndex(ZonedDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public ZonedDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myZone != null) {
                        return ZonedDateTime.ofInstant(tmpInstant, this.myZone);
                    }
                    return ZonedDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<ZonedDateTime> from(final ZonedDateTime reference, final CalendarDate.Resolution resolution) {
            return new IndexMapper<ZonedDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                private final ZoneId myZone;
                {
                    this.myDelegate = INSTANT.from(reference.toInstant(), resolution);
                    this.myZone = reference.getZone();
                }

                @Override
                public long toIndex(ZonedDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public ZonedDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myZone != null) {
                        return ZonedDateTime.ofInstant(tmpInstant, this.myZone);
                    }
                    return ZonedDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<ZonedDateTime> plain() {
            return new IndexMapper<ZonedDateTime>(){
                private final IndexMapper<Instant> myDelegate = INSTANT.plain();
                private transient ZoneId myZone = null;

                @Override
                public long toIndex(ZonedDateTime key) {
                    this.myZone = key.getZone();
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public ZonedDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    if (this.myZone != null) {
                        return ZonedDateTime.ofInstant(tmpInstant, this.myZone);
                    }
                    return ZonedDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }

        @Override
        public IndexMapper<ZonedDateTime> plain(final CalendarDate.Resolution resolution) {
            return new IndexMapper<ZonedDateTime>(){
                private final IndexMapper<Instant> myDelegate;
                {
                    this.myDelegate = INSTANT.plain(resolution);
                }

                @Override
                public long toIndex(ZonedDateTime key) {
                    return this.myDelegate.toIndex(key.toInstant());
                }

                @Override
                public ZonedDateTime toKey(long index) {
                    Instant tmpInstant = this.myDelegate.toKey(index);
                    return ZonedDateTime.ofInstant(tmpInstant, ZoneOffset.UTC);
                }
            };
        }
    };
    static final long DAY_SIZE = CalendarDateUnit.DAY.size();

    public abstract IndexMapper<T> from(T var1);

    public abstract IndexMapper<T> from(T var1, CalendarDate.Resolution var2);

    public abstract IndexMapper<T> plain();

    public abstract IndexMapper<T> plain(CalendarDate.Resolution var1);
}

