/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMRMProxyTokenSecretManager
extends SecretManager<AMRMTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMProxyTokenSecretManager.class);
    private int serialNo = new SecureRandom().nextInt();
    private MasterKeyData nextMasterKey;
    private MasterKeyData currentMasterKey;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Timer timer;
    private long rollingInterval;
    private long activationDelay;
    private NMStateStoreService nmStateStore;
    private final Set<ApplicationAttemptId> appAttemptSet = new HashSet<ApplicationAttemptId>();

    public AMRMProxyTokenSecretManager(NMStateStoreService nmStateStoreService) {
        this.timer = new Timer();
        this.nmStateStore = nmStateStoreService;
    }

    public void init(Configuration conf) {
        this.rollingInterval = conf.getLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 86400L) * 1000L;
        String rmAmExpiryIntervalMS = conf.get("yarn.am.liveness-monitor.expiry-interval-ms");
        this.activationDelay = NumberUtils.isDigits((String)rmAmExpiryIntervalMS) ? (long)((double)conf.getLong("yarn.am.liveness-monitor.expiry-interval-ms", YarnConfiguration.DEFAULT_RM_AM_EXPIRY_INTERVAL_MS) * 1.5) : (long)((double)conf.getTimeDuration("yarn.am.liveness-monitor.expiry-interval-ms", YarnConfiguration.DEFAULT_RM_AM_EXPIRY_INTERVAL_MS, TimeUnit.MILLISECONDS) * 1.5);
        LOG.info("AMRMTokenKeyRollingInterval: {} ms and AMRMTokenKeyActivationDelay: {} ms.", (Object)this.rollingInterval, (Object)this.activationDelay);
        if (this.rollingInterval <= this.activationDelay * 2L) {
            throw new IllegalArgumentException("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs should be more than 3 X yarn.am.liveness-monitor.expiry-interval-ms");
        }
    }

    public void start() {
        if (this.currentMasterKey == null) {
            this.currentMasterKey = this.createNewMasterKey();
            if (this.nmStateStore != null) {
                try {
                    this.nmStateStore.storeAMRMProxyCurrentMasterKey(this.currentMasterKey.getMasterKey());
                }
                catch (IOException e) {
                    LOG.error("Unable to update current master key in state store", (Throwable)e);
                }
            }
        }
        this.timer.scheduleAtFixedRate((TimerTask)new MasterKeyRoller(), this.rollingInterval, this.rollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    @VisibleForTesting
    public void setNMStateStoreService(NMStateStoreService nmStateStoreService) {
        this.nmStateStore = nmStateStoreService;
    }

    public void applicationMasterFinished(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            LOG.info("Application finished, removing password for " + appAttemptId);
            this.appAttemptSet.remove(appAttemptId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void rollMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Rolling master-key for amrm-tokens");
            this.nextMasterKey = this.createNewMasterKey();
            if (this.nmStateStore != null) {
                try {
                    this.nmStateStore.storeAMRMProxyNextMasterKey(this.nextMasterKey.getMasterKey());
                }
                catch (IOException e) {
                    LOG.error("Unable to update next master key in state store", (Throwable)e);
                }
            }
            this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void activateNextMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Activating next master key with id: " + this.nextMasterKey.getMasterKey().getKeyId());
            this.currentMasterKey = this.nextMasterKey;
            this.nextMasterKey = null;
            if (this.nmStateStore != null) {
                try {
                    this.nmStateStore.storeAMRMProxyCurrentMasterKey(this.currentMasterKey.getMasterKey());
                    this.nmStateStore.storeAMRMProxyNextMasterKey(null);
                }
                catch (IOException e) {
                    LOG.error("Unable to update current master key in state store", (Throwable)e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData createNewMasterKey() {
        this.writeLock.lock();
        try {
            MasterKeyData masterKeyData = new MasterKeyData(this.serialNo++, this.generateSecret());
            return masterKeyData;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<AMRMTokenIdentifier> createAndGetAMRMToken(ApplicationAttemptId appAttemptId) {
        this.writeLock.lock();
        try {
            LOG.info("Create AMRMToken for ApplicationAttempt: " + appAttemptId);
            AMRMTokenIdentifier identifier = new AMRMTokenIdentifier(appAttemptId, this.getMasterKey().getMasterKey().getKeyId());
            byte[] password = this.createPassword(identifier);
            this.appAttemptSet.add(appAttemptId);
            Token token = new Token(identifier.getBytes(), password, identifier.getKind(), new Text());
            return token;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public MasterKeyData getMasterKey() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.nextMasterKey == null ? this.currentMasterKey : this.nextMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public byte[] retrievePassword(AMRMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        this.readLock.lock();
        try {
            ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
            LOG.debug("Trying to retrieve password for {}", (Object)applicationAttemptId);
            if (!this.appAttemptSet.contains(applicationAttemptId)) {
                throw new SecretManager.InvalidToken(applicationAttemptId + " not found in AMRMProxyTokenSecretManager.");
            }
            if (identifier.getKeyId() == this.currentMasterKey.getMasterKey().getKeyId()) {
                byte[] byArray = AMRMProxyTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.currentMasterKey.getSecretKey());
                return byArray;
            }
            if (this.nextMasterKey != null && identifier.getKeyId() == this.nextMasterKey.getMasterKey().getKeyId()) {
                byte[] byArray = AMRMProxyTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.nextMasterKey.getSecretKey());
                return byArray;
            }
            throw new SecretManager.InvalidToken("Invalid AMRMToken from " + applicationAttemptId);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AMRMTokenIdentifier createIdentifier() {
        return new AMRMTokenIdentifier();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData getCurrentMasterKeyData() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.currentMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public MasterKeyData getNextMasterKeyData() {
        this.readLock.lock();
        try {
            MasterKeyData masterKeyData = this.nextMasterKey;
            return masterKeyData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected byte[] createPassword(AMRMTokenIdentifier identifier) {
        this.readLock.lock();
        try {
            ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
            LOG.info("Creating password for " + applicationAttemptId);
            byte[] byArray = AMRMProxyTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.getMasterKey().getSecretKey());
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void recover(NMStateStoreService.RecoveredAMRMProxyState state) {
        if (state != null) {
            MasterKey currentKey = state.getCurrentMasterKey();
            if (currentKey != null) {
                this.currentMasterKey = new MasterKeyData(currentKey, AMRMProxyTokenSecretManager.createSecretKey((byte[])currentKey.getBytes().array()));
            } else {
                LOG.warn("No current master key recovered from NM StateStore for AMRMProxyTokenSecretManager");
            }
            MasterKey nextKey = state.getNextMasterKey();
            if (nextKey != null) {
                this.nextMasterKey = new MasterKeyData(nextKey, AMRMProxyTokenSecretManager.createSecretKey((byte[])nextKey.getBytes().array()));
                this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
            }
        }
    }

    private class NextKeyActivator
    extends TimerTask {
        private NextKeyActivator() {
        }

        @Override
        public void run() {
            AMRMProxyTokenSecretManager.this.activateNextMasterKey();
        }
    }

    private class MasterKeyRoller
    extends TimerTask {
        private MasterKeyRoller() {
        }

        @Override
        public void run() {
            AMRMProxyTokenSecretManager.this.rollMasterKey();
        }
    }
}

