/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.nodelocal.LogAggregationNodeLocalTFileController;

public class LogCLIHelpers
implements Configurable {
    public static final String PER_LOG_FILE_INFO_PATTERN = "%30s\t%30s\t%30s\t%30s" + System.getProperty("line.separator");
    public static final String CONTAINER_ON_NODE_PATTERN = "Container: %s on %s";
    private Configuration conf;
    private LogAggregationFileControllerFactory factory;

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainersLogs(String appId, String containerId, String nodeId, String jobOwner) throws IOException {
        ContainerLogsRequest options = new ContainerLogsRequest();
        options.setAppId(ApplicationId.fromString(appId));
        options.setContainerId(containerId);
        options.setNodeId(nodeId);
        options.setAppOwner(jobOwner);
        HashSet<String> logs = new HashSet<String>();
        options.setLogTypes(logs);
        options.setBytes(Long.MAX_VALUE);
        return this.dumpAContainerLogsForLogType(options, false);
    }

    public static String guessOwnerWithFileFormat(LogAggregationFileController fileFormat, ApplicationId appId, String bestGuess, Configuration conf) throws IOException {
        FileStatus[] matching;
        Path toMatch2;
        boolean scanOldPath = LogAggregationUtils.isOlderPathEnabled(conf);
        Path remoteRootLogDir = fileFormat.getRemoteRootLogDir();
        String suffix = fileFormat.getRemoteRootLogDirSuffix();
        Path fullPath = fileFormat.getRemoteAppLogDir(appId, bestGuess);
        FileContext fc = FileContext.getFileContext(remoteRootLogDir.toUri(), conf);
        String pathAccess = fullPath.toString();
        try {
            if (fc.util().exists(fullPath)) {
                return bestGuess;
            }
            if (scanOldPath) {
                Path olderAppPath = fileFormat.getOlderRemoteAppLogDir(appId, bestGuess);
                pathAccess = olderAppPath.toString();
                if (fc.util().exists(olderAppPath)) {
                    return bestGuess;
                }
            }
        }
        catch (AccessDeniedException | AccessControlException ex) {
            LogCLIHelpers.logDirNoAccessPermission(pathAccess, bestGuess, ex.getMessage());
            throw ex;
        }
        try {
            toMatch2 = fileFormat.getRemoteAppLogDir(appId, null);
            matching = fc.util().globStatus(toMatch2);
            if (matching != null && matching.length == 1) {
                Path parent = matching[0].getPath().getParent();
                if (suffix != null && !StringUtils.isEmpty((CharSequence)suffix)) {
                    parent = parent.getParent();
                }
                parent = parent.getParent();
                return parent.getName();
            }
        }
        catch (IOException toMatch2) {
            // empty catch block
        }
        if (scanOldPath) {
            try {
                toMatch2 = fileFormat.getOlderRemoteAppLogDir(appId, null);
                matching = fc.util().globStatus(toMatch2);
                if (matching != null && matching.length == 1) {
                    Path parent = matching[0].getPath().getParent();
                    if (suffix != null && !StringUtils.isEmpty((CharSequence)suffix)) {
                        parent = parent.getParent();
                    }
                    return parent.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static String getOwnerForAppIdOrNull(ApplicationId appId, String bestGuess, Configuration conf) {
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(conf);
        LinkedList<LogAggregationFileController> fileControllers = factory.getConfiguredLogAggregationFileControllerList();
        if (fileControllers != null && !fileControllers.isEmpty()) {
            String owner = null;
            for (LogAggregationFileController fileFormat : fileControllers) {
                try {
                    owner = LogCLIHelpers.guessOwnerWithFileFormat(fileFormat, appId, bestGuess, conf);
                    if (owner == null) continue;
                    return owner;
                }
                catch (IOException e) {
                    return null;
                }
            }
        } else {
            System.err.println("Can not find any valid fileControllers.  The configurated fileControllers: yarn.log-aggregation.file-formats");
        }
        return null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainerLogsForLogType(ContainerLogsRequest options) throws IOException {
        return this.dumpAContainerLogsForLogType(options, true);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainerLogsForLogType(ContainerLogsRequest options, boolean outputFailure) throws IOException {
        LogAggregationFileController fc = null;
        try {
            fc = this.getFileController(options.getAppId(), options.getAppOwner());
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        boolean foundAnyLogs = false;
        if (fc != null) {
            foundAnyLogs = fc.readAggregatedLogs(options, null);
        }
        if (!foundAnyLogs) {
            if (outputFailure) {
                LogCLIHelpers.containerLogNotFound(options.getContainerId());
            }
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogsForLogTypeWithoutNodeId(ContainerLogsRequest options) throws IOException {
        LogAggregationFileController fc = null;
        try {
            fc = this.getFileController(options.getAppId(), options.getAppOwner());
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        boolean foundAnyLogs = false;
        if (fc != null) {
            foundAnyLogs = fc.readAggregatedLogs(options, null);
        }
        if (!foundAnyLogs) {
            LogCLIHelpers.containerLogNotFound(options.getContainerId());
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int dumpAllContainersLogs(ContainerLogsRequest options) throws IOException {
        LogAggregationFileController fc = null;
        try {
            fc = this.getFileController(options.getAppId(), options.getAppOwner());
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        boolean foundAnyLogs = false;
        if (fc != null) {
            foundAnyLogs = fc.readAggregatedLogs(options, null);
        }
        if (!foundAnyLogs) {
            if (YarnConfiguration.isNodeLocalAggregationEnabled(this.conf)) {
                LogCLIHelpers.emptyLogDir(((LogAggregationNodeLocalTFileController)fc).getNodeLocalMetadataReader().getPathForApp(options.getAppId().toString(), options.getAppOwner()).toString());
            } else {
                LogCLIHelpers.emptyLogDir(LogAggregationUtils.getRemoteAppLogDir(this.conf, options.getAppId(), options.getAppOwner(), fc.getRemoteRootLogDir(), fc.getRemoteRootLogDirSuffix()).toString());
            }
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int printAContainerLogMetadata(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        List<ContainerLogMeta> containersLogMeta;
        String nodeId = options.getNodeId();
        String containerIdStr = options.getContainerId();
        try {
            containersLogMeta = this.getFileController(options.getAppId(), options.getAppOwner()).readAggregatedLogsMeta(options);
        }
        catch (Exception ex) {
            err.println(ex.getMessage());
            return -1;
        }
        if (containersLogMeta.isEmpty()) {
            if (containerIdStr != null && nodeId != null) {
                err.println("The container " + containerIdStr + " couldn't be found on the node specified: " + nodeId);
            } else if (nodeId != null) {
                err.println("Can not find log metadata for any containers on " + nodeId);
            } else if (containerIdStr != null) {
                err.println("Can not find log metadata for container: " + containerIdStr);
            }
            return -1;
        }
        for (ContainerLogMeta containerLogMeta : containersLogMeta) {
            String containerString = String.format(CONTAINER_ON_NODE_PATTERN, containerLogMeta.getContainerId(), containerLogMeta.getNodeId());
            out.println(containerString);
            out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
            out.printf(PER_LOG_FILE_INFO_PATTERN, "LogFile", "LogLength", "LastModificationTime", "LogAggregationType");
            out.println(StringUtils.repeat((String)"=", (int)(containerString.length() * 2)));
            for (ContainerLogFileInfo logMeta : containerLogMeta.getContainerLogMeta()) {
                out.printf(PER_LOG_FILE_INFO_PATTERN, logMeta.getFileName(), logMeta.getFileSize(), logMeta.getLastModifiedTime(), "AGGREGATED");
            }
        }
        return 0;
    }

    @InterfaceAudience.Private
    public void printNodesList(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        ApplicationId appId = options.getAppId();
        String appOwner = options.getAppOwner();
        LogAggregationFileController fileFormat = null;
        try {
            fileFormat = this.getFileController(appId, appOwner);
        }
        catch (Exception ex) {
            err.println(ex.getMessage());
            return;
        }
        boolean foundNode = false;
        StringBuilder sb = new StringBuilder();
        if (YarnConfiguration.isNodeLocalAggregationEnabled(this.conf)) {
            Map<String, List<String>> nodeToContainersMap = ((LogAggregationNodeLocalTFileController)fileFormat).getNodeLocalMetadataReader().getLogMetadataForApplication(appId.toString(), appOwner);
            if (!nodeToContainersMap.isEmpty()) {
                Set<String> nodes = nodeToContainersMap.keySet();
                for (String node : nodes) {
                    sb.append(node + "\n");
                    foundNode = true;
                }
            }
        } else {
            RemoteIterator<FileStatus> nodeFiles = null;
            try {
                nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, appOwner, fileFormat.getRemoteRootLogDir(), fileFormat.getRemoteRootLogDirSuffix(), fileFormat.getRemoteOlderRootLogDirSuffix());
            }
            catch (FileNotFoundException fnf) {
                LogCLIHelpers.logDirNotExist(fileFormat.getRemoteAppLogDir(appId, appOwner).toString());
            }
            catch (AccessDeniedException | AccessControlException ace) {
                LogCLIHelpers.logDirNoAccessPermission(fileFormat.getRemoteAppLogDir(appId, appOwner).toString(), appOwner, ace.getMessage());
            }
            if (nodeFiles == null) {
                return;
            }
            while (nodeFiles.hasNext()) {
                FileStatus thisNodeFile = nodeFiles.next();
                sb.append(thisNodeFile.getPath().getName() + "\n");
                foundNode = true;
            }
        }
        if (!foundNode) {
            err.println("No nodes found that aggregated logs for the application: " + appId);
        } else {
            out.println(sb.toString());
        }
    }

    @InterfaceAudience.Private
    public void printContainersList(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        ApplicationId appId = options.getAppId();
        String nodeId = options.getNodeId();
        boolean foundAnyLogs = false;
        List<Object> containersLogMeta = new ArrayList();
        try {
            containersLogMeta = this.getFileController(options.getAppId(), options.getAppOwner()).readAggregatedLogsMeta(options);
        }
        catch (Exception ex) {
            err.println(ex.getMessage());
        }
        for (ContainerLogMeta logMeta : containersLogMeta) {
            out.println(String.format(CONTAINER_ON_NODE_PATTERN, logMeta.getContainerId(), logMeta.getNodeId()));
            foundAnyLogs = true;
        }
        if (!foundAnyLogs) {
            if (nodeId != null) {
                err.println("Can not find information for any containers on " + nodeId);
            } else {
                err.println("Can not find any container information for the application: " + appId);
            }
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    private static void containerLogNotFound(String containerId) {
        System.err.println("Logs for container " + containerId + " are not present in this log-file.");
    }

    private static void logDirNotExist(String remoteAppLogDir) {
        System.err.println(remoteAppLogDir + " does not exist.");
        System.err.println("Log aggregation has not completed or is not enabled.");
    }

    private static void emptyLogDir(String remoteAppLogDir) {
        System.err.println(remoteAppLogDir + " does not have any log files.");
    }

    private static void logDirNoAccessPermission(String remoteAppLogDir, String appOwner, String errorMessage) throws IOException {
        System.err.println("Guessed logs' owner is " + appOwner + " and current user " + UserGroupInformation.getCurrentUser().getUserName() + " does not have permission to access " + remoteAppLogDir + ". Error message found: " + errorMessage);
    }

    public void closePrintStream(PrintStream out) {
        if (out != System.out) {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @InterfaceAudience.Private
    public Set<ContainerLogFileInfo> listContainerLogs(ContainerLogsRequest options) throws IOException {
        List<ContainerLogMeta> containersLogMeta;
        HashSet<ContainerLogFileInfo> logTypes = new HashSet<ContainerLogFileInfo>();
        try {
            containersLogMeta = this.getFileController(options.getAppId(), options.getAppOwner()).readAggregatedLogsMeta(options);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return logTypes;
        }
        for (ContainerLogMeta logMeta : containersLogMeta) {
            for (ContainerLogFileInfo fileInfo : logMeta.getContainerLogMeta()) {
                logTypes.add(fileInfo);
            }
        }
        return logTypes;
    }

    private LogAggregationFileController getFileController(ApplicationId appId, String appOwner) throws IOException {
        if (this.factory == null) {
            this.factory = new LogAggregationFileControllerFactory(this.conf);
        }
        return this.factory.getFileControllerForRead(appId, appOwner);
    }
}

