/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.stream.ChunkedFile;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FadvisedChunkedFile
extends ChunkedFile {
    private static final Logger LOG = LoggerFactory.getLogger(FadvisedChunkedFile.class);
    private final Object closeLock = new Object();
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private volatile ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedChunkedFile(RandomAccessFile file, long position, long count, int chunkSize, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier) throws IOException {
        super(file, position, count, chunkSize);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
    }

    @VisibleForTesting
    FileDescriptor getFd() {
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.fd.valid()) {
                if (this.manageOsCache && this.readaheadPool != null) {
                    this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.currentOffset(), (long)this.readaheadLength, this.endOffset(), this.readaheadRequest);
                }
                return super.readChunk(allocator);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.readaheadRequest != null) {
                this.readaheadRequest.cancel();
                this.readaheadRequest = null;
            }
            if (this.fd.valid() && this.manageOsCache && this.endOffset() - this.startOffset() > 0L) {
                try {
                    NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.startOffset(), this.endOffset() - this.startOffset(), NativeIO.POSIX.POSIX_FADV_DONTNEED);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to manage OS cache for " + this.identifier + " fd " + this.fd.toString(), t);
                }
            }
            super.close();
        }
    }
}

