/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterRefreshSuperUserGroupsConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterRefreshSuperUserGroupsConfiguration.class);
    private MiniRouterDFSCluster cluster;
    private static final String ROUTER_NS = "rbfns";
    private static final String HDFS_SCHEMA = "hdfs://";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private String tempResource = null;

    @Before
    public void setUpCluster() throws Exception {
        Configuration conf = new RouterConfigBuilder().rpc().admin().build();
        this.cluster = new MiniRouterDFSCluster(false, 1);
        this.cluster.addRouterOverrides(conf);
        this.cluster.startRouters();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.tempResource != null) {
            File f = new File(this.tempResource);
            f.delete();
            this.tempResource = null;
        }
    }

    private Configuration initializeClientConfig() throws Exception {
        Configuration conf = new Configuration(false);
        Router router = this.cluster.getRouters().get(0).getRouter();
        conf.set("dfs.nameservices", "ns0,ns1,rbfns");
        conf.set("dfs.ha.namenodes.rbfns", "r1");
        conf.set("dfs.federation.router.admin-address", "127.0.0.1:" + router.getAdminServerAddress().getPort());
        conf.set("dfs.namenode.rpc-address.rbfns.r1", "127.0.0.1:" + router.getRpcServerAddress().getPort());
        conf.set("dfs.client.failover.proxy.provider.rbfns", ConfiguredFailoverProxyProvider.class.getCanonicalName());
        conf.set("fs.defaultFS", "hdfs://rbfns");
        conf.setBoolean("dfs.client.failover.random.order", false);
        conf.set("fs.defaultFS", "hdfs://rbfns");
        return conf;
    }

    @Test
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        Configuration conf = this.initializeClientConfig();
        this.testRefreshSuperUserGroupsConfigurationInternal(conf);
    }

    private void testRefreshSuperUserGroupsConfigurationInternal(Configuration conf) throws Exception {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation impersonator = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)impersonator.getShortUserName()).thenReturn((Object)"impersonator");
        Mockito.when((Object)impersonator.getUserName()).thenReturn((Object)"impersonator");
        Mockito.when((Object)ugi.getRealUser()).thenReturn((Object)impersonator);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)"victim");
        Mockito.when((Object)ugi.getGroups()).thenReturn(Arrays.asList("groupVictim"));
        LambdaTestUtils.intercept(AuthorizationException.class, (String)"User: impersonator is not allowed to impersonate victim", () -> ProxyUsers.authorize((UserGroupInformation)ugi, (String)LOOPBACK_ADDRESS));
        String tfile = "testRouterRefreshSuperUserGroupsConfiguration_rsrc.xml";
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList("hadoop.proxyuser.impersonator.groups", "hadoop.proxyuser.impersonator.hosts"));
        ArrayList<String> values = new ArrayList<String>(Arrays.asList("groupVictim", LOOPBACK_ADDRESS));
        this.tempResource = TestRouterRefreshSuperUserGroupsConfiguration.addFileBasedConfigResource(tfile, keys, values);
        Configuration.addDefaultResource((String)tfile);
        RouterAdmin routerAdmin = new RouterAdmin(conf);
        int clientRes = routerAdmin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertEquals((String)"CLI command was not successful", (long)0L, (long)clientRes);
        ProxyUsers.authorize((UserGroupInformation)ugi, (String)LOOPBACK_ADDRESS);
    }

    private static String addFileBasedConfigResource(String configFileName, ArrayList<String> keyArray, ArrayList<String> valueArray) throws IOException {
        if (keyArray.size() != valueArray.size()) {
            throw new IOException("keyArray and valueArray should be equal in size");
        }
        URL url = new Configuration().getResource("hdfs-site.xml");
        Path dir = new Path(URLDecoder.decode(url.getPath(), "UTF-8")).getParent();
        String tmp = dir.toString() + "/" + configFileName;
        StringBuilder configItems = new StringBuilder();
        configItems.append("<configuration>");
        for (int i = 0; i < keyArray.size(); ++i) {
            configItems.append("<property>").append("<name>").append(keyArray.get(i)).append("</name>").append("<value>").append(valueArray.get(i)).append("</value>").append("</property>");
        }
        configItems.append("</configuration>");
        PrintWriter writer = new PrintWriter(new FileOutputStream(tmp));
        writer.println(configItems.toString());
        writer.close();
        return tmp;
    }
}

