/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getApplicationProtocols;
    private static final Method setApplicationProtocols;
    private static final Method getEnableRetransmissions;
    private static final Method setEnableRetransmissions;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getMaximumPacketSize;
    private static final Method setMaximumPacketSize;
    private static final Method getNamedGroups;
    private static final Method setNamedGroups;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSignatureSchemes;
    private static final Method setSignatureSchemes;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters prov) {
        BCSSLParameters ssl = new BCSSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        ssl.setEndpointIdentificationAlgorithm(prov.getEndpointIdentificationAlgorithm());
        ssl.setAlgorithmConstraints(prov.getAlgorithmConstraints());
        ssl.setServerNames(prov.getServerNames());
        ssl.setSNIMatchers(prov.getSNIMatchers());
        ssl.setUseCipherSuitesOrder(prov.getUseCipherSuitesOrder());
        ssl.setApplicationProtocols(prov.getApplicationProtocols());
        ssl.setEnableRetransmissions(prov.getEnableRetransmissions());
        ssl.setMaximumPacketSize(prov.getMaximumPacketSize());
        ssl.setSignatureSchemes(prov.getSignatureSchemes());
        ssl.setNamedGroups(prov.getNamedGroups());
        return ssl;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters prov) {
        String[] applicationProtocols;
        Collection<BCSNIMatcher> matchers;
        List<BCSNIServerName> serverNames;
        SSLParameters ssl = new SSLParameters(prov.getCipherSuites(), prov.getProtocols());
        if (prov.getNeedClientAuth()) {
            ssl.setNeedClientAuth(true);
        } else {
            ssl.setWantClientAuth(prov.getWantClientAuth());
        }
        if (null != setAlgorithmConstraints) {
            SSLParametersUtil.set(ssl, setAlgorithmConstraints, JsseUtils_7.exportAlgorithmConstraintsDynamic(prov.getAlgorithmConstraints()));
        }
        if (null != setEndpointIdentificationAlgorithm) {
            SSLParametersUtil.set(ssl, setEndpointIdentificationAlgorithm, prov.getEndpointIdentificationAlgorithm());
        }
        if (null != setServerNames && null != (serverNames = prov.getServerNames())) {
            SSLParametersUtil.set(ssl, setServerNames, JsseUtils_8.exportSNIServerNamesDynamic(serverNames));
        }
        if (null != setSNIMatchers && null != (matchers = prov.getSNIMatchers())) {
            SSLParametersUtil.set(ssl, setSNIMatchers, JsseUtils_8.exportSNIMatchersDynamic(matchers));
        }
        if (null != setUseCipherSuitesOrder) {
            SSLParametersUtil.set(ssl, setUseCipherSuitesOrder, prov.getUseCipherSuitesOrder());
        }
        if (null != setApplicationProtocols && null != (applicationProtocols = prov.getApplicationProtocols())) {
            SSLParametersUtil.set(ssl, setApplicationProtocols, applicationProtocols);
        }
        if (null != setEnableRetransmissions) {
            SSLParametersUtil.set(ssl, setEnableRetransmissions, prov.getEnableRetransmissions());
        }
        if (null != setMaximumPacketSize) {
            SSLParametersUtil.set(ssl, setMaximumPacketSize, prov.getMaximumPacketSize());
        }
        if (null != setSignatureSchemes) {
            SSLParametersUtil.set(ssl, setSignatureSchemes, prov.getSignatureSchemes());
        }
        if (null != setNamedGroups) {
            SSLParametersUtil.set(ssl, setNamedGroups, prov.getNamedGroups());
        }
        return ssl;
    }

    static BCSSLParameters importSSLParameters(SSLParameters ssl) {
        String[] applicationProtocols;
        Object matchers;
        Object serverNames;
        Object constraints;
        String endpointIdentificationAlgorithm;
        BCSSLParameters bc = new BCSSLParameters(ssl.getCipherSuites(), ssl.getProtocols());
        if (ssl.getNeedClientAuth()) {
            bc.setNeedClientAuth(true);
        } else {
            bc.setWantClientAuth(ssl.getWantClientAuth());
        }
        if (null != getEndpointIdentificationAlgorithm && null != (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm))) {
            bc.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != getAlgorithmConstraints && null != (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints))) {
            bc.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (null != getServerNames && null != (serverNames = SSLParametersUtil.get(ssl, getServerNames))) {
            bc.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(serverNames));
        }
        if (null != getSNIMatchers && null != (matchers = SSLParametersUtil.get(ssl, getSNIMatchers))) {
            bc.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(matchers));
        }
        if (null != getUseCipherSuitesOrder) {
            bc.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (null != getApplicationProtocols && null != (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols))) {
            bc.setApplicationProtocols(applicationProtocols);
        }
        if (null != getEnableRetransmissions) {
            bc.setEnableRetransmissions((Boolean)SSLParametersUtil.get(ssl, getEnableRetransmissions));
        }
        if (null != getMaximumPacketSize) {
            bc.setMaximumPacketSize((Integer)SSLParametersUtil.get(ssl, getMaximumPacketSize));
        }
        if (null != getSignatureSchemes) {
            bc.setSignatureSchemes((String[])SSLParametersUtil.get(ssl, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            bc.setNamedGroups((String[])SSLParametersUtil.get(ssl, getNamedGroups));
        }
        return bc;
    }

    static void setParameters(ProvSSLParameters prov, BCSSLParameters ssl) {
        Collection<BCSNIMatcher> sniMatchers;
        List<BCSNIServerName> serverNames;
        BCAlgorithmConstraints algorithmConstraints;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        String endpointIdentificationAlgorithm = ssl.getEndpointIdentificationAlgorithm();
        if (null != endpointIdentificationAlgorithm) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != (algorithmConstraints = ssl.getAlgorithmConstraints())) {
            prov.setAlgorithmConstraints(algorithmConstraints);
        }
        if (null != (serverNames = ssl.getServerNames())) {
            prov.setServerNames(serverNames);
        }
        if (null != (sniMatchers = ssl.getSNIMatchers())) {
            prov.setSNIMatchers(sniMatchers);
        }
        prov.setUseCipherSuitesOrder(ssl.getUseCipherSuitesOrder());
        String[] applicationProtocols = ssl.getApplicationProtocols();
        if (null != applicationProtocols) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        prov.setEnableRetransmissions(ssl.getEnableRetransmissions());
        prov.setMaximumPacketSize(ssl.getMaximumPacketSize());
        prov.setSignatureSchemes(ssl.getSignatureSchemes());
        prov.setNamedGroups(ssl.getNamedGroups());
    }

    static void setSSLParameters(ProvSSLParameters prov, SSLParameters ssl) {
        String[] applicationProtocols;
        Object matchers;
        Object serverNames;
        Object constraints;
        String endpointIdentificationAlgorithm;
        String[] protocols;
        String[] cipherSuites = ssl.getCipherSuites();
        if (null != cipherSuites) {
            prov.setCipherSuites(cipherSuites);
        }
        if (null != (protocols = ssl.getProtocols())) {
            prov.setProtocols(protocols);
        }
        if (ssl.getNeedClientAuth()) {
            prov.setNeedClientAuth(true);
        } else {
            prov.setWantClientAuth(ssl.getWantClientAuth());
        }
        if (null != getEndpointIdentificationAlgorithm && null != (endpointIdentificationAlgorithm = (String)SSLParametersUtil.get(ssl, getEndpointIdentificationAlgorithm))) {
            prov.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
        }
        if (null != getAlgorithmConstraints && null != (constraints = SSLParametersUtil.get(ssl, getAlgorithmConstraints))) {
            prov.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(constraints));
        }
        if (null != getServerNames && null != (serverNames = SSLParametersUtil.get(ssl, getServerNames))) {
            prov.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(serverNames));
        }
        if (null != getSNIMatchers && null != (matchers = SSLParametersUtil.get(ssl, getSNIMatchers))) {
            prov.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(matchers));
        }
        if (null != getUseCipherSuitesOrder) {
            prov.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(ssl, getUseCipherSuitesOrder));
        }
        if (null != getApplicationProtocols && null != (applicationProtocols = (String[])SSLParametersUtil.get(ssl, getApplicationProtocols))) {
            prov.setApplicationProtocols(applicationProtocols);
        }
        if (null != getEnableRetransmissions) {
            prov.setEnableRetransmissions((Boolean)SSLParametersUtil.get(ssl, getEnableRetransmissions));
        }
        if (null != getMaximumPacketSize) {
            prov.setMaximumPacketSize((Integer)SSLParametersUtil.get(ssl, getMaximumPacketSize));
        }
        if (null != getSignatureSchemes) {
            prov.setSignatureSchemes((String[])SSLParametersUtil.get(ssl, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            prov.setNamedGroups((String[])SSLParametersUtil.get(ssl, getNamedGroups));
        }
    }

    private static Object get(Object obj, Method method) {
        return ReflectionUtil.invokeGetter(obj, method);
    }

    private static void set(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeSetter(obj, method, arg);
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getAlgorithmConstraints = ReflectionUtil.findMethod(methods, "getAlgorithmConstraints");
        setAlgorithmConstraints = ReflectionUtil.findMethod(methods, "setAlgorithmConstraints");
        getApplicationProtocols = ReflectionUtil.findMethod(methods, "getApplicationProtocols");
        setApplicationProtocols = ReflectionUtil.findMethod(methods, "setApplicationProtocols");
        getEnableRetransmissions = ReflectionUtil.findMethod(methods, "getEnableRetransmissions");
        setEnableRetransmissions = ReflectionUtil.findMethod(methods, "setEnableRetransmissions");
        getEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methods, "setEndpointIdentificationAlgorithm");
        getMaximumPacketSize = ReflectionUtil.findMethod(methods, "getMaximumPacketSize");
        setMaximumPacketSize = ReflectionUtil.findMethod(methods, "setMaximumPacketSize");
        getNamedGroups = ReflectionUtil.findMethod(methods, "getNamedGroups");
        setNamedGroups = ReflectionUtil.findMethod(methods, "setNamedGroups");
        getServerNames = ReflectionUtil.findMethod(methods, "getServerNames");
        setServerNames = ReflectionUtil.findMethod(methods, "setServerNames");
        getSignatureSchemes = ReflectionUtil.findMethod(methods, "getSignatureSchemes");
        setSignatureSchemes = ReflectionUtil.findMethod(methods, "setSignatureSchemes");
        getSNIMatchers = ReflectionUtil.findMethod(methods, "getSNIMatchers");
        setSNIMatchers = ReflectionUtil.findMethod(methods, "setSNIMatchers");
        getUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = ReflectionUtil.findMethod(methods, "setUseCipherSuitesOrder");
    }
}

