/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvX509KeyManagerSimple
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManagerSimple.class.getName());
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final Map<String, Credential> credentials;

    private static Map<String, Credential> loadCredentials(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, Credential> credentials = new HashMap<String, Credential>(4);
        if (null != ks) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Object[] certificateChain;
                PrivateKey privateKey;
                String alias = aliases.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || null == (privateKey = (PrivateKey)ks.getKey(alias, password)) || TlsUtils.isNullOrEmpty(certificateChain = JsseUtils.getX509CertificateChain(ks.getCertificateChain(alias)))) continue;
                credentials.put(alias, new Credential(alias, privateKey, (X509Certificate[])certificateChain));
            }
        }
        return Collections.unmodifiableMap(credentials);
    }

    ProvX509KeyManagerSimple(boolean isInFipsMode, JcaJceHelper helper, KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.credentials = ProvX509KeyManagerSimple.loadCredentials(ks, password);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(engine), true);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManager.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManager.getKeyTypes(keyTypes), issuers, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Credential credential = this.getCredential(alias);
        return null == credential ? null : (X509Certificate[])credential.certificateChain.clone();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, false);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Credential credential = this.getCredential(alias);
        return null == credential ? null : credential.privateKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManager.getKeyTypes(keyType), issuers, null, true);
    }

    @Override
    protected BCX509Key getKeyBC(String keyType, String alias) {
        Credential credential = this.getCredential(alias);
        return this.createKeyBC(keyType, credential);
    }

    private String chooseAlias(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0) {
            String keyType = keyTypes.get(bestMatch.keyTypeIndex);
            String alias = ProvX509KeyManagerSimple.getAlias(bestMatch);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + keyType + ", returning alias: " + alias);
            }
            return alias;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        String keyType;
        BCX509Key keyBC;
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (bestMatch.compareTo(Match.NOTHING) < 0 && null != (keyBC = this.createKeyBC(keyType = keyTypes.get(bestMatch.keyTypeIndex), bestMatch.credential))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found matching key of type: " + keyType + ", from alias: " + ProvX509KeyManagerSimple.getAlias(bestMatch));
            }
            return keyBC;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(String keyType, Credential credential) {
        return null == credential ? null : new ProvX509Key(keyType, credential.privateKey, credential.certificateChain);
    }

    private String[] getAliases(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            List<Match> matches = null;
            for (Credential credential : this.credentials.values()) {
                Match match = this.getPotentialMatch(credential, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                if (match.compareTo(Match.NOTHING) >= 0) continue;
                matches = ProvX509KeyManagerSimple.addToMatches(matches, match);
            }
            if (null != matches && !matches.isEmpty()) {
                Collections.sort(matches);
                return ProvX509KeyManagerSimple.getAliases(matches);
            }
        }
        return null;
    }

    private Match getBestMatch(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatchSoFar = Match.NOTHING;
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            int keyTypeLimit = keyTypes.size();
            Set<Principal> uniqueIssuers = ProvX509KeyManager.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManager.getRequestedHostName(transportData, forServer);
            for (Credential credential : this.credentials.values()) {
                Match match = this.getPotentialMatch(credential, keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
                if (match.compareTo(bestMatchSoFar) >= 0) continue;
                bestMatchSoFar = match;
                if (bestMatchSoFar.isIdeal()) {
                    return bestMatchSoFar;
                }
                if (!bestMatchSoFar.isValid()) continue;
                keyTypeLimit = Math.min(keyTypeLimit, bestMatchSoFar.keyTypeIndex + 1);
            }
        }
        return bestMatchSoFar;
    }

    private Match getPotentialMatch(Credential credential, List<String> keyTypes, int keyTypeLimit, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) {
        ProvX509KeyManager.MatchQuality quality;
        X509Certificate[] chain = credential.certificateChain;
        int keyTypeIndex = ProvX509KeyManager.getPotentialKeyType(keyTypes, keyTypeLimit, uniqueIssuers, algorithmConstraints, forServer, chain);
        if (keyTypeIndex >= 0 && ProvX509KeyManager.MatchQuality.NONE != (quality = ProvX509KeyManager.getKeyTypeQuality(this.isInFipsMode, this.helper, keyTypes, algorithmConstraints, forServer, atDate, requestedHostName, chain, keyTypeIndex))) {
            return new Match(quality, keyTypeIndex, credential);
        }
        return Match.NOTHING;
    }

    private Credential getCredential(String alias) {
        return null == alias ? null : this.credentials.get(alias);
    }

    private static List<Match> addToMatches(List<Match> matches, Match match) {
        if (null == matches) {
            matches = new ArrayList<Match>();
        }
        matches.add(match);
        return matches;
    }

    private static String getAlias(Match match) {
        return match.credential.alias;
    }

    private static String[] getAliases(List<Match> matches) {
        int count = matches.size();
        int pos = 0;
        String[] result = new String[count];
        for (Match match : matches) {
            result[pos++] = ProvX509KeyManagerSimple.getAlias(match);
        }
        return result;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Credential {
        private final String alias;
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(String alias, PrivateKey privateKey, X509Certificate[] certificateChain) {
            this.alias = alias;
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Match
    implements Comparable<Match> {
        static final ProvX509KeyManager.MatchQuality INVALID = ProvX509KeyManager.MatchQuality.MISMATCH_SNI;
        static final Match NOTHING = new Match(ProvX509KeyManager.MatchQuality.NONE, Integer.MAX_VALUE, null);
        final ProvX509KeyManager.MatchQuality quality;
        final int keyTypeIndex;
        final Credential credential;

        Match(ProvX509KeyManager.MatchQuality quality, int keyTypeIndex, Credential credential) {
            this.quality = quality;
            this.keyTypeIndex = keyTypeIndex;
            this.credential = credential;
        }

        @Override
        public int compareTo(Match that) {
            boolean thatValid;
            boolean thisValid = this.isValid();
            if (thisValid != (thatValid = that.isValid())) {
                return thisValid ? -1 : 1;
            }
            if (this.keyTypeIndex != that.keyTypeIndex) {
                return this.keyTypeIndex < that.keyTypeIndex ? -1 : 1;
            }
            return this.quality.compareTo(that.quality);
        }

        boolean isIdeal() {
            return ProvX509KeyManager.MatchQuality.OK == this.quality && 0 == this.keyTypeIndex;
        }

        boolean isValid() {
            return this.quality.compareTo(INVALID) < 0;
        }
    }
}

