/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.SaslUtil;

@InterfaceAudience.Private
public class SaslUnwrapHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final SaslClient saslClient;

    public SaslUnwrapHandler(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SaslUtil.safeDispose(this.saslClient);
        ctx.fireChannelInactive();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])this.saslClient.unwrap(bytes, 0, bytes.length)));
    }
}

