/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RouterSnapshot {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public RouterSnapshot(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcServer.getNamenodeResolver();
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("allowSnapshot", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void disallowSnapshot(String snapshotRoot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("disallowSnapshot", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("createSnapshot", new Class[]{String.class, String.class}, new RemoteParam(), snapshotName);
        String result = null;
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            Map<RemoteLocation, String> results = this.rpcClient.invokeConcurrent(locations, method, String.class);
            Map.Entry<RemoteLocation, String> firstelement = results.entrySet().iterator().next();
            RemoteLocation loc = firstelement.getKey();
            result = firstelement.getValue();
            result = result.replaceFirst(loc.getDest(), loc.getSrc());
        } else {
            result = this.rpcClient.invokeSequential(locations, method, String.class, null);
            RemoteLocation loc = locations.get(0);
            result = result.replaceFirst(loc.getDest(), loc.getSrc());
        }
        return result;
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("deleteSnapshot", new Class[]{String.class, String.class}, new RemoteParam(), snapshotName);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void renameSnapshot(String snapshotRoot, String oldSnapshotName, String newSnapshot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("renameSnapshot", new Class[]{String.class, String.class, String.class}, new RemoteParam(), oldSnapshotName, newSnapshot);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getSnapshottableDirListing");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, SnapshottableDirectoryStatus[]> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, SnapshottableDirectoryStatus[].class);
        return RouterRpcServer.merge(ret, SnapshottableDirectoryStatus.class);
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod remoteMethod = new RemoteMethod("getSnapshotDiffReport", new Class[]{String.class, String.class, String.class}, new RemoteParam(), earlierSnapshotName, laterSnapshotName);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            Map<RemoteLocation, SnapshotDiffReport> ret = this.rpcClient.invokeConcurrent(locations, remoteMethod, true, false, SnapshotDiffReport.class);
            return ret.values().iterator().next();
        }
        return this.rpcClient.invokeSequential(locations, remoteMethod, SnapshotDiffReport.class, null);
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName, byte[] startPath, int index) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        Class[] params = new Class[]{String.class, String.class, String.class, byte[].class, Integer.TYPE};
        RemoteMethod remoteMethod = new RemoteMethod("getSnapshotDiffReportListing", params, new RemoteParam(), earlierSnapshotName, laterSnapshotName, startPath, index);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            Map<RemoteLocation, SnapshotDiffReportListing> ret = this.rpcClient.invokeConcurrent(locations, remoteMethod, false, false, SnapshotDiffReportListing.class);
            Collection<SnapshotDiffReportListing> listings = ret.values();
            SnapshotDiffReportListing listing0 = listings.iterator().next();
            return listing0;
        }
        return this.rpcClient.invokeSequential(locations, remoteMethod, SnapshotDiffReportListing.class, null);
    }
}

