/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcMonitor;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationRPCPerformanceMonitor
implements RouterRpcMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRPCPerformanceMonitor.class);
    private static final ThreadLocal<Long> START_TIME = new ThreadLocal();
    private static final ThreadLocal<Long> PROXY_TIME = new ThreadLocal();
    private Configuration conf;
    private RouterRpcServer server;
    private StateStoreService store;
    private FederationRPCMetrics metrics;
    private ObjectName registeredBean;
    private ExecutorService executor;

    @Override
    public void init(Configuration configuration, RouterRpcServer rpcServer, StateStoreService stateStore) {
        this.conf = configuration;
        this.server = rpcServer;
        this.store = stateStore;
        this.metrics = FederationRPCMetrics.create(this.conf, this.server);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Federation RPC Performance Monitor-%d").build();
        this.executor = Executors.newFixedThreadPool(1, threadFactory);
        try {
            StandardMBean bean = new StandardMBean(this.metrics, FederationRPCMBean.class);
            this.registeredBean = MBeans.register((String)"Router", (String)"FederationRPC", (Object)bean);
            LOG.info("Registered FederationRPCMBean: {}", (Object)this.registeredBean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FederationRPCMBean setup", e);
        }
    }

    @Override
    public void close() {
        if (this.registeredBean != null) {
            MBeans.unregister((ObjectName)this.registeredBean);
            this.registeredBean = null;
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void resetPerfCounters() {
        if (this.registeredBean != null) {
            MBeans.unregister((ObjectName)this.registeredBean);
            this.registeredBean = null;
        }
        if (this.metrics != null) {
            FederationRPCMetrics.reset();
            this.metrics = null;
        }
        this.init(this.conf, this.server, this.store);
    }

    @Override
    public void startOp() {
        START_TIME.set(Time.monotonicNow());
    }

    @Override
    public long proxyOp() {
        PROXY_TIME.set(Time.monotonicNow());
        long processingTime = this.getProcessingTime();
        if (this.metrics != null && processingTime >= 0L) {
            this.metrics.addProcessingTime(processingTime);
        }
        return Thread.currentThread().getId();
    }

    @Override
    public void proxyOpComplete(boolean success) {
        if (success) {
            long proxyTime = this.getProxyTime();
            if (this.metrics != null && proxyTime >= 0L) {
                this.metrics.addProxyTime(proxyTime);
            }
        }
    }

    @Override
    public void proxyOpFailureStandby() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpFailureStandby();
        }
    }

    @Override
    public void proxyOpFailureCommunicate() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpFailureCommunicate();
        }
    }

    @Override
    public void proxyOpFailureClientOverloaded() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpFailureClientOverloaded();
        }
    }

    @Override
    public void proxyOpNotImplemented() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpNotImplemented();
        }
    }

    @Override
    public void proxyOpRetries() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpRetries();
        }
    }

    @Override
    public void proxyOpNoNamenodes() {
        if (this.metrics != null) {
            this.metrics.incrProxyOpNoNamenodes();
        }
    }

    @Override
    public void routerFailureStateStore() {
        if (this.metrics != null) {
            this.metrics.incrRouterFailureStateStore();
        }
    }

    @Override
    public void routerFailureSafemode() {
        if (this.metrics != null) {
            this.metrics.incrRouterFailureSafemode();
        }
    }

    @Override
    public void routerFailureReadOnly() {
        if (this.metrics != null) {
            this.metrics.incrRouterFailureReadOnly();
        }
    }

    @Override
    public void routerFailureLocked() {
        if (this.metrics != null) {
            this.metrics.incrRouterFailureLocked();
        }
    }

    private long getProcessingTime() {
        if (START_TIME.get() != null && START_TIME.get() > 0L && PROXY_TIME.get() != null && PROXY_TIME.get() > 0L) {
            return PROXY_TIME.get() - START_TIME.get();
        }
        return -1L;
    }

    private long getProxyTime() {
        if (PROXY_TIME.get() != null && PROXY_TIME.get() > 0L) {
            return Time.monotonicNow() - PROXY_TIME.get();
        }
        return -1L;
    }

    @Override
    public FederationRPCMetrics getRPCMetrics() {
        return this.metrics;
    }
}

