/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FSQueueConverter {
    public static final float QUEUE_MAX_AM_SHARE_DISABLED = -1.0f;
    private static final int MAX_RUNNING_APPS_UNSET = Integer.MAX_VALUE;
    private static final String FAIR_POLICY = "fair";
    private static final String FIFO_POLICY = "fifo";
    private final FSConfigToCSConfigRuleHandler ruleHandler;
    private Configuration capacitySchedulerConfig;
    private final boolean preemptionEnabled;
    private final boolean sizeBasedWeight;
    private final Resource clusterResource;
    private final float queueMaxAMShareDefault;
    private final boolean autoCreateChildQueues;
    private final int queueMaxAppsDefault;
    private final boolean drfUsed;
    private ConversionOptions conversionOptions;

    public FSQueueConverter(FSQueueConverterBuilder builder) {
        this.ruleHandler = builder.ruleHandler;
        this.capacitySchedulerConfig = builder.capacitySchedulerConfig;
        this.preemptionEnabled = builder.preemptionEnabled;
        this.sizeBasedWeight = builder.sizeBasedWeight;
        this.clusterResource = builder.clusterResource;
        this.queueMaxAMShareDefault = builder.queueMaxAMShareDefault;
        this.autoCreateChildQueues = builder.autoCreateChildQueues;
        this.queueMaxAppsDefault = builder.queueMaxAppsDefault;
        this.conversionOptions = builder.conversionOptions;
        this.drfUsed = builder.drfUsed;
    }

    public void convertQueueHierarchy(FSQueue queue) {
        List<FSQueue> children = queue.getChildQueues();
        String queueName = queue.getName();
        this.emitChildQueues(queueName, children);
        this.emitMaxAMShare(queueName, queue);
        this.emitMaxParallelApps(queueName, queue);
        this.emitMaxAllocations(queueName, queue);
        this.emitPreemptionDisabled(queueName, queue);
        this.emitChildCapacity(queue);
        this.emitMaximumCapacity(queueName, queue);
        this.emitAutoCreateChildQueue(queueName, queue);
        this.emitSizeBasedWeight(queueName);
        this.emitOrderingPolicy(queueName, queue);
        this.checkMaxChildCapacitySetting(queue);
        for (FSQueue childQueue : children) {
            this.convertQueueHierarchy(childQueue);
        }
    }

    private void emitChildQueues(String queueName, List<FSQueue> children) {
        this.ruleHandler.handleChildQueueCount(queueName, children.size());
        if (children.size() > 0) {
            String childQueues = children.stream().map(child -> this.getQueueShortName(child.getName())).collect(Collectors.joining(","));
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".queues", childQueues);
        }
    }

    private void emitMaxAMShare(String queueName, FSQueue queue) {
        float queueMaxAmShare = queue.getMaxAMShare();
        if (queueMaxAmShare != 0.0f && queueMaxAmShare != this.queueMaxAMShareDefault && queueMaxAmShare != -1.0f) {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity." + queueName + ".maximum-am-resource-percent", queueMaxAmShare);
        }
        if (queueMaxAmShare == -1.0f && queueMaxAmShare != this.queueMaxAMShareDefault) {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity." + queueName + ".maximum-am-resource-percent", 1.0f);
        }
    }

    private void emitMaxParallelApps(String queueName, FSQueue queue) {
        if (queue.getMaxRunningApps() != Integer.MAX_VALUE && queue.getMaxRunningApps() != this.queueMaxAppsDefault) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".max-parallel-apps", String.valueOf(queue.getMaxRunningApps()));
        }
    }

    private void emitMaximumCapacity(String queueName, FSQueue queue) {
        ConfigurableResource rawMaxShare = queue.getRawMaxShare();
        Resource maxResource = rawMaxShare.getResource();
        if (maxResource == null && rawMaxShare.getPercentages() != null || this.isNotUnboundedResource(maxResource)) {
            this.ruleHandler.handleMaxResources();
        }
        this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".maximum-capacity", "100");
    }

    private void emitMaxAllocations(String queueName, FSQueue queue) {
        Resource maxAllocation = queue.getMaximumContainerAllocation();
        if (this.isNotUnboundedResource(maxAllocation)) {
            FSParentQueue parent;
            Resource parentMaxAllocation;
            long parentMaxVcores = Integer.MIN_VALUE;
            long parentMaxMemory = Integer.MIN_VALUE;
            if (queue.getParent() != null && this.isNotUnboundedResource(parentMaxAllocation = ((FSQueue)(parent = queue.getParent())).getMaximumContainerAllocation())) {
                parentMaxVcores = parentMaxAllocation.getVirtualCores();
                parentMaxMemory = parentMaxAllocation.getMemorySize();
            }
            long maxVcores = maxAllocation.getVirtualCores();
            long maxMemory = maxAllocation.getMemorySize();
            if (maxVcores != parentMaxVcores || maxMemory != parentMaxMemory) {
                this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".maximum-allocation-mb", String.valueOf(maxMemory));
                this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".maximum-allocation-vcores", String.valueOf(maxVcores));
            }
        }
    }

    private void emitPreemptionDisabled(String queueName, FSQueue queue) {
        if (this.preemptionEnabled && !queue.isPreemptable()) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".disable_preemption", "true");
        }
    }

    private void emitAutoCreateChildQueue(String queueName, FSQueue queue) {
        if (this.autoCreateChildQueues && !queue.getChildQueues().isEmpty() && !queueName.equals("root")) {
            this.capacitySchedulerConfig.setBoolean("yarn.scheduler.capacity." + queueName + ".auto-create-child-queue.enabled", true);
        }
    }

    private void emitSizeBasedWeight(String queueName) {
        if (this.sizeBasedWeight) {
            this.capacitySchedulerConfig.setBoolean("yarn.scheduler.capacity." + queueName + ".ordering-policy.fair.enable-size-based-weight", true);
        }
    }

    private void emitOrderingPolicy(String queueName, FSQueue queue) {
        if (queue instanceof FSLeafQueue) {
            String policy;
            switch (policy = queue.getPolicy().getName()) {
                case "DRF": {
                    this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".ordering-policy", FAIR_POLICY);
                    break;
                }
                case "fair": {
                    this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".ordering-policy", FAIR_POLICY);
                    if (!this.drfUsed) break;
                    this.ruleHandler.handleFairAsDrf(queueName);
                    break;
                }
                case "FIFO": {
                    this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queueName + ".ordering-policy", FIFO_POLICY);
                    break;
                }
                default: {
                    String msg = String.format("Unexpected ordering policy on queue %s: %s", queue, policy);
                    this.conversionOptions.handleConversionError(msg);
                }
            }
        }
    }

    private void emitChildCapacity(FSQueue queue) {
        List<FSQueue> children = queue.getChildQueues();
        int totalWeight = this.getTotalWeight(children);
        Map<String, BigDecimal> capacities = this.getCapacities(totalWeight, children);
        capacities.forEach((key, value) -> this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + key + ".capacity", value.toString()));
    }

    private void checkMaxChildCapacitySetting(FSQueue queue) {
        Resource resource;
        if (queue.getMaxChildQueueResource() != null && ((resource = queue.getMaxChildQueueResource().getResource()) != null && this.isNotUnboundedResource(resource) || queue.getMaxChildQueueResource().getPercentages() != null)) {
            this.ruleHandler.handleMaxChildCapacity();
        }
    }

    private Map<String, BigDecimal> getCapacities(int totalWeight, List<FSQueue> children) {
        BigDecimal hundred = new BigDecimal(100).setScale(3);
        if (children.size() == 0) {
            return new HashMap<String, BigDecimal>();
        }
        if (children.size() == 1) {
            HashMap<String, BigDecimal> capacity = new HashMap<String, BigDecimal>();
            String queueName = children.get(0).getName();
            capacity.put(queueName, hundred);
            return capacity;
        }
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        children.stream().forEach(queue -> {
            BigDecimal total = new BigDecimal(totalWeight);
            BigDecimal weight = new BigDecimal(queue.getWeight());
            BigDecimal pct = weight.setScale(5).divide(total, RoundingMode.HALF_UP).multiply(hundred).setScale(3);
            if (Resources.none().compareTo(queue.getMinShare()) != 0) {
                this.ruleHandler.handleMinResources();
            }
            capacities.put(queue.getName(), pct);
        });
        BigDecimal totalPct = new BigDecimal(0);
        for (Map.Entry entry : capacities.entrySet()) {
            totalPct = totalPct.add((BigDecimal)entry.getValue());
        }
        if (!totalPct.equals(hundred)) {
            BigDecimal tmp = new BigDecimal(0);
            for (int i = 0; i < children.size() - 1; ++i) {
                tmp = tmp.add((BigDecimal)capacities.get(children.get(i).getQueueName()));
            }
            String lastQueue = children.get(children.size() - 1).getName();
            BigDecimal corrected = hundred.subtract(tmp);
            capacities.put(lastQueue, corrected);
        }
        return capacities;
    }

    private int getTotalWeight(List<FSQueue> children) {
        double sum = children.stream().mapToDouble(c -> c.getWeight()).sum();
        return (int)sum;
    }

    private String getQueueShortName(String queueName) {
        int lastDot = queueName.lastIndexOf(".");
        return queueName.substring(lastDot + 1);
    }

    private boolean isNotUnboundedResource(Resource res) {
        return Resources.unbounded().compareTo(res) != 0;
    }
}

