/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServlet;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Server;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.ServerConnector;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ServletHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class NotificationTestCase
extends HadoopTestCase {
    private int port;
    private String contextPath = "/notification";
    private String servletPath = "/mapred";
    private Server webServer;

    protected NotificationTestCase(int mode) throws IOException {
        super(mode, 4, 1, 1);
    }

    private void startHttpServer() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
            this.webServer = null;
        }
        this.webServer = new Server(0);
        ServletContextHandler context = new ServletContextHandler(this.webServer, this.contextPath);
        context.addServlet(new ServletHolder((Servlet)new NotificationServlet()), this.servletPath);
        this.webServer.start();
        this.port = ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
    }

    private void stopHttpServer() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
            this.webServer.destroy();
            this.webServer = null;
        }
    }

    private String getNotificationUrlTemplate() {
        return "http://localhost:" + this.port + this.contextPath + this.servletPath + "?jobId=$jobId&amp;jobStatus=$jobStatus";
    }

    @Override
    protected JobConf createJobConf() {
        JobConf conf = super.createJobConf();
        conf.setJobEndNotificationURI(this.getNotificationUrlTemplate());
        conf.setInt("mapreduce.job.end-notification.retry.attempts", 3);
        conf.setInt("mapreduce.job.end-notification.retry.interval", 200);
        return conf;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startHttpServer();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.stopHttpServer();
        super.tearDown();
    }

    @Test
    public void testMR() throws Exception {
        int tries;
        System.out.println(this.launchWordCount(this.createJobConf(), "a b c d e f g h", 1, 1));
        boolean keepTrying = true;
        for (int tries2 = 0; tries2 < 30 && keepTrying; ++tries2) {
            Thread.sleep(50L);
            keepTrying = NotificationServlet.counter != 2;
        }
        Assert.assertEquals((long)2L, (long)NotificationServlet.counter);
        Assert.assertEquals((long)0L, (long)NotificationServlet.failureCounter);
        Path inDir = new Path("notificationjob/input");
        Path outDir = new Path("notificationjob/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").toString().replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        System.out.println(UtilsForTests.runJobKill(this.createJobConf(), inDir, outDir).getID());
        keepTrying = true;
        for (tries = 0; tries < 30 && keepTrying; ++tries) {
            Thread.sleep(50L);
            keepTrying = NotificationServlet.counter != 4;
        }
        Assert.assertEquals((long)4L, (long)NotificationServlet.counter);
        Assert.assertEquals((long)0L, (long)NotificationServlet.failureCounter);
        System.out.println(UtilsForTests.runJobFail(this.createJobConf(), inDir, outDir).getID());
        keepTrying = true;
        for (tries = 0; tries < 30 && keepTrying; ++tries) {
            Thread.sleep(50L);
            keepTrying = NotificationServlet.counter != 6;
        }
        Assert.assertEquals((long)6L, (long)NotificationServlet.counter);
        Assert.assertEquals((long)0L, (long)NotificationServlet.failureCounter);
    }

    private String launchWordCount(JobConf conf, String input, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("testing/wc/input");
        Path outDir = new Path("testing/wc/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").toString().replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("wordcount");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        JobClient.runJob((JobConf)conf);
        return MapReduceTestUtil.readOutput(outDir, (Configuration)conf);
    }

    public static class NotificationServlet
    extends HttpServlet {
        public static volatile int counter = 0;
        public static volatile int failureCounter = 0;
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            String queryString = req.getQueryString();
            switch (counter) {
                case 0: {
                    this.verifyQuery(queryString, "SUCCEEDED");
                    break;
                }
                case 2: {
                    this.verifyQuery(queryString, "KILLED");
                    break;
                }
                case 4: {
                    this.verifyQuery(queryString, "FAILED");
                }
            }
            if (counter % 2 == 0) {
                res.sendError(400, "forcing error");
            } else {
                res.setStatus(200);
            }
            ++counter;
        }

        protected void verifyQuery(String query, String expected) throws IOException {
            if (query.contains(expected)) {
                return;
            }
            ++failureCounter;
            Assert.assertTrue((String)("The request (" + query + ") does not contain " + expected), (boolean)false);
        }
    }
}

