/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.LimitInputStream;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public final class PBImageXmlWriter {
    public static final String NAME_SECTION_NAME = "NameSection";
    public static final String ERASURE_CODING_SECTION_NAME = "ErasureCodingSection";
    public static final String INODE_SECTION_NAME = "INodeSection";
    public static final String SECRET_MANAGER_SECTION_NAME = "SecretManagerSection";
    public static final String CACHE_MANAGER_SECTION_NAME = "CacheManagerSection";
    public static final String SNAPSHOT_DIFF_SECTION_NAME = "SnapshotDiffSection";
    public static final String INODE_REFERENCE_SECTION_NAME = "INodeReferenceSection";
    public static final String INODE_DIRECTORY_SECTION_NAME = "INodeDirectorySection";
    public static final String FILE_UNDER_CONSTRUCTION_SECTION_NAME = "FileUnderConstructionSection";
    public static final String SNAPSHOT_SECTION_NAME = "SnapshotSection";
    public static final String SECTION_ID = "id";
    public static final String SECTION_REPLICATION = "replication";
    public static final String SECTION_PATH = "path";
    public static final String SECTION_NAME = "name";
    public static final String NAME_SECTION_NAMESPACE_ID = "namespaceId";
    public static final String NAME_SECTION_GENSTAMPV1 = "genstampV1";
    public static final String NAME_SECTION_GENSTAMPV2 = "genstampV2";
    public static final String NAME_SECTION_GENSTAMPV1_LIMIT = "genstampV1Limit";
    public static final String NAME_SECTION_LAST_ALLOCATED_BLOCK_ID = "lastAllocatedBlockId";
    public static final String NAME_SECTION_TXID = "txid";
    public static final String NAME_SECTION_ROLLING_UPGRADE_START_TIME = "rollingUpgradeStartTime";
    public static final String NAME_SECTION_LAST_ALLOCATED_STRIPED_BLOCK_ID = "lastAllocatedStripedBlockId";
    public static final String ERASURE_CODING_SECTION_POLICY = "erasureCodingPolicy";
    public static final String ERASURE_CODING_SECTION_POLICY_ID = "policyId";
    public static final String ERASURE_CODING_SECTION_POLICY_NAME = "policyName";
    public static final String ERASURE_CODING_SECTION_POLICY_CELL_SIZE = "cellSize";
    public static final String ERASURE_CODING_SECTION_POLICY_STATE = "policyState";
    public static final String ERASURE_CODING_SECTION_SCHEMA = "ecSchema";
    public static final String ERASURE_CODING_SECTION_SCHEMA_CODEC_NAME = "codecName";
    public static final String ERASURE_CODING_SECTION_SCHEMA_DATA_UNITS = "dataUnits";
    public static final String ERASURE_CODING_SECTION_SCHEMA_PARITY_UNITS = "parityUnits";
    public static final String ERASURE_CODING_SECTION_SCHEMA_OPTIONS = "extraOptions";
    public static final String ERASURE_CODING_SECTION_SCHEMA_OPTION = "option";
    public static final String ERASURE_CODING_SECTION_SCHEMA_OPTION_KEY = "key";
    public static final String ERASURE_CODING_SECTION_SCHEMA_OPTION_VALUE = "value";
    public static final String INODE_SECTION_LAST_INODE_ID = "lastInodeId";
    public static final String INODE_SECTION_NUM_INODES = "numInodes";
    public static final String INODE_SECTION_TYPE = "type";
    public static final String INODE_SECTION_MTIME = "mtime";
    public static final String INODE_SECTION_ATIME = "atime";
    public static final String INODE_SECTION_PREFERRED_BLOCK_SIZE = "preferredBlockSize";
    public static final String INODE_SECTION_PERMISSION = "permission";
    public static final String INODE_SECTION_BLOCKS = "blocks";
    public static final String INODE_SECTION_BLOCK = "block";
    public static final String INODE_SECTION_GENSTAMP = "genstamp";
    public static final String INODE_SECTION_NUM_BYTES = "numBytes";
    public static final String INODE_SECTION_FILE_UNDER_CONSTRUCTION = "file-under-construction";
    public static final String INODE_SECTION_CLIENT_NAME = "clientName";
    public static final String INODE_SECTION_CLIENT_MACHINE = "clientMachine";
    public static final String INODE_SECTION_ACL = "acl";
    public static final String INODE_SECTION_ACLS = "acls";
    public static final String INODE_SECTION_XATTR = "xattr";
    public static final String INODE_SECTION_XATTRS = "xattrs";
    public static final String INODE_SECTION_STORAGE_POLICY_ID = "storagePolicyId";
    public static final String INODE_SECTION_BLOCK_TYPE = "blockType";
    public static final String INODE_SECTION_EC_POLICY_ID = "erasureCodingPolicyId";
    public static final String INODE_SECTION_NS_QUOTA = "nsquota";
    public static final String INODE_SECTION_DS_QUOTA = "dsquota";
    public static final String INODE_SECTION_TYPE_QUOTA = "typeQuota";
    public static final String INODE_SECTION_QUOTA = "quota";
    public static final String INODE_SECTION_TARGET = "target";
    public static final String INODE_SECTION_NS = "ns";
    public static final String INODE_SECTION_VAL = "val";
    public static final String INODE_SECTION_VAL_HEX = "valHex";
    public static final String INODE_SECTION_INODE = "inode";
    public static final String SECRET_MANAGER_SECTION_CURRENT_ID = "currentId";
    public static final String SECRET_MANAGER_SECTION_TOKEN_SEQUENCE_NUMBER = "tokenSequenceNumber";
    public static final String SECRET_MANAGER_SECTION_NUM_DELEGATION_KEYS = "numDelegationKeys";
    public static final String SECRET_MANAGER_SECTION_NUM_TOKENS = "numTokens";
    public static final String SECRET_MANAGER_SECTION_EXPIRY = "expiry";
    public static final String SECRET_MANAGER_SECTION_KEY = "key";
    public static final String SECRET_MANAGER_SECTION_DELEGATION_KEY = "delegationKey";
    public static final String SECRET_MANAGER_SECTION_VERSION = "version";
    public static final String SECRET_MANAGER_SECTION_OWNER = "owner";
    public static final String SECRET_MANAGER_SECTION_RENEWER = "renewer";
    public static final String SECRET_MANAGER_SECTION_REAL_USER = "realUser";
    public static final String SECRET_MANAGER_SECTION_ISSUE_DATE = "issueDate";
    public static final String SECRET_MANAGER_SECTION_MAX_DATE = "maxDate";
    public static final String SECRET_MANAGER_SECTION_SEQUENCE_NUMBER = "sequenceNumber";
    public static final String SECRET_MANAGER_SECTION_MASTER_KEY_ID = "masterKeyId";
    public static final String SECRET_MANAGER_SECTION_EXPIRY_DATE = "expiryDate";
    public static final String SECRET_MANAGER_SECTION_TOKEN = "token";
    public static final String CACHE_MANAGER_SECTION_NEXT_DIRECTIVE_ID = "nextDirectiveId";
    public static final String CACHE_MANAGER_SECTION_NUM_POOLS = "numPools";
    public static final String CACHE_MANAGER_SECTION_NUM_DIRECTIVES = "numDirectives";
    public static final String CACHE_MANAGER_SECTION_POOL_NAME = "poolName";
    public static final String CACHE_MANAGER_SECTION_OWNER_NAME = "ownerName";
    public static final String CACHE_MANAGER_SECTION_GROUP_NAME = "groupName";
    public static final String CACHE_MANAGER_SECTION_MODE = "mode";
    public static final String CACHE_MANAGER_SECTION_LIMIT = "limit";
    public static final String CACHE_MANAGER_SECTION_MAX_RELATIVE_EXPIRY = "maxRelativeExpiry";
    public static final String CACHE_MANAGER_SECTION_POOL = "pool";
    public static final String CACHE_MANAGER_SECTION_EXPIRATION = "expiration";
    public static final String CACHE_MANAGER_SECTION_MILLIS = "millis";
    public static final String CACHE_MANAGER_SECTION_RELATIVE = "relative";
    public static final String CACHE_MANAGER_SECTION_DIRECTIVE = "directive";
    public static final String SNAPSHOT_DIFF_SECTION_INODE_ID = "inodeId";
    public static final String SNAPSHOT_DIFF_SECTION_COUNT = "count";
    public static final String SNAPSHOT_DIFF_SECTION_SNAPSHOT_ID = "snapshotId";
    public static final String SNAPSHOT_DIFF_SECTION_CHILDREN_SIZE = "childrenSize";
    public static final String SNAPSHOT_DIFF_SECTION_IS_SNAPSHOT_ROOT = "isSnapshotRoot";
    public static final String SNAPSHOT_DIFF_SECTION_SNAPSHOT_COPY = "snapshotCopy";
    public static final String SNAPSHOT_DIFF_SECTION_CREATED_LIST_SIZE = "createdListSize";
    public static final String SNAPSHOT_DIFF_SECTION_DELETED_INODE = "deletedInode";
    public static final String SNAPSHOT_DIFF_SECTION_DELETED_INODE_REF = "deletedInoderef";
    public static final String SNAPSHOT_DIFF_SECTION_CREATED = "created";
    public static final String SNAPSHOT_DIFF_SECTION_SIZE = "size";
    public static final String SNAPSHOT_DIFF_SECTION_FILE_DIFF_ENTRY = "fileDiffEntry";
    public static final String SNAPSHOT_DIFF_SECTION_DIR_DIFF_ENTRY = "dirDiffEntry";
    public static final String SNAPSHOT_DIFF_SECTION_FILE_DIFF = "fileDiff";
    public static final String SNAPSHOT_DIFF_SECTION_DIR_DIFF = "dirDiff";
    public static final String INODE_REFERENCE_SECTION_REFERRED_ID = "referredId";
    public static final String INODE_REFERENCE_SECTION_DST_SNAPSHOT_ID = "dstSnapshotId";
    public static final String INODE_REFERENCE_SECTION_LAST_SNAPSHOT_ID = "lastSnapshotId";
    public static final String INODE_REFERENCE_SECTION_REF = "ref";
    public static final String INODE_DIRECTORY_SECTION_PARENT = "parent";
    public static final String INODE_DIRECTORY_SECTION_CHILD = "child";
    public static final String INODE_DIRECTORY_SECTION_REF_CHILD = "refChild";
    public static final String INODE_DIRECTORY_SECTION_DIRECTORY = "directory";
    public static final String SNAPSHOT_SECTION_SNAPSHOT_COUNTER = "snapshotCounter";
    public static final String SNAPSHOT_SECTION_NUM_SNAPSHOTS = "numSnapshots";
    public static final String SNAPSHOT_SECTION_SNAPSHOT_TABLE_DIR = "snapshottableDir";
    public static final String SNAPSHOT_SECTION_DIR = "dir";
    public static final String SNAPSHOT_SECTION_ROOT = "root";
    public static final String SNAPSHOT_SECTION_SNAPSHOT = "snapshot";
    private final Configuration conf;
    private final PrintStream out;
    private final SimpleDateFormat isoDateFormat;
    private SerialNumberManager.StringTable stringTable;

    public static SimpleDateFormat createSimpleDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public PBImageXmlWriter(Configuration conf, PrintStream out) {
        this.conf = conf;
        this.out = out;
        this.isoDateFormat = PBImageXmlWriter.createSimpleDateFormat();
    }

    public void visit(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        try (FileInputStream fin = new FileInputStream(file.getFD());){
            this.out.print("<?xml version=\"1.0\"?>\n<fsimage>");
            this.out.print("<version>");
            this.o("layoutVersion", summary.getLayoutVersion());
            this.o("onDiskVersion", summary.getOndiskVersion());
            this.o("oivRevision", VersionInfo.getRevision());
            this.out.print("</version>\n");
            ArrayList sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            for (FsImageProto.FileSummary.Section s : sections) {
                fin.getChannel().position(s.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, s.getLength())));
                FSImageFormatProtobuf.SectionName sectionName = FSImageFormatProtobuf.SectionName.fromString(s.getName());
                if (sectionName == null) {
                    throw new IOException("Unrecognized section " + s.getName());
                }
                switch (sectionName) {
                    case NS_INFO: {
                        this.dumpNameSection(is);
                        break;
                    }
                    case STRING_TABLE: {
                        this.loadStringTable(is);
                        break;
                    }
                    case ERASURE_CODING: {
                        this.dumpErasureCodingSection(is);
                        break;
                    }
                    case INODE: {
                        this.dumpINodeSection(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        this.dumpINodeReferenceSection(is);
                        break;
                    }
                    case INODE_DIR: {
                        this.dumpINodeDirectorySection(is);
                        break;
                    }
                    case FILES_UNDERCONSTRUCTION: {
                        this.dumpFileUnderConstructionSection(is);
                        break;
                    }
                    case SNAPSHOT: {
                        this.dumpSnapshotSection(is);
                        break;
                    }
                    case SNAPSHOT_DIFF: {
                        this.dumpSnapshotDiffSection(is);
                        break;
                    }
                    case SECRET_MANAGER: {
                        this.dumpSecretManagerSection(is);
                        break;
                    }
                    case CACHE_MANAGER: {
                        this.dumpCacheManagerSection(is);
                        break;
                    }
                }
            }
            this.out.print("</fsimage>\n");
        }
    }

    private void dumpCacheManagerSection(InputStream is) throws IOException {
        ClientNamenodeProtocolProtos.CachePoolInfoProto p;
        int i;
        this.out.print("<CacheManagerSection>");
        FsImageProto.CacheManagerSection s = FsImageProto.CacheManagerSection.parseDelimitedFrom(is);
        this.o(CACHE_MANAGER_SECTION_NEXT_DIRECTIVE_ID, s.getNextDirectiveId());
        this.o(CACHE_MANAGER_SECTION_NUM_DIRECTIVES, s.getNumDirectives());
        this.o(CACHE_MANAGER_SECTION_NUM_POOLS, s.getNumPools());
        for (i = 0; i < s.getNumPools(); ++i) {
            p = ClientNamenodeProtocolProtos.CachePoolInfoProto.parseDelimitedFrom((InputStream)is);
            this.out.print("<pool>");
            this.o(CACHE_MANAGER_SECTION_POOL_NAME, p.getPoolName()).o(CACHE_MANAGER_SECTION_OWNER_NAME, p.getOwnerName()).o(CACHE_MANAGER_SECTION_GROUP_NAME, p.getGroupName()).o(CACHE_MANAGER_SECTION_MODE, p.getMode()).o(CACHE_MANAGER_SECTION_LIMIT, p.getLimit()).o(CACHE_MANAGER_SECTION_MAX_RELATIVE_EXPIRY, p.getMaxRelativeExpiry());
            this.out.print("</pool>\n");
        }
        for (i = 0; i < s.getNumDirectives(); ++i) {
            p = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.parseDelimitedFrom((InputStream)is);
            this.out.print("<directive>");
            this.o(SECTION_ID, p.getId()).o(SECTION_PATH, p.getPath()).o(SECTION_REPLICATION, p.getReplication()).o(CACHE_MANAGER_SECTION_POOL, p.getPool());
            this.out.print("<expiration>");
            ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto e = p.getExpiration();
            this.o(CACHE_MANAGER_SECTION_MILLIS, e.getMillis()).o(CACHE_MANAGER_SECTION_RELATIVE, e.getIsRelative());
            this.out.print("</expiration>\n");
            this.out.print("</directive>\n");
        }
        this.out.print("</CacheManagerSection>\n");
    }

    private void dumpFileUnderConstructionSection(InputStream in) throws IOException {
        FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e;
        this.out.print("<FileUnderConstructionSection>");
        while ((e = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<inode>");
            this.o(SECTION_ID, e.getInodeId()).o(SECTION_PATH, e.getFullPath());
            this.out.print("</inode>\n");
        }
        this.out.print("</FileUnderConstructionSection>\n");
    }

    private void dumpXattrs(FsImageProto.INodeSection.XAttrFeatureProto xattrs) {
        this.out.print("<xattrs>");
        for (FsImageProto.INodeSection.XAttrCompactProto xattr : xattrs.getXAttrsList()) {
            this.out.print("<xattr>");
            int encodedName = xattr.getName();
            int ns = 3 & encodedName >> 30 | (1 & encodedName >> 5) << 2;
            this.o(INODE_SECTION_NS, XAttrProtos.XAttrProto.XAttrNamespaceProto.forNumber((int)ns).toString());
            this.o(SECTION_NAME, SerialNumberManager.XATTR.getString(0xFFFFFF & encodedName >> 6, this.stringTable));
            ByteString val = xattr.getValue();
            if (val.isValidUtf8()) {
                this.o(INODE_SECTION_VAL, val.toStringUtf8());
            } else {
                this.o(INODE_SECTION_VAL_HEX, Hex.encodeHexString((byte[])val.toByteArray()));
            }
            this.out.print("</xattr>");
        }
        this.out.print("</xattrs>");
    }

    private void dumpINodeDirectory(FsImageProto.INodeSection.INodeDirectory d) {
        FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto typeQuotas;
        this.o(INODE_SECTION_MTIME, d.getModificationTime()).o(INODE_SECTION_PERMISSION, this.dumpPermission(d.getPermission()));
        if (d.hasXAttrs()) {
            this.dumpXattrs(d.getXAttrs());
        }
        this.dumpAcls(d.getAcl());
        if (d.hasDsQuota() && d.hasNsQuota()) {
            this.o(INODE_SECTION_NS_QUOTA, d.getNsQuota()).o(INODE_SECTION_DS_QUOTA, d.getDsQuota());
        }
        if ((typeQuotas = d.getTypeQuotas()) != null) {
            for (FsImageProto.INodeSection.QuotaByStorageTypeEntryProto entry : typeQuotas.getQuotasList()) {
                this.out.print("<typeQuota>");
                this.o(INODE_SECTION_TYPE, entry.getStorageType().toString());
                this.o(INODE_SECTION_QUOTA, entry.getQuota());
                this.out.print("</typeQuota>");
            }
        }
    }

    private void dumpINodeDirectorySection(InputStream in) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        this.out.print("<INodeDirectorySection>");
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<directory>");
            this.o(INODE_DIRECTORY_SECTION_PARENT, e.getParent());
            Iterator<Number> iterator = e.getChildrenList().iterator();
            while (iterator.hasNext()) {
                long id = iterator.next();
                this.o(INODE_DIRECTORY_SECTION_CHILD, id);
            }
            iterator = e.getRefChildrenList().iterator();
            while (iterator.hasNext()) {
                int refId = (Integer)iterator.next();
                this.o(INODE_DIRECTORY_SECTION_REF_CHILD, refId);
            }
            this.out.print("</directory>\n");
        }
        this.out.print("</INodeDirectorySection>\n");
    }

    private void dumpINodeReferenceSection(InputStream in) throws IOException {
        FsImageProto.INodeReferenceSection.INodeReference e;
        this.out.print("<INodeReferenceSection>");
        while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom(in)) != null) {
            this.dumpINodeReference(e);
        }
        this.out.print("</INodeReferenceSection>");
    }

    private void dumpINodeReference(FsImageProto.INodeReferenceSection.INodeReference r) {
        this.out.print("<ref>");
        this.o(INODE_REFERENCE_SECTION_REFERRED_ID, r.getReferredId()).o(SECTION_NAME, r.getName().toStringUtf8()).o(INODE_REFERENCE_SECTION_DST_SNAPSHOT_ID, r.getDstSnapshotId()).o(INODE_REFERENCE_SECTION_LAST_SNAPSHOT_ID, r.getLastSnapshotId());
        this.out.print("</ref>\n");
    }

    private void dumpINodeFile(FsImageProto.INodeSection.INodeFile f) {
        if (f.hasErasureCodingPolicyID()) {
            this.o(SECTION_REPLICATION, (short)1);
        } else {
            this.o(SECTION_REPLICATION, f.getReplication());
        }
        this.o(INODE_SECTION_MTIME, f.getModificationTime()).o(INODE_SECTION_ATIME, f.getAccessTime()).o(INODE_SECTION_PREFERRED_BLOCK_SIZE, f.getPreferredBlockSize()).o(INODE_SECTION_PERMISSION, this.dumpPermission(f.getPermission()));
        if (f.hasXAttrs()) {
            this.dumpXattrs(f.getXAttrs());
        }
        this.dumpAcls(f.getAcl());
        if (f.getBlocksCount() > 0) {
            this.out.print("<blocks>");
            for (HdfsProtos.BlockProto b : f.getBlocksList()) {
                this.out.print("<block>");
                this.o(SECTION_ID, b.getBlockId()).o(INODE_SECTION_GENSTAMP, b.getGenStamp()).o(INODE_SECTION_NUM_BYTES, b.getNumBytes());
                this.out.print("</block>\n");
            }
            this.out.print("</blocks>\n");
        }
        if (f.hasStoragePolicyID()) {
            this.o(INODE_SECTION_STORAGE_POLICY_ID, f.getStoragePolicyID());
        }
        if (f.hasErasureCodingPolicyID()) {
            this.o(INODE_SECTION_BLOCK_TYPE, f.getBlockType().name());
            this.o(INODE_SECTION_EC_POLICY_ID, f.getErasureCodingPolicyID());
        }
        if (f.hasFileUC()) {
            FsImageProto.INodeSection.FileUnderConstructionFeature u = f.getFileUC();
            this.out.print("<file-under-construction>");
            this.o(INODE_SECTION_CLIENT_NAME, u.getClientName()).o(INODE_SECTION_CLIENT_MACHINE, u.getClientMachine());
            this.out.print("</file-under-construction>\n");
        }
    }

    private void dumpAcls(FsImageProto.INodeSection.AclFeatureProto aclFeatureProto) {
        ImmutableList<AclEntry> aclEntryList = FSImageFormatPBINode.Loader.loadAclEntries(aclFeatureProto, this.stringTable);
        if (aclEntryList.size() > 0) {
            this.out.print("<acls>");
            for (AclEntry aclEntry : aclEntryList) {
                this.o(INODE_SECTION_ACL, aclEntry.toString());
            }
            this.out.print("</acls>");
        }
    }

    private void dumpErasureCodingSection(InputStream in) throws IOException {
        FsImageProto.ErasureCodingSection s = FsImageProto.ErasureCodingSection.parseDelimitedFrom(in);
        if (s.getPoliciesCount() > 0) {
            this.out.println("<ErasureCodingSection>");
            for (int i = 0; i < s.getPoliciesCount(); ++i) {
                HdfsProtos.ErasureCodingPolicyProto policy = s.getPolicies(i);
                this.dumpErasureCodingPolicy(PBHelperClient.convertErasureCodingPolicyInfo((HdfsProtos.ErasureCodingPolicyProto)policy));
            }
            this.out.println("</ErasureCodingSection>\n");
        }
    }

    private void dumpErasureCodingPolicy(ErasureCodingPolicyInfo ecPolicyInfo) {
        ErasureCodingPolicy ecPolicy = ecPolicyInfo.getPolicy();
        this.out.println("<erasureCodingPolicy>");
        this.o(ERASURE_CODING_SECTION_POLICY_ID, ecPolicy.getId());
        this.o(ERASURE_CODING_SECTION_POLICY_NAME, ecPolicy.getName());
        this.o(ERASURE_CODING_SECTION_POLICY_CELL_SIZE, ecPolicy.getCellSize());
        this.o(ERASURE_CODING_SECTION_POLICY_STATE, ecPolicyInfo.getState());
        this.out.println("<ecSchema>");
        ECSchema schema = ecPolicy.getSchema();
        this.o(ERASURE_CODING_SECTION_SCHEMA_CODEC_NAME, schema.getCodecName());
        this.o(ERASURE_CODING_SECTION_SCHEMA_DATA_UNITS, schema.getNumDataUnits());
        this.o(ERASURE_CODING_SECTION_SCHEMA_PARITY_UNITS, schema.getNumParityUnits());
        if (schema.getExtraOptions().size() > 0) {
            this.out.println("<extraOptions>");
            for (Map.Entry option : schema.getExtraOptions().entrySet()) {
                this.out.println("<option>");
                this.o("key", option.getKey());
                this.o(ERASURE_CODING_SECTION_SCHEMA_OPTION_VALUE, option.getValue());
                this.out.println("</option>");
            }
            this.out.println("</extraOptions>");
        }
        this.out.println("</ecSchema>");
        this.out.println("</erasureCodingPolicy>\n");
    }

    private void dumpINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        this.out.print("<INodeSection>");
        this.o(INODE_SECTION_LAST_INODE_ID, s.getLastInodeId());
        this.o(INODE_SECTION_NUM_INODES, s.getNumInodes());
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            this.out.print("<inode>");
            this.dumpINodeFields(p);
            this.out.print("</inode>\n");
            ++i;
        }
        this.out.print("</INodeSection>\n");
    }

    private void dumpINodeFields(FsImageProto.INodeSection.INode p) {
        this.o(SECTION_ID, p.getId()).o(INODE_SECTION_TYPE, (Object)p.getType()).o(SECTION_NAME, p.getName().toStringUtf8());
        if (p.hasFile()) {
            this.dumpINodeFile(p.getFile());
        } else if (p.hasDirectory()) {
            this.dumpINodeDirectory(p.getDirectory());
        } else if (p.hasSymlink()) {
            this.dumpINodeSymlink(p.getSymlink());
        }
    }

    private void dumpINodeSymlink(FsImageProto.INodeSection.INodeSymlink s) {
        this.o(INODE_SECTION_PERMISSION, this.dumpPermission(s.getPermission())).o(INODE_SECTION_TARGET, s.getTarget().toStringUtf8()).o(INODE_SECTION_MTIME, s.getModificationTime()).o(INODE_SECTION_ATIME, s.getAccessTime());
    }

    private void dumpNameSection(InputStream in) throws IOException {
        FsImageProto.NameSystemSection s = FsImageProto.NameSystemSection.parseDelimitedFrom(in);
        this.out.print("<NameSection>");
        this.o(NAME_SECTION_NAMESPACE_ID, s.getNamespaceId());
        this.o(NAME_SECTION_GENSTAMPV1, s.getGenstampV1()).o(NAME_SECTION_GENSTAMPV2, s.getGenstampV2()).o(NAME_SECTION_GENSTAMPV1_LIMIT, s.getGenstampV1Limit()).o(NAME_SECTION_LAST_ALLOCATED_BLOCK_ID, s.getLastAllocatedBlockId()).o(NAME_SECTION_TXID, s.getTransactionId());
        this.out.print("</NameSection>\n");
    }

    private String dumpPermission(long permission) {
        PermissionStatus permStatus = FSImageFormatPBINode.Loader.loadPermission(permission, this.stringTable);
        return String.format("%s:%s:%04o", permStatus.getUserName(), permStatus.getGroupName(), permStatus.getPermission().toExtendedShort());
    }

    private void dumpSecretManagerSection(InputStream is) throws IOException {
        int i;
        this.out.print("<SecretManagerSection>");
        FsImageProto.SecretManagerSection s = FsImageProto.SecretManagerSection.parseDelimitedFrom(is);
        int expectedNumDelegationKeys = s.getNumKeys();
        int expectedNumTokens = s.getNumTokens();
        this.o(SECRET_MANAGER_SECTION_CURRENT_ID, s.getCurrentId()).o(SECRET_MANAGER_SECTION_TOKEN_SEQUENCE_NUMBER, s.getTokenSequenceNumber()).o(SECRET_MANAGER_SECTION_NUM_DELEGATION_KEYS, expectedNumDelegationKeys).o(SECRET_MANAGER_SECTION_NUM_TOKENS, expectedNumTokens);
        for (i = 0; i < expectedNumDelegationKeys; ++i) {
            FsImageProto.SecretManagerSection.DelegationKey dkey = FsImageProto.SecretManagerSection.DelegationKey.parseDelimitedFrom(is);
            this.out.print("<delegationKey>");
            this.o(SECTION_ID, dkey.getId());
            this.o("key", Hex.encodeHexString((byte[])dkey.getKey().toByteArray()));
            if (dkey.hasExpiryDate()) {
                this.dumpDate(SECRET_MANAGER_SECTION_EXPIRY, dkey.getExpiryDate());
            }
            this.out.print("</delegationKey>");
        }
        for (i = 0; i < expectedNumTokens; ++i) {
            FsImageProto.SecretManagerSection.PersistToken token = FsImageProto.SecretManagerSection.PersistToken.parseDelimitedFrom(is);
            this.out.print("<token>");
            if (token.hasVersion()) {
                this.o(SECRET_MANAGER_SECTION_VERSION, token.getVersion());
            }
            if (token.hasOwner()) {
                this.o(SECRET_MANAGER_SECTION_OWNER, token.getOwner());
            }
            if (token.hasRenewer()) {
                this.o(SECRET_MANAGER_SECTION_RENEWER, token.getRenewer());
            }
            if (token.hasRealUser()) {
                this.o(SECRET_MANAGER_SECTION_REAL_USER, token.getRealUser());
            }
            if (token.hasIssueDate()) {
                this.dumpDate(SECRET_MANAGER_SECTION_ISSUE_DATE, token.getIssueDate());
            }
            if (token.hasMaxDate()) {
                this.dumpDate(SECRET_MANAGER_SECTION_MAX_DATE, token.getMaxDate());
            }
            if (token.hasSequenceNumber()) {
                this.o(SECRET_MANAGER_SECTION_SEQUENCE_NUMBER, token.getSequenceNumber());
            }
            if (token.hasMasterKeyId()) {
                this.o(SECRET_MANAGER_SECTION_MASTER_KEY_ID, token.getMasterKeyId());
            }
            if (token.hasExpiryDate()) {
                this.dumpDate(SECRET_MANAGER_SECTION_EXPIRY_DATE, token.getExpiryDate());
            }
            this.out.print("</token>");
        }
        this.out.print("</SecretManagerSection>");
    }

    private void dumpDate(String tag, long date) {
        this.out.print("<" + tag + ">" + this.isoDateFormat.format(new Date(date)) + "</" + tag + ">");
    }

    private void dumpSnapshotDiffSection(InputStream in) throws IOException {
        FsImageProto.SnapshotDiffSection.DiffEntry e;
        this.out.print("<SnapshotDiffSection>");
        block12: while ((e = FsImageProto.SnapshotDiffSection.DiffEntry.parseDelimitedFrom(in)) != null) {
            switch (e.getType()) {
                case FILEDIFF: {
                    this.out.print("<fileDiffEntry>");
                    break;
                }
                case DIRECTORYDIFF: {
                    this.out.print("<dirDiffEntry>");
                    break;
                }
                default: {
                    throw new IOException("unknown DiffEntry type " + (Object)((Object)e.getType()));
                }
            }
            this.o(SNAPSHOT_DIFF_SECTION_INODE_ID, e.getInodeId());
            this.o(SNAPSHOT_DIFF_SECTION_COUNT, e.getNumOfDiff());
            switch (e.getType()) {
                case FILEDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<fileDiff>");
                        FsImageProto.SnapshotDiffSection.FileDiff f = FsImageProto.SnapshotDiffSection.FileDiff.parseDelimitedFrom(in);
                        this.o(SNAPSHOT_DIFF_SECTION_SNAPSHOT_ID, f.getSnapshotId()).o(SNAPSHOT_DIFF_SECTION_SIZE, f.getFileSize()).o(SECTION_NAME, f.getName().toStringUtf8());
                        FsImageProto.INodeSection.INodeFile snapshotCopy = f.getSnapshotCopy();
                        if (snapshotCopy != null) {
                            this.out.print("<snapshotCopy>");
                            this.dumpINodeFile(snapshotCopy);
                            this.out.print("</snapshotCopy>\n");
                        }
                        if (f.getBlocksCount() > 0) {
                            this.out.print("<blocks>");
                            for (HdfsProtos.BlockProto b : f.getBlocksList()) {
                                this.out.print("<block>");
                                this.o(SECTION_ID, b.getBlockId()).o(INODE_SECTION_GENSTAMP, b.getGenStamp()).o(INODE_SECTION_NUM_BYTES, b.getNumBytes());
                                this.out.print("</block>\n");
                            }
                            this.out.print("</blocks>\n");
                        }
                        this.out.print("</fileDiff>\n");
                    }
                    break;
                }
                case DIRECTORYDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<dirDiff>");
                        FsImageProto.SnapshotDiffSection.DirectoryDiff d = FsImageProto.SnapshotDiffSection.DirectoryDiff.parseDelimitedFrom(in);
                        this.o(SNAPSHOT_DIFF_SECTION_SNAPSHOT_ID, d.getSnapshotId()).o(SNAPSHOT_DIFF_SECTION_CHILDREN_SIZE, d.getChildrenSize()).o(SNAPSHOT_DIFF_SECTION_IS_SNAPSHOT_ROOT, d.getIsSnapshotRoot()).o(SECTION_NAME, d.getName().toStringUtf8());
                        if (d.hasSnapshotCopy()) {
                            this.out.print("<snapshotCopy>");
                            this.dumpINodeDirectory(d.getSnapshotCopy());
                            this.out.print("</snapshotCopy>\n");
                        }
                        this.o(SNAPSHOT_DIFF_SECTION_CREATED_LIST_SIZE, d.getCreatedListSize());
                        Iterator<Number> snapshotCopy = d.getDeletedINodeList().iterator();
                        while (snapshotCopy.hasNext()) {
                            long did = snapshotCopy.next();
                            this.o(SNAPSHOT_DIFF_SECTION_DELETED_INODE, did);
                        }
                        snapshotCopy = d.getDeletedINodeRefList().iterator();
                        while (snapshotCopy.hasNext()) {
                            int dRefid = (Integer)snapshotCopy.next();
                            this.o(SNAPSHOT_DIFF_SECTION_DELETED_INODE_REF, dRefid);
                        }
                        for (int j = 0; j < d.getCreatedListSize(); ++j) {
                            FsImageProto.SnapshotDiffSection.CreatedListEntry ce = FsImageProto.SnapshotDiffSection.CreatedListEntry.parseDelimitedFrom(in);
                            this.out.print("<created>");
                            this.o(SECTION_NAME, ce.getName().toStringUtf8());
                            this.out.print("</created>\n");
                        }
                        this.out.print("</dirDiff>\n");
                    }
                    break;
                }
            }
            switch (e.getType()) {
                case FILEDIFF: {
                    this.out.print("</fileDiffEntry>");
                    continue block12;
                }
                case DIRECTORYDIFF: {
                    this.out.print("</dirDiffEntry>");
                    continue block12;
                }
            }
            throw new IOException("unknown DiffEntry type " + (Object)((Object)e.getType()));
        }
        this.out.print("</SnapshotDiffSection>\n");
    }

    private void dumpSnapshotSection(InputStream in) throws IOException {
        this.out.print("<SnapshotSection>");
        FsImageProto.SnapshotSection s = FsImageProto.SnapshotSection.parseDelimitedFrom(in);
        this.o(SNAPSHOT_SECTION_SNAPSHOT_COUNTER, s.getSnapshotCounter());
        this.o(SNAPSHOT_SECTION_NUM_SNAPSHOTS, s.getNumSnapshots());
        if (s.getSnapshottableDirCount() > 0) {
            this.out.print("<snapshottableDir>");
            for (long id : s.getSnapshottableDirList()) {
                this.o(SNAPSHOT_SECTION_DIR, id);
            }
            this.out.print("</snapshottableDir>\n");
        }
        for (int i = 0; i < s.getNumSnapshots(); ++i) {
            FsImageProto.SnapshotSection.Snapshot pbs = FsImageProto.SnapshotSection.Snapshot.parseDelimitedFrom(in);
            this.out.print("<snapshot>");
            this.o(SECTION_ID, pbs.getSnapshotId());
            this.out.print("<root>");
            this.dumpINodeFields(pbs.getRoot());
            this.out.print("</root>");
            this.out.print("</snapshot>");
        }
        this.out.print("</SnapshotSection>\n");
    }

    private void loadStringTable(InputStream in) throws IOException {
        this.stringTable = FSImageLoader.loadStringTable(in);
    }

    private PBImageXmlWriter o(String e, Object v) {
        if (v instanceof Boolean) {
            if (((Boolean)v).booleanValue()) {
                this.out.print("<" + e + "/>");
            }
            return this;
        }
        this.out.print("<" + e + ">" + XMLUtils.mangleXmlString(v.toString(), true) + "</" + e + ">");
        return this;
    }
}

