/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ChunkedArrayList;

class SnapshotDiffListingInfo {
    private final int maxEntries;
    private final INodeDirectory snapshotRoot;
    private final INodeDirectory snapshotDiffScopeDir;
    private final Snapshot from;
    private final Snapshot to;
    private byte[] lastPath = DFSUtilClient.EMPTY_BYTES;
    private int lastIndex = -1;
    private final List<SnapshotDiffReportListing.DiffReportListingEntry> modifiedList = new ChunkedArrayList();
    private final List<SnapshotDiffReportListing.DiffReportListingEntry> createdList = new ChunkedArrayList();
    private final List<SnapshotDiffReportListing.DiffReportListingEntry> deletedList = new ChunkedArrayList();

    SnapshotDiffListingInfo(INodeDirectory snapshotRootDir, INodeDirectory snapshotDiffScopeDir, Snapshot start, Snapshot end, int snapshotDiffReportLimit) {
        Preconditions.checkArgument((snapshotRootDir.isSnapshottable() && snapshotDiffScopeDir.isDescendantOfSnapshotRoot(snapshotRootDir) ? 1 : 0) != 0);
        this.snapshotRoot = snapshotRootDir;
        this.snapshotDiffScopeDir = snapshotDiffScopeDir;
        this.from = start;
        this.to = end;
        this.maxEntries = snapshotDiffReportLimit;
    }

    boolean addDirDiff(long dirId, byte[][] parent, DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        Snapshot laterSnapshot = this.getLater();
        if (this.lastIndex == -1) {
            if (this.getTotalEntries() < this.maxEntries) {
                this.modifiedList.add(new SnapshotDiffReportListing.DiffReportListingEntry(dirId, dirId, parent, true, null));
            } else {
                this.setLastPath(parent);
                this.setLastIndex(-1);
                return false;
            }
        }
        List clist = diff.getCreatedUnmodifiable();
        if (this.lastIndex == -1 || this.lastIndex < clist.size()) {
            ListIterator iterator;
            ListIterator listIterator = iterator = this.lastIndex != -1 ? clist.listIterator(this.lastIndex) : clist.listIterator();
            while (iterator.hasNext()) {
                if (this.getTotalEntries() < this.maxEntries) {
                    INode created = (INode)iterator.next();
                    byte[][] path = SnapshotDiffListingInfo.newPath(parent, created.getLocalNameBytes());
                    this.createdList.add(new SnapshotDiffReportListing.DiffReportListingEntry(dirId, created.getId(), path, created.isReference(), null));
                    continue;
                }
                this.setLastPath(parent);
                this.setLastIndex(iterator.nextIndex());
                return false;
            }
            this.setLastIndex(-1);
        }
        if (this.lastIndex == -1 || this.lastIndex >= clist.size()) {
            ListIterator iterator;
            List dlist = diff.getDeletedUnmodifiable();
            int size = clist.size();
            ListIterator listIterator = iterator = this.lastIndex != -1 ? dlist.listIterator(this.lastIndex - size) : dlist.listIterator();
            while (iterator.hasNext()) {
                if (this.getTotalEntries() < this.maxEntries) {
                    INode d = (INode)iterator.next();
                    byte[][] path = SnapshotDiffListingInfo.newPath(parent, d.getLocalNameBytes());
                    byte[][] target = this.findRenameTargetPath(d, laterSnapshot);
                    SnapshotDiffReportListing.DiffReportListingEntry e = target != null ? new SnapshotDiffReportListing.DiffReportListingEntry(dirId, d.getId(), path, true, target) : new SnapshotDiffReportListing.DiffReportListingEntry(dirId, d.getId(), path, false, null);
                    this.deletedList.add(e);
                    continue;
                }
                this.setLastPath(parent);
                this.setLastIndex(size + iterator.nextIndex());
                return false;
            }
            this.setLastIndex(-1);
        }
        return true;
    }

    private byte[][] findRenameTargetPath(INode deleted, Snapshot laterSnapshot) {
        if (deleted instanceof INodeReference.WithName) {
            return this.snapshotRoot.getDirectorySnapshottableFeature().findRenameTargetPath(this.snapshotDiffScopeDir, (INodeReference.WithName)deleted, Snapshot.getSnapshotId(laterSnapshot));
        }
        return null;
    }

    private static byte[][] newPath(byte[][] parent, byte[] name) {
        byte[][] fullPath = new byte[parent.length + 1][];
        System.arraycopy(parent, 0, fullPath, 0, parent.length);
        fullPath[fullPath.length - 1] = name;
        return fullPath;
    }

    Snapshot getEarlier() {
        return this.isFromEarlier() ? this.from : this.to;
    }

    Snapshot getLater() {
        return this.isFromEarlier() ? this.to : this.from;
    }

    public void setLastPath(byte[][] lastPath) {
        this.lastPath = DFSUtilClient.byteArray2bytes((byte[][])lastPath);
    }

    public void setLastIndex(int idx) {
        this.lastIndex = idx;
    }

    boolean addFileDiff(INodeFile file, byte[][] relativePath) {
        if (this.getTotalEntries() >= this.maxEntries) {
            this.setLastPath(relativePath);
            return false;
        }
        this.modifiedList.add(new SnapshotDiffReportListing.DiffReportListingEntry(file.getId(), file.getId(), relativePath, false, null));
        return true;
    }

    boolean isFromEarlier() {
        return Snapshot.ID_COMPARATOR.compare(this.from, this.to) < 0;
    }

    private int getTotalEntries() {
        return this.createdList.size() + this.modifiedList.size() + this.deletedList.size();
    }

    public SnapshotDiffReportListing generateReport() {
        return new SnapshotDiffReportListing(this.lastPath, this.modifiedList, this.createdList, this.deletedList, this.lastIndex, this.isFromEarlier());
    }
}

