/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

public class BlockPoolTokenSecretManager
extends SecretManager<BlockTokenIdentifier> {
    private final Map<String, BlockTokenSecretManager> map = new ConcurrentHashMap<String, BlockTokenSecretManager>();

    public void addBlockPool(String bpid, BlockTokenSecretManager secretMgr) {
        this.map.put(bpid, secretMgr);
    }

    @VisibleForTesting
    public BlockTokenSecretManager get(String bpid) {
        BlockTokenSecretManager secretMgr = this.map.get(bpid);
        if (secretMgr == null) {
            throw new IllegalArgumentException("Block pool " + bpid + " is not found");
        }
        return secretMgr;
    }

    public boolean isBlockPoolRegistered(String bpid) {
        return this.map.containsKey(bpid);
    }

    public BlockTokenIdentifier createIdentifier() {
        return new BlockTokenIdentifier();
    }

    public byte[] createPassword(BlockTokenIdentifier identifier) {
        return this.get(identifier.getBlockPoolId()).createPassword(identifier);
    }

    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return this.get(identifier.getBlockPoolId()).retrievePassword(identifier);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode, StorageType[] storageTypes, String[] storageIds) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(id, userId, block, mode, storageTypes, storageIds);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode, StorageType[] storageTypes) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(id, userId, block, mode, storageTypes);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(id, userId, block, mode);
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(token, userId, block, mode);
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, ExtendedBlock block, BlockTokenIdentifier.AccessMode mode, StorageType[] storageTypes, String[] storageIds) throws SecretManager.InvalidToken {
        this.get(block.getBlockPoolId()).checkAccess(token, userId, block, mode, storageTypes, storageIds);
    }

    public void addKeys(String bpid, ExportedBlockKeys exportedKeys) throws IOException {
        this.get(bpid).addKeys(exportedKeys);
    }

    public Token<BlockTokenIdentifier> generateToken(ExtendedBlock b, EnumSet<BlockTokenIdentifier.AccessMode> of, StorageType[] storageTypes, String[] storageIds) throws IOException {
        return this.get(b.getBlockPoolId()).generateToken(b, of, storageTypes, storageIds);
    }

    @VisibleForTesting
    public void clearAllKeysForTesting() {
        for (BlockTokenSecretManager btsm : this.map.values()) {
            btsm.clearAllKeysForTesting();
        }
    }

    public DataEncryptionKey generateDataEncryptionKey(String blockPoolId) {
        return this.get(blockPoolId).generateDataEncryptionKey();
    }

    public byte[] retrieveDataEncryptionKey(int keyId, String blockPoolId, byte[] nonce) throws IOException {
        return this.get(blockPoolId).retrieveDataEncryptionKey(keyId, nonce);
    }
}

