/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.staging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitter;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.impl.CommitContext;
import org.apache.hadoop.fs.s3a.commit.impl.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.commit.staging.ConflictResolution;
import org.apache.hadoop.fs.s3a.commit.staging.Paths;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagingCommitter
extends AbstractS3ACommitter {
    private static final Logger LOG = LoggerFactory.getLogger(StagingCommitter.class);
    public static final String NAME = "staging";
    private final Path constructorOutputPath = Objects.requireNonNull(this.getOutputPath(), "output path");
    private final long uploadPartSize;
    private final boolean uniqueFilenames;
    private final FileOutputCommitter wrappedCommitter;
    private ConflictResolution conflictResolution;
    private String s3KeyPrefix;
    private Path commitsDirectory;

    public StagingCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        Configuration conf = this.getConf();
        this.uploadPartSize = conf.getLongBytes("fs.s3a.multipart.size", 0x4000000L);
        this.uniqueFilenames = conf.getBoolean("fs.s3a.committer.staging.unique-filenames", true);
        this.setWorkPath(StagingCommitter.buildWorkPath((JobContext)context, this.getUUID()));
        this.wrappedCommitter = this.createWrappedCommitter((JobContext)context, conf);
        this.setOutputPath(this.constructorOutputPath);
        Path finalOutputPath = Objects.requireNonNull(this.getOutputPath(), "Output path cannot be null");
        S3AFileSystem fs = CommitUtils.getS3AFileSystem(finalOutputPath, context.getConfiguration(), false);
        this.s3KeyPrefix = fs.pathToKey(finalOutputPath);
        LOG.debug("{}: final output path is {}", (Object)this.getRole(), (Object)finalOutputPath);
        ConflictResolution mode = this.getConflictResolutionMode(this.getJobContext(), fs.getConf());
        LOG.debug("Conflict resolution mode: {}", (Object)mode);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected FileOutputCommitter createWrappedCommitter(JobContext context, Configuration conf) throws IOException {
        this.initFileOutputCommitterOptions(context);
        this.commitsDirectory = Paths.getMultipartUploadCommitsDirectory(conf, this.getUUID());
        return new FileOutputCommitter(this.commitsDirectory, context);
    }

    protected void initFileOutputCommitterOptions(JobContext context) {
        context.getConfiguration().setInt("mapreduce.fileoutputcommitter.algorithm.version", 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StagingCommitter{");
        sb.append(super.toString());
        sb.append(", commitsDirectory=").append(this.commitsDirectory);
        sb.append(", uniqueFilenames=").append(this.uniqueFilenames);
        sb.append(", conflictResolution=").append((Object)this.conflictResolution);
        sb.append(", uploadPartSize=").append(this.uploadPartSize);
        if (this.wrappedCommitter != null) {
            sb.append(", wrappedCommitter=").append(this.wrappedCommitter);
        }
        sb.append('}');
        return sb.toString();
    }

    private static Path buildWorkPath(JobContext context, String uuid) throws IOException {
        if (context instanceof TaskAttemptContext) {
            return StagingCommitter.taskAttemptWorkingPath((TaskAttemptContext)context, uuid);
        }
        return null;
    }

    public Boolean useUniqueFilenames() {
        return this.uniqueFilenames;
    }

    public FileSystem getJobAttemptFileSystem(JobContext context) throws IOException {
        Path p = this.getJobAttemptPath(context);
        return p.getFileSystem(context.getConfiguration());
    }

    public static Path getJobAttemptPath(JobContext context, Path out) {
        return StagingCommitter.getJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context), out);
    }

    private static Path getJobAttemptPath(int appAttemptId, Path out) {
        return new Path(StagingCommitter.getPendingJobAttemptsPath(out), String.valueOf(appAttemptId));
    }

    @Override
    protected Path getJobAttemptPath(int appAttemptId) {
        return new Path(this.getJobPath(), String.valueOf(appAttemptId));
    }

    @Override
    protected Path getJobPath() {
        return StagingCommitter.getPendingJobAttemptsPath(this.commitsDirectory);
    }

    private static Path getPendingTaskAttemptsPath(JobContext context, Path out) {
        return new Path(StagingCommitter.getJobAttemptPath(context, out), "_temporary");
    }

    public static Path getTaskAttemptPath(TaskAttemptContext context, Path out) {
        return new Path(StagingCommitter.getPendingTaskAttemptsPath((JobContext)context, out), String.valueOf(context.getTaskAttemptID()));
    }

    private static Path getPendingJobAttemptsPath(Path out) {
        Objects.requireNonNull(out, "Null 'out' path");
        return new Path(out, "_temporary");
    }

    public Path getCommittedTaskPath(TaskAttemptContext context) {
        return this.getCommittedTaskPath(CommitUtilsWithMR.getAppAttemptId((JobContext)context), context);
    }

    private static void validateContext(TaskAttemptContext context) {
        Objects.requireNonNull(context, "null context");
        Objects.requireNonNull(context.getTaskAttemptID(), "null task attempt ID");
        Objects.requireNonNull(context.getTaskAttemptID().getTaskID(), "null task ID");
        Objects.requireNonNull(context.getTaskAttemptID().getJobID(), "null job ID");
    }

    protected Path getCommittedTaskPath(int appAttemptId, TaskAttemptContext context) {
        StagingCommitter.validateContext(context);
        return new Path(this.getJobAttemptPath(appAttemptId), String.valueOf(context.getTaskAttemptID().getTaskID()));
    }

    @Override
    public Path getTempTaskAttemptPath(TaskAttemptContext context) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    protected List<LocatedFileStatus> getTaskOutput(TaskAttemptContext context) throws IOException {
        Path attemptPath = Objects.requireNonNull(this.getTaskAttemptPath(context), "No attemptPath path");
        LOG.debug("Scanning {} for files to commit", (Object)attemptPath);
        return RemoteIterators.toList(S3AUtils.listAndFilter(this.getTaskAttemptFilesystem(context), attemptPath, true, S3AUtils.HIDDEN_FILE_FILTER));
    }

    protected String getFinalKey(String relative, JobContext context) {
        if (this.uniqueFilenames) {
            return this.getS3KeyPrefix(context) + "/" + Paths.addUUID(relative, this.getUUID());
        }
        return this.getS3KeyPrefix(context) + "/" + relative;
    }

    protected final Path getFinalPath(String relative, JobContext context) throws IOException {
        return this.getDestS3AFS().keyToQualifiedPath(this.getFinalKey(relative, context));
    }

    @Override
    public Path getBaseTaskAttemptPath(TaskAttemptContext context) {
        return this.getWorkPath();
    }

    @Override
    public Path getJobAttemptPath(JobContext context) {
        return this.wrappedCommitter.getJobAttemptPath(context);
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        super.setupJob(context);
        this.wrappedCommitter.setupJob(context);
    }

    @Override
    protected AbstractS3ACommitter.ActiveCommit listPendingUploadsToCommit(CommitContext commitContext) throws IOException {
        return this.listPendingUploads(commitContext, false);
    }

    protected AbstractS3ACommitter.ActiveCommit listPendingUploadsToAbort(CommitContext commitContext) throws IOException {
        return this.listPendingUploads(commitContext, true);
    }

    protected AbstractS3ACommitter.ActiveCommit listPendingUploads(CommitContext commitContext, boolean suppressExceptions) throws IOException {
        block8: {
            AbstractS3ACommitter.ActiveCommit activeCommit;
            DurationInfo ignored = new DurationInfo(LOG, "Listing pending uploads", new Object[0]);
            try {
                Path wrappedJobAttemptPath = this.getJobAttemptPath(commitContext.getJobContext());
                FileSystem attemptFS = wrappedJobAttemptPath.getFileSystem(commitContext.getConf());
                activeCommit = AbstractS3ACommitter.ActiveCommit.fromStatusIterator(attemptFS, S3AUtils.listAndFilter(attemptFS, wrappedJobAttemptPath, false, S3AUtils.HIDDEN_FILE_FILTER));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    this.maybeIgnore(suppressExceptions, "Pending upload directory not found", e);
                    break block8;
                }
                catch (IOException e) {
                    this.maybeIgnore(suppressExceptions, "Listing pending uploads", e);
                }
            }
            ignored.close();
            return activeCommit;
        }
        return AbstractS3ACommitter.ActiveCommit.empty();
    }

    @Override
    public void cleanupStagingDirs() {
        Path workPath = this.getWorkPath();
        if (workPath != null) {
            LOG.debug("Cleaning up work path {}", (Object)workPath);
            Invoker.ignoreIOExceptions(LOG, "cleaning up", workPath.toString(), () -> S3AUtils.deleteQuietly(workPath.getFileSystem(this.getConf()), workPath, true));
        }
    }

    @Override
    protected void cleanup(CommitContext commitContext, boolean suppressExceptions) throws IOException {
        this.maybeIgnore(suppressExceptions, "Cleanup wrapped committer", () -> this.wrappedCommitter.cleanupJob(commitContext.getJobContext()));
        this.maybeIgnore(suppressExceptions, "Delete destination paths", () -> this.deleteDestinationPaths(commitContext.getJobContext()));
        super.cleanup(commitContext, suppressExceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void abortJobInternal(CommitContext commitContext, boolean suppressExceptions) throws IOException {
        String r = this.getRole();
        JobContext context = commitContext.getJobContext();
        boolean failed = false;
        try {
            try (DurationInfo d = new DurationInfo(LOG, "%s: aborting job in state %s ", new Object[]{r, CommitUtilsWithMR.jobIdString(context)});){
                AbstractS3ACommitter.ActiveCommit pending = this.listPendingUploadsToAbort(commitContext);
                this.abortPendingUploads(commitContext, pending, suppressExceptions, true);
            }
            super.abortJobInternal(commitContext, failed || suppressExceptions);
        }
        catch (FileNotFoundException e) {
            LOG.debug("No job directory to read uploads from");
            super.abortJobInternal(commitContext, failed || suppressExceptions);
        }
        catch (IOException e2) {
            failed = true;
            this.maybeIgnore(suppressExceptions, "aborting job", e2);
            super.abortJobInternal(commitContext, failed || suppressExceptions);
            {
                catch (Throwable throwable) {
                    super.abortJobInternal(commitContext, failed || suppressExceptions);
                    throw throwable;
                }
            }
        }
    }

    protected void deleteDestinationPaths(JobContext context) throws IOException {
        Path attemptPath = this.getJobAttemptPath(context);
        Invoker.ignoreIOExceptions(LOG, "Deleting Job attempt Path", attemptPath.toString(), () -> S3AUtils.deleteWithWarning(this.getJobAttemptFileSystem(context), attemptPath, true));
        S3AUtils.deleteWithWarning(this.getDestFS(), new Path(this.getOutputPath(), "_temporary"), true);
        this.deleteTaskWorkingPathQuietly(context);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
        Path taskAttemptPath = this.getTaskAttemptPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "%s: setup task attempt path %s ", new Object[]{this.getRole(), taskAttemptPath});){
            super.setupTask(context);
            this.wrappedCommitter.setupTask(context);
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        boolean bl;
        DurationInfo d = new DurationInfo(LOG, "%s: needsTaskCommit() Task %s", new Object[]{this.getRole(), context.getTaskAttemptID()});
        try {
            Path attemptPath = this.getTaskAttemptPath(context);
            FileSystem fs = this.getTaskAttemptFilesystem(context);
            FileStatus[] stats = fs.listStatus(attemptPath);
            LOG.debug("{} files to commit under {}", (Object)stats.length, (Object)attemptPath);
            bl = stats.length > 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    d.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                LOG.info("No files to commit");
                throw e;
            }
        }
        d.close();
        return bl;
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "%s: commit task %s", new Object[]{this.getRole(), context.getTaskAttemptID()});
             CommitContext commitContext = this.initiateTaskOperation((JobContext)context);){
            int count = this.commitTaskInternal(context, this.getTaskOutput(context), commitContext);
            LOG.info("{}: upload file count: {}", (Object)this.getRole(), (Object)count);
        }
        catch (IOException e) {
            LOG.error("{}: commit of task {} failed", new Object[]{this.getRole(), context.getTaskAttemptID(), e});
            this.getCommitOperations().taskCompleted(false);
            throw e;
        }
        this.getCommitOperations().taskCompleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int commitTaskInternal(TaskAttemptContext context, List<? extends FileStatus> taskOutput, CommitContext commitContext) throws IOException {
        ConcurrentLinkedQueue commits;
        FileSystem attemptFS;
        Path attemptPath;
        block19: {
            block15: {
                int commitCount;
                FileSystem commitsFS;
                Path commitsAttemptPath;
                block18: {
                    LOG.debug("{}: commitTaskInternal", (Object)this.getRole());
                    Configuration conf = context.getConfiguration();
                    attemptPath = this.getTaskAttemptPath(context);
                    attemptFS = this.getTaskAttemptFilesystem(context);
                    LOG.debug("{}: attempt path is {}", (Object)this.getRole(), (Object)attemptPath);
                    commitsAttemptPath = this.wrappedCommitter.getTaskAttemptPath(context);
                    commitsFS = commitsAttemptPath.getFileSystem(conf);
                    commitCount = taskOutput.size();
                    commits = new ConcurrentLinkedQueue();
                    LOG.info("{}: uploading from staging directory to S3 {}", (Object)this.getRole(), (Object)attemptPath);
                    LOG.info("{}: Saving pending data information to {}", (Object)this.getRole(), (Object)commitsAttemptPath);
                    if (!taskOutput.isEmpty()) break block18;
                    LOG.warn("{}: No files to commit", (Object)this.getRole());
                    break block19;
                }
                boolean threw = true;
                context.progress();
                PendingSet pendingCommits = new PendingSet(commitCount);
                pendingCommits.putExtraData("task.attempt.id", context.getTaskAttemptID().toString());
                try {
                    TaskPool.foreach(taskOutput).stopOnFailure().suppressExceptions(false).executeWith(commitContext.getOuterSubmitter()).run(stat -> {
                        Path path = stat.getPath();
                        File localFile = new File(path.toUri().getPath());
                        String relative = Paths.getRelativePath(attemptPath, path);
                        String partition = Paths.getPartition(relative);
                        String key = this.getFinalKey(relative, (JobContext)context);
                        Path destPath = this.getDestS3AFS().keyToQualifiedPath(key);
                        SinglePendingCommit commit = this.getCommitOperations().uploadFileToPendingCommit(localFile, destPath, partition, this.uploadPartSize, (Progressable)context);
                        LOG.debug("{}: adding pending commit {}", (Object)this.getRole(), (Object)commit);
                        commits.add(commit);
                    });
                    for (SinglePendingCommit commit : commits) {
                        pendingCommits.add(commit);
                    }
                    if (commitContext.isCollectIOStatistics()) {
                        pendingCommits.getIOStatistics().aggregate(commitContext.getIOStatisticsContext().getIOStatistics());
                    }
                    LOG.debug("Saving {} pending commit(s)) to file {}", (Object)pendingCommits.size(), (Object)commitsAttemptPath);
                    pendingCommits.save(commitsFS, commitsAttemptPath, commitContext.getPendingSetSerializer());
                    threw = false;
                    if (!threw) break block15;
                }
                catch (Throwable throwable) {
                    if (threw) {
                        LOG.error("{}: Exception during commit process, aborting {} commit(s)", (Object)this.getRole(), (Object)commits.size());
                        try (DurationInfo ignored = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{commits.size()});){
                            TaskPool.foreach(commits).suppressExceptions().executeWith(commitContext.getOuterSubmitter()).run(commitContext::abortSingleCommit);
                        }
                        this.deleteTaskAttemptPathQuietly(context);
                    }
                    throw throwable;
                }
                LOG.error("{}: Exception during commit process, aborting {} commit(s)", (Object)this.getRole(), (Object)commits.size());
                try (DurationInfo ignored = new DurationInfo(LOG, "Aborting %s uploads", new Object[]{commits.size()});){
                    TaskPool.foreach(commits).suppressExceptions().executeWith(commitContext.getOuterSubmitter()).run(commitContext::abortSingleCommit);
                }
                this.deleteTaskAttemptPathQuietly(context);
            }
            Paths.clearTempFolderInfo(context.getTaskAttemptID());
        }
        LOG.debug("Committing wrapped task");
        this.wrappedCommitter.commitTask(context);
        LOG.debug("Cleaning up attempt dir {}", (Object)attemptPath);
        attemptFS.delete(attemptPath, true);
        return commits.size();
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Abort task %s", new Object[]{context.getTaskAttemptID()});){
            this.deleteTaskAttemptPathQuietly(context);
            this.deleteTaskWorkingPathQuietly((JobContext)context);
            this.wrappedCommitter.abortTask(context);
        }
        catch (IOException e) {
            LOG.error("{}: exception when aborting task {}", new Object[]{this.getRole(), context.getTaskAttemptID(), e});
            throw e;
        }
    }

    private static Path taskAttemptWorkingPath(TaskAttemptContext context, String uuid) throws IOException {
        return StagingCommitter.getTaskAttemptPath(context, Paths.getLocalTaskAttemptTempDir(context.getConfiguration(), uuid, context.getTaskAttemptID()));
    }

    protected void deleteTaskWorkingPathQuietly(JobContext context) {
        Invoker.ignoreIOExceptions(LOG, "Delete working path", "", () -> {
            Path path = StagingCommitter.buildWorkPath(context, this.getUUID());
            if (path != null) {
                S3AUtils.deleteQuietly(path.getFileSystem(this.getConf()), path, true);
            }
        });
    }

    private String getS3KeyPrefix(JobContext context) {
        return this.s3KeyPrefix;
    }

    public final ConflictResolution getConflictResolutionMode(JobContext context, Configuration fsConf) {
        if (this.conflictResolution == null) {
            this.conflictResolution = ConflictResolution.valueOf(StagingCommitter.getConfictModeOption(context, fsConf, "append"));
        }
        return this.conflictResolution;
    }

    protected PathExistsException failDestinationExists(Path path, String description) {
        LOG.error("{}: Failing commit by job {} to write to existing output path {}.", new Object[]{description, this.getJobContext().getJobID(), path});
        try {
            RemoteIterator lf = this.getDestFS().listFiles(path, true);
            LOG.info("Partial Directory listing");
            for (int limit = 10; limit > 0 && lf.hasNext(); --limit) {
                LocatedFileStatus status = (LocatedFileStatus)lf.next();
                LOG.info("{}: {}", (Object)status.getPath(), (Object)(status.isDirectory() ? " dir" : "file size " + status.getLen() + " bytes"));
            }
            RemoteIterators.cleanupRemoteIterator((RemoteIterator)lf);
        }
        catch (IOException e) {
            LOG.info("Discarding exception raised when listing {}: " + e, (Object)path);
            LOG.debug("stack trace ", (Throwable)e);
        }
        return new PathExistsException(path.toString(), description + ": " + "Destination path exists and committer conflict resolution mode is \"fail\"");
    }

    public static String getConfictModeOption(JobContext context, Configuration fsConf, String defVal) {
        return CommitUtilsWithMR.getConfigurationOption(context, fsConf, "fs.s3a.committer.staging.conflict-mode", defVal).toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void preCommitJob(CommitContext commitContext, AbstractS3ACommitter.ActiveCommit pending) throws IOException {
        this.precommitCheckPendingFiles(commitContext, pending);
    }
}

