/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.fs.s3a.auth.STSClientFactory;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarshalledCredentialBinding {
    private static final Logger LOG = LoggerFactory.getLogger(MarshalledCredentialBinding.class);
    @VisibleForTesting
    public static final String NO_AWS_CREDENTIALS = "No AWS credentials";

    private MarshalledCredentialBinding() {
    }

    public static MarshalledCredentials fromSTSCredentials(Credentials credentials) {
        MarshalledCredentials marshalled = new MarshalledCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        Date date = credentials.getExpiration();
        marshalled.setExpiration(date != null ? date.getTime() : 0L);
        return marshalled;
    }

    public static MarshalledCredentials fromAWSCredentials(AWSSessionCredentials credentials) {
        return new MarshalledCredentials(credentials.getAWSAccessKeyId(), credentials.getAWSSecretKey(), credentials.getSessionToken());
    }

    public static MarshalledCredentials fromEnvironment(Map<String, String> env) {
        return new MarshalledCredentials(MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_ACCESS_KEY")), MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_SECRET_KEY")), MarshalledCredentialBinding.nullToEmptyString(env.get("AWS_SESSION_TOKEN")));
    }

    private static String nullToEmptyString(String src) {
        return src == null ? "" : src;
    }

    public static MarshalledCredentials fromFileSystem(URI uri, Configuration conf) throws IOException {
        String bucket = uri != null ? uri.getHost() : "";
        Configuration leanConf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
        return new MarshalledCredentials(S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.access.key"), S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.secret.key"), S3AUtils.lookupPassword(bucket, leanConf, "fs.s3a.session.token"));
    }

    public static AWSCredentials toAWSCredentials(MarshalledCredentials marshalled, MarshalledCredentials.CredentialTypeRequired typeRequired, String component) throws NoAuthWithAWSException, NoAwsCredentialsException {
        if (marshalled.isEmpty()) {
            throw new NoAwsCredentialsException(component, NO_AWS_CREDENTIALS);
        }
        if (!marshalled.isValid(typeRequired)) {
            throw new NoAuthWithAWSException(component + ":" + marshalled.buildInvalidCredentialsError(typeRequired));
        }
        String accessKey = marshalled.getAccessKey();
        String secretKey = marshalled.getSecretKey();
        if (marshalled.hasSessionToken()) {
            return new BasicSessionCredentials(accessKey, secretKey, marshalled.getSessionToken());
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public static MarshalledCredentials requestSessionCredentials(AWSCredentialsProvider parentCredentials, ClientConfiguration awsConf, String stsEndpoint, String stsRegion, int duration, Invoker invoker) throws IOException {
        MarshalledCredentials marshalledCredentials;
        block9: {
            AWSSecurityTokenService tokenService = (AWSSecurityTokenService)STSClientFactory.builder(parentCredentials, awsConf, stsEndpoint.isEmpty() ? null : stsEndpoint, stsRegion).build();
            STSClientFactory.STSClient stsClient = STSClientFactory.createClientConnection(tokenService, invoker);
            try {
                marshalledCredentials = MarshalledCredentialBinding.fromSTSCredentials(stsClient.requestSessionCredentials(duration, TimeUnit.SECONDS));
                if (stsClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stsClient != null) {
                        try {
                            stsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SdkClientException e) {
                    if (stsRegion.isEmpty()) {
                        LOG.error("Region must be provided when requesting session credentials.", (Throwable)e);
                    }
                    throw e;
                }
            }
            stsClient.close();
        }
        return marshalledCredentials;
    }
}

