/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AFileSystem;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class S3A
extends DelegateToFileSystem {
    public S3A(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, (FileSystem)new S3AFileSystem(), conf, "s3a", false);
    }

    public int getUriDefaultPort() {
        return super.getUriDefaultPort();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3A{");
        sb.append("URI =").append(this.fsImpl.getUri());
        sb.append("; fsImpl=").append(this.fsImpl);
        sb.append('}');
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        this.fsImpl.close();
        super.finalize();
    }
}

