/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.adaptor;

import csi.v0.Csi;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.CsiAdaptorPlugin;
import org.apache.hadoop.yarn.api.protocolrecords.GetPluginInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetPluginInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.csi.client.CsiClient;
import org.apache.hadoop.yarn.csi.client.CsiClientImpl;
import org.apache.hadoop.yarn.csi.translator.ProtoTranslatorFactory;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.csi.CsiConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsiAdaptorImpl
implements CsiAdaptorPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCsiAdaptorImpl.class);
    private String driverName;
    private CsiClient csiClient;

    public void init(String driverName, Configuration conf) throws YarnException {
        String driverEndpoint = CsiConfigUtils.getCsiDriverEndpoint((String)driverName, (Configuration)conf);
        LOG.info("This csi-adaptor is configured to contact with the csi-driver {} via gRPC endpoint: {}", (Object)driverName, (Object)driverEndpoint);
        this.csiClient = new CsiClientImpl(driverEndpoint);
        this.driverName = driverName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public GetPluginInfoResponse getPluginInfo(GetPluginInfoRequest request) throws YarnException, IOException {
        Csi.GetPluginInfoResponse response = this.csiClient.getPluginInfo();
        return ProtoTranslatorFactory.getTranslator(GetPluginInfoResponse.class, Csi.GetPluginInfoResponse.class).convertFrom(response);
    }

    public ValidateVolumeCapabilitiesResponse validateVolumeCapacity(ValidateVolumeCapabilitiesRequest request) throws YarnException, IOException {
        Csi.ValidateVolumeCapabilitiesRequest req = ProtoTranslatorFactory.getTranslator(ValidateVolumeCapabilitiesRequest.class, Csi.ValidateVolumeCapabilitiesRequest.class).convertTo(request);
        Csi.ValidateVolumeCapabilitiesResponse response = this.csiClient.validateVolumeCapabilities(req);
        return ProtoTranslatorFactory.getTranslator(ValidateVolumeCapabilitiesResponse.class, Csi.ValidateVolumeCapabilitiesResponse.class).convertFrom(response);
    }

    public NodePublishVolumeResponse nodePublishVolume(NodePublishVolumeRequest request) throws YarnException, IOException {
        LOG.debug("Received nodePublishVolume call, request: {}", (Object)request);
        Csi.NodePublishVolumeRequest req = ProtoTranslatorFactory.getTranslator(NodePublishVolumeRequest.class, Csi.NodePublishVolumeRequest.class).convertTo(request);
        LOG.debug("Translate to CSI proto message: {}", (Object)req);
        this.csiClient.nodePublishVolume(req);
        return NodePublishVolumeResponse.newInstance();
    }

    public NodeUnpublishVolumeResponse nodeUnpublishVolume(NodeUnpublishVolumeRequest request) throws YarnException, IOException {
        LOG.debug("Received nodeUnpublishVolume call, request: {}", (Object)request);
        Csi.NodeUnpublishVolumeRequest req = ProtoTranslatorFactory.getTranslator(NodeUnpublishVolumeRequest.class, Csi.NodeUnpublishVolumeRequest.class).convertTo(request);
        LOG.debug("Translate to CSI proto message: {}", (Object)req);
        this.csiClient.nodeUnpublishVolume(req);
        return NodeUnpublishVolumeResponse.newInstance();
    }
}

