/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.internal.operators.QueueWithResources;
import com.github.davidmoten.util.Preconditions;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import rx.functions.Func0;
import rx.plugins.RxJavaHooks;

class RollingSPSCQueue<T>
implements QueueWithResources<T> {
    private final Func0<QueueWithResources<T>> queueFactory;
    private final long maxSizeBytesPerQueue;
    private final long maxItemsPerQueue;
    private final Deque<QueueWithResources<T>> queues = new LinkedList<QueueWithResources<T>>();
    private long count;
    private boolean unsubscribed;

    RollingSPSCQueue(Func0<QueueWithResources<T>> queueFactory, long maxSizeBytesPerQueue, long maxItemsPerQueue) {
        Preconditions.checkNotNull(queueFactory);
        Preconditions.checkArgument(maxSizeBytesPerQueue > 0L, "maxSizeBytesPerQueue must be greater than zero");
        Preconditions.checkArgument(maxItemsPerQueue > 1L, "maxSizeBytesPerQueue must be greater than one");
        this.count = 0L;
        this.maxSizeBytesPerQueue = maxSizeBytesPerQueue;
        this.unsubscribed = false;
        this.queueFactory = queueFactory;
        this.maxItemsPerQueue = maxItemsPerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        if (this.unsubscribed) {
            return;
        }
        Deque<QueueWithResources<T>> deque = this.queues;
        synchronized (deque) {
            if (!this.unsubscribed) {
                this.unsubscribed = true;
                try {
                    for (QueueWithResources<T> q : this.queues) {
                        q.unsubscribe();
                    }
                    this.queues.clear();
                }
                catch (RuntimeException e) {
                    RxJavaHooks.onError((Throwable)e);
                    throw e;
                }
                catch (Error e) {
                    RxJavaHooks.onError((Throwable)e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsubscribed() {
        if (this.unsubscribed) {
            return true;
        }
        Deque<QueueWithResources<T>> deque = this.queues;
        synchronized (deque) {
            return this.unsubscribed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t) {
        if (this.unsubscribed) {
            return true;
        }
        ++this.count;
        if (this.createAnotherQueue()) {
            this.count = 1L;
            QueueWithResources q = (QueueWithResources)this.queueFactory.call();
            Deque<QueueWithResources<T>> deque = this.queues;
            synchronized (deque) {
                if (!this.unsubscribed) {
                    QueueWithResources<T> last = this.queues.peekLast();
                    if (last != null) {
                        last.freeResources();
                    }
                    this.queues.offerLast(q);
                    return q.offer(t);
                }
                return true;
            }
        }
        Deque<QueueWithResources<T>> deque = this.queues;
        synchronized (deque) {
            if (this.unsubscribed) {
                return true;
            }
            return this.queues.peekLast().offer(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createAnotherQueue() {
        if (this.count == 1L) {
            return true;
        }
        if (this.count == this.maxItemsPerQueue) {
            return true;
        }
        if (this.maxSizeBytesPerQueue != Long.MAX_VALUE) {
            Deque<QueueWithResources<T>> deque = this.queues;
            synchronized (deque) {
                if (this.unsubscribed) {
                    return true;
                }
                return this.queues.peekLast().resourcesSize() >= this.maxSizeBytesPerQueue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        if (this.unsubscribed) {
            return null;
        }
        while (true) {
            Deque<QueueWithResources<T>> deque = this.queues;
            synchronized (deque) {
                if (this.unsubscribed) {
                    return null;
                }
                QueueWithResources<T> first = this.queues.peekFirst();
                if (first == null) {
                    return null;
                }
                Object value = first.poll();
                if (value == null) {
                    if (first == this.queues.peekLast()) {
                        return null;
                    }
                    QueueWithResources<T> removed = this.queues.pollFirst();
                    if (removed != null) {
                        removed.unsubscribe();
                    }
                } else {
                    return (T)value;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.unsubscribed) {
            return true;
        }
        Deque<QueueWithResources<T>> deque = this.queues;
        synchronized (deque) {
            if (this.unsubscribed) {
                return true;
            }
            QueueWithResources<T> first = this.queues.peekFirst();
            if (first == null) {
                return true;
            }
            return this.queues.peekLast() == first && first.isEmpty();
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void freeResources() {
    }

    @Override
    public long resourcesSize() {
        throw new UnsupportedOperationException();
    }
}

