/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileListingEntry;
import org.apache.hadoop.tools.mapred.UniformSizeInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistCpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DistCpUtils.class);
    private static final ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.0");
        }
    };

    public static long getFileSize(Path path, Configuration configuration) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving file size for: " + path);
        }
        return path.getFileSystem(configuration).getFileStatus(path).getLen();
    }

    public static <T> void publish(Configuration configuration, String label, T value) {
        configuration.set(label, String.valueOf(value));
    }

    public static int getInt(Configuration configuration, String label) {
        int value = configuration.getInt(label, -1);
        assert (value >= 0) : "Couldn't find " + label;
        return value;
    }

    public static long getLong(Configuration configuration, String label) {
        long value = configuration.getLong(label, -1L);
        assert (value >= 0L) : "Couldn't find " + label;
        return value;
    }

    public static Class<? extends InputFormat> getStrategy(Configuration conf, DistCpContext context) {
        String confLabel = "distcp." + StringUtils.toLowerCase((String)context.getCopyStrategy()) + ".strategy.impl";
        return conf.getClass(confLabel, UniformSizeInputFormat.class, InputFormat.class);
    }

    public static String getRelativePath(FileListingEntry listingEntry) {
        String childPathString = "/" + (listingEntry.isSymlink() ? listingEntry.getSourceLinkPath().getName() : listingEntry.getSourceRealPath().getPath().getName());
        FileListingEntry listingEntryTmp = listingEntry;
        while ((listingEntryTmp = listingEntryTmp.getParent()) != null) {
            if (listingEntryTmp.isSymlink()) {
                if (listingEntryTmp.getSourceLinkPath().toUri().getPath().equals("/")) continue;
                childPathString = "/" + listingEntryTmp.getSourceLinkPath().getName() + childPathString;
                continue;
            }
            if (listingEntryTmp.getSourceRealPath().getPath().toUri().getPath().equals("/")) continue;
            childPathString = "/" + listingEntryTmp.getSourceRealPath().getPath().getName() + childPathString;
        }
        return childPathString;
    }

    public static String getRelativePath(Path sourceRootPath, Path childPath) {
        String childPathString = childPath.toUri().getPath();
        String sourceRootPathString = sourceRootPath.toUri().getPath();
        return sourceRootPathString.equals("/") ? childPathString : childPathString.substring(sourceRootPathString.length());
    }

    public static String getRelativePath(FileListingEntry root, FileListingEntry child) {
        String childPathString = "/" + (child.isSymlink() ? child.getSourceLinkPath().getName() : child.getSourceRealPath().getPath().getName());
        FileListingEntry childTmp = child;
        while (!(childTmp = childTmp.getParent()).getSourceRealPath().equals((Object)root.getSourceRealPath())) {
            if (childTmp.getSourceRealPath().getPath().toUri().getPath().equals("/")) continue;
            childPathString = "/" + childTmp.getSourceRealPath().getPath().getName() + childPathString;
        }
        return childPathString;
    }

    public static FileListingEntry pathToFileListingEntry(Path path, FileSystem fs) throws IOException {
        FileListingEntry topEntry = new FileListingEntry();
        topEntry.setSourceRealPath(fs.getFileStatus(path));
        Path tmpPath = path;
        FileListingEntry tmpEntry = new FileListingEntry();
        topEntry.setParent(tmpEntry);
        while (!(tmpPath = tmpPath.getParent()).toUri().getPath().equals("/")) {
            tmpEntry.setSourceRealPath(fs.getFileStatus(tmpPath));
            FileListingEntry tmpEntry2 = new FileListingEntry();
            tmpEntry.setParent(tmpEntry2);
            tmpEntry = tmpEntry2;
        }
        tmpEntry.setSourceRealPath(fs.getFileStatus(tmpPath));
        return topEntry;
    }

    public static String packAttributes(EnumSet<DistCpOptions.FileAttribute> attributes) {
        StringBuffer buffer = new StringBuffer(DistCpOptions.FileAttribute.values().length);
        int len = 0;
        for (DistCpOptions.FileAttribute attribute : attributes) {
            buffer.append(attribute.name().charAt(0));
            ++len;
        }
        return buffer.substring(0, len);
    }

    public static EnumSet<DistCpOptions.FileAttribute> unpackAttributes(String attributes) {
        EnumSet<DistCpOptions.FileAttribute> retValue = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        if (attributes != null) {
            for (int index = 0; index < attributes.length(); ++index) {
                retValue.add(DistCpOptions.FileAttribute.getAttribute(attributes.charAt(index)));
            }
        }
        return retValue;
    }

    public static void preserve(FileSystem targetFS, Path path, CopyListingFileStatus srcFileStatus, EnumSet<DistCpOptions.FileAttribute> attributes, boolean preserveRawXattrs) throws IOException {
        boolean preserveXAttrs;
        attributes.remove((Object)DistCpOptions.FileAttribute.BLOCKSIZE);
        attributes.remove((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE);
        FileStatus targetFileStatus = attributes.isEmpty() ? null : targetFS.getFileStatus(path);
        String group = targetFileStatus == null ? null : targetFileStatus.getGroup();
        String user = targetFileStatus == null ? null : targetFileStatus.getOwner();
        boolean chown = false;
        if (attributes.contains((Object)DistCpOptions.FileAttribute.ACL)) {
            List<AclEntry> targetAcl;
            List<AclEntry> srcAcl = srcFileStatus.getAclEntries();
            if (!srcAcl.equals(targetAcl = DistCpUtils.getAcl(targetFS, targetFileStatus))) {
                targetFS.removeAcl(path);
                targetFS.setAcl(path, srcAcl);
            }
            if (srcFileStatus.getPermission().getStickyBit() != targetFileStatus.getPermission().getStickyBit()) {
                targetFS.setPermission(path, srcFileStatus.getPermission());
            }
        } else if (attributes.contains((Object)DistCpOptions.FileAttribute.PERMISSION) && !srcFileStatus.getPermission().equals((Object)targetFileStatus.getPermission())) {
            targetFS.setPermission(path, srcFileStatus.getPermission());
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.EXP) && targetFS instanceof AbstractMapRFileSystem) {
            ((AbstractMapRFileSystem)targetFS).copyAce(srcFileStatus.getPath(), path);
        }
        if ((preserveXAttrs = attributes.contains((Object)DistCpOptions.FileAttribute.XATTR)) || preserveRawXattrs) {
            String rawNS = StringUtils.toLowerCase((String)XAttr.NameSpace.RAW.name());
            Map<String, byte[]> srcXAttrs = srcFileStatus.getXAttrs();
            Map<String, byte[]> targetXAttrs = DistCpUtils.getXAttrs(targetFS, path);
            if (srcXAttrs != null && !srcXAttrs.equals(targetXAttrs)) {
                for (Map.Entry<String, byte[]> entry : srcXAttrs.entrySet()) {
                    String xattrName = entry.getKey();
                    if (!xattrName.startsWith(rawNS) && !preserveXAttrs) continue;
                    targetFS.setXAttr(path, xattrName, entry.getValue());
                }
            }
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) && !targetFileStatus.isDirectory() && !targetFileStatus.isErasureCoded() && !srcFileStatus.isErasureCoded() && srcFileStatus.getReplication() != targetFileStatus.getReplication()) {
            targetFS.setReplication(path, srcFileStatus.getReplication());
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.GROUP) && !group.equals(srcFileStatus.getGroup())) {
            group = srcFileStatus.getGroup();
            chown = true;
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.USER) && !user.equals(srcFileStatus.getOwner())) {
            user = srcFileStatus.getOwner();
            chown = true;
        }
        if (chown) {
            targetFS.setOwner(path, user, group);
        }
        if (attributes.contains((Object)DistCpOptions.FileAttribute.TIMES)) {
            targetFS.setTimes(path, srcFileStatus.getModificationTime(), srcFileStatus.getAccessTime());
        }
    }

    public static List<AclEntry> getAcl(FileSystem fileSystem, FileStatus fileStatus) throws IOException {
        List entries = fileSystem.getAclStatus(fileStatus.getPath()).getEntries();
        return AclUtil.getAclFromPermAndEntries((FsPermission)fileStatus.getPermission(), (List)entries);
    }

    public static Map<String, byte[]> getXAttrs(FileSystem fileSystem, Path path) throws IOException {
        return fileSystem.getXAttrs(path);
    }

    public static void toCopyListingFileStatus(FileSystem fileSystem, FileListingEntry listingEntry, boolean preserveAcls, boolean preserveXAttrs, boolean preserveRawXAttrs, int blocksPerChunk) throws IOException {
        LinkedList<CopyListingFileStatus> copyListingFileStatus = new LinkedList<CopyListingFileStatus>();
        FileStatus fileStatus = listingEntry.getSourceRealPath();
        CopyListingFileStatus clfs = DistCpUtils.toCopyListingFileStatusHelper(fileSystem, fileStatus, preserveAcls, preserveXAttrs, preserveRawXAttrs, 0L, fileStatus.getLen());
        if (fileStatus.isSymlink()) {
            clfs.setSymlink(fileStatus.getSymlink());
        }
        if (listingEntry.getSourceLinkPath() != null) {
            clfs.setSourceLink(listingEntry.getSourceLinkPath());
        }
        long blockSize = fileStatus.getBlockSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("toCopyListing: " + fileStatus + " chunkSize: " + blocksPerChunk + " isDFS: " + (fileSystem instanceof DistributedFileSystem));
        }
        if (blocksPerChunk > 0 && !fileStatus.isDirectory() && fileStatus.getLen() > blockSize * (long)blocksPerChunk && !fileStatus.isSymlink()) {
            BlockLocation[] blockLocations = fileSystem.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            int numBlocks = blockLocations.length;
            long curPos = 0L;
            if (numBlocks <= blocksPerChunk) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  add file " + clfs);
                }
                copyListingFileStatus.add(clfs);
            } else {
                int i = 0;
                while (i < numBlocks) {
                    long curLength = 0L;
                    for (int j = 0; j < blocksPerChunk && i < numBlocks; ++j, ++i) {
                        curLength += blockLocations[i].getLength();
                    }
                    if (curLength <= 0L) continue;
                    CopyListingFileStatus clfs1 = new CopyListingFileStatus(clfs);
                    clfs1.setChunkOffset(curPos);
                    clfs1.setChunkLength(curLength);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  add file chunk " + clfs1);
                    }
                    copyListingFileStatus.add(clfs1);
                    curPos += curLength;
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  add file/dir " + clfs);
            }
            copyListingFileStatus.add(clfs);
        }
        listingEntry.setCopyListingFileStatus(copyListingFileStatus);
    }

    public static FileListingEntry getOriginalFileStatus(FileStatus sourceStatus, Configuration conf, boolean keepLinks, Map<String, Set<String>> loopLocator) {
        FileListingEntry entry = new FileListingEntry();
        try {
            entry.setKeepLink(keepLinks);
            if (sourceStatus.isSymlink() && !keepLinks && !DistCpUtils.isParentLoop(sourceStatus, conf) && !DistCpUtils.isLoop(sourceStatus, loopLocator)) {
                FileSystem symlinkSourceFS = sourceStatus.getSymlink().getFileSystem(conf);
                FileStatus symlinkDestination = symlinkSourceFS.getFileStatus(DistCpUtils.discloseRelativeSymlink(sourceStatus));
                String symlinkDestinationRawPath = symlinkDestination.getPath().toUri().getRawPath();
                Set realPathVisitCounter = loopLocator.computeIfAbsent(symlinkDestinationRawPath, k -> new HashSet());
                realPathVisitCounter.add(sourceStatus.getPath().toUri().getRawPath());
                entry.setSourceRealPath(symlinkDestination);
                entry.setSourceLinkPath(sourceStatus.getPath());
            } else {
                entry.setSourceRealPath(sourceStatus);
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        return entry;
    }

    public static boolean isParentLoop(FileStatus sourceStatus, Configuration conf) throws IOException {
        FileSystem symlinkSourceFS = sourceStatus.getSymlink().getFileSystem(conf);
        Path symlinkDestinationPath = DistCpUtils.discloseRelativeSymlink(sourceStatus);
        Path symlinkLocationPath = sourceStatus.getPath().getParent();
        String symlinkDestination = symlinkSourceFS.makeQualified(symlinkDestinationPath).toUri().getRawPath();
        String symlinkLocation = symlinkSourceFS.makeQualified(symlinkLocationPath).toUri().getRawPath();
        boolean isLoop = symlinkLocation.startsWith(symlinkDestination);
        if (isLoop) {
            LOG.warn("Symlink " + sourceStatus.getPath() + " leads to it's parent directory " + symlinkDestination + ". Copied as symlink");
        }
        return isLoop;
    }

    public static boolean isLoop(FileStatus src, Map<String, Set<String>> loopLocator) throws IOException {
        boolean isLoop;
        String symlinkDestination = DistCpUtils.discloseRelativeSymlink(src).toUri().getRawPath();
        String symlinkPath = src.getPath().toUri().getRawPath();
        Set<String> realPathVisitCounter = loopLocator.get(symlinkDestination);
        boolean bl = isLoop = realPathVisitCounter != null && realPathVisitCounter.contains(symlinkPath);
        if (isLoop) {
            LOG.warn("Symlink " + src.getPath() + " causes copy loop, copied as symlink. Link leads to " + symlinkDestination);
        }
        return isLoop;
    }

    public static Path discloseRelativeSymlink(FileStatus stat) throws IOException {
        return stat.getSymlink().toString().startsWith("/") ? stat.getSymlink() : new Path(stat.getPath().getParent(), stat.getSymlink());
    }

    public static CopyListingFileStatus toCopyListingFileStatusHelper(FileSystem fileSystem, FileStatus fileStatus, boolean preserveAcls, boolean preserveXAttrs, boolean preserveRawXAttrs, long chunkOffset, long chunkLength) throws IOException {
        CopyListingFileStatus copyListingFileStatus = new CopyListingFileStatus(fileStatus, chunkOffset, chunkLength);
        if (preserveAcls && fileStatus.hasAcl()) {
            List aclEntries = fileSystem.getAclStatus(fileStatus.getPath()).getEntries();
            copyListingFileStatus.setAclEntries(aclEntries);
        }
        if (preserveXAttrs || preserveRawXAttrs) {
            Map srcXAttrs = fileSystem.getXAttrs(fileStatus.getPath());
            if (preserveXAttrs && preserveRawXAttrs) {
                copyListingFileStatus.setXAttrs(srcXAttrs);
            } else {
                HashMap trgXAttrs = Maps.newHashMap();
                String rawNS = StringUtils.toLowerCase((String)XAttr.NameSpace.RAW.name());
                for (Map.Entry ent : srcXAttrs.entrySet()) {
                    String xattrName = (String)ent.getKey();
                    if (xattrName.startsWith(rawNS)) {
                        if (!preserveRawXAttrs) continue;
                        trgXAttrs.put(xattrName, (byte[])ent.getValue());
                        continue;
                    }
                    if (!preserveXAttrs) continue;
                    trgXAttrs.put(xattrName, (byte[])ent.getValue());
                }
                copyListingFileStatus.setXAttrs(trgXAttrs);
            }
        }
        return copyListingFileStatus;
    }

    public static Path sortListing(Configuration conf, Path sourceListing) throws IOException {
        Path output = new Path(sourceListing.toString() + "_sorted");
        DistCpUtils.sortListing(conf, sourceListing, output);
        return output;
    }

    public static void sortListing(Configuration conf, Path sourceListing, Path output) throws IOException {
        FileSystem fs = sourceListing.getFileSystem(conf);
        fs.makeQualified(output);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, Text.class, CopyListingFileStatus.class, conf);
        fs.delete(output, false);
        sorter.sort(sourceListing, output);
    }

    public static void checkFileSystemAclSupport(FileSystem fs) throws CopyListing.AclsNotSupportedException {
        try {
            fs.getAclStatus(new Path("/"));
        }
        catch (Exception e) {
            throw new CopyListing.AclsNotSupportedException("ACLs not supported for file system: " + fs.getUri());
        }
    }

    public static void checkFileSystemXAttrSupport(FileSystem fs) throws CopyListing.XAttrsNotSupportedException {
        try {
            fs.getXAttrs(new Path("/"));
        }
        catch (Exception e) {
            throw new CopyListing.XAttrsNotSupportedException("XAttrs not supported for file system: " + fs.getUri());
        }
    }

    public static DecimalFormat getFormatter() {
        return FORMATTER.get();
    }

    public static String getStringDescriptionFor(long nBytes) {
        double current;
        char[] units = new char[]{'B', 'K', 'M', 'G', 'T', 'P'};
        double prev = current = (double)nBytes;
        int index = 0;
        while (true) {
            double d;
            current /= 1024.0;
            if (!(d >= 1.0)) break;
            prev = current;
            ++index;
        }
        assert (index < units.length) : "Too large a number.";
        return DistCpUtils.getFormatter().format(prev) + units[index];
    }

    public static boolean checksumsAreEqual(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target, long sourceLen) throws IOException {
        FileChecksum targetChecksum = null;
        try {
            FileChecksum fileChecksum = sourceChecksum = sourceChecksum != null ? sourceChecksum : sourceFS.getFileChecksum(source, sourceLen);
            if (sourceChecksum != null) {
                targetChecksum = targetFS.getFileChecksum(target);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve checksum for " + source + " or " + target, (Throwable)e);
        }
        return sourceChecksum == null || targetChecksum == null || sourceChecksum.equals((Object)targetChecksum);
    }

    public static void compareFileLengthsAndChecksums(long srcLen, FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target, boolean skipCrc, long targetLen) throws IOException {
        if (srcLen != targetLen) {
            throw new IOException("Mismatch in length of source:" + source + " (" + srcLen + ") and target:" + target + " (" + targetLen + ")");
        }
        if (srcLen != 0L && !skipCrc && !DistCpUtils.checksumsAreEqual(sourceFS, source, sourceChecksum, targetFS, target, srcLen)) {
            String targetScheme;
            StringBuilder errorMessage = new StringBuilder("Checksum mismatch between ").append(source).append(" and ").append(target).append(".");
            boolean addSkipHint = false;
            String srcScheme = sourceFS.getScheme();
            if (!srcScheme.equals(targetScheme = targetFS.getScheme())) {
                errorMessage.append("Source and destination filesystems are of different types\n").append("Their checksum algorithms may be incompatible");
                addSkipHint = true;
            } else if (sourceFS.getFileStatus(source).getBlockSize() != targetFS.getFileStatus(target).getBlockSize()) {
                errorMessage.append(" Source and target differ in block-size.\n").append(" Use -pb to preserve block-sizes during copy.");
                addSkipHint = true;
            }
            if (addSkipHint) {
                errorMessage.append(" You can choose file-level checksum validation via -Ddfs.checksum.combine.mode=COMPOSITE_CRC when block-sizes or filesystems are different.").append(" Or you can skip checksum-checks altogether  with -skipcrccheck.\n").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)\n");
            }
            throw new IOException(errorMessage.toString());
        }
    }

    public static Path getSplitChunkPath(Path targetFile, CopyListingFileStatus srcFileStatus) {
        return new Path(targetFile.toString() + ".____distcpSplit____" + srcFileStatus.getChunkOffset() + "." + srcFileStatus.getChunkLength());
    }
}

