/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Artifact of an service component")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Artifact
implements Serializable {
    private static final long serialVersionUID = 3608929500111099035L;
    private String id = null;
    private TypeEnum type = TypeEnum.DOCKER;
    private String uri = null;

    public Artifact id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Artifact id. Examples are package location uri for tarball based services, image name for docker, etc.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Artifact type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact type, like docker, tarball, etc. (optional).")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Artifact uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact location to support multiple artifact stores (optional).")
    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.id, artifact.id) && Objects.equals((Object)this.type, (Object)artifact.type) && Objects.equals(this.uri, artifact.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.uri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Artifact {\n").append("    id: ").append(this.toIndentedString(this.id)).append("\n").append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n").append("    uri: ").append(this.toIndentedString(this.uri)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="artifact_type")
    @XmlEnum
    public static enum TypeEnum {
        DOCKER("DOCKER"),
        TARBALL("TARBALL"),
        SERVICE("SERVICE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

