/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RpcUtil {
    private static int xid = (int)(System.currentTimeMillis() / 1000L) << 12;
    public static final ChannelInboundHandlerAdapter STAGE_RPC_MESSAGE_PARSER = new RpcMessageParserStage();
    public static final ChannelInboundHandlerAdapter STAGE_RPC_TCP_RESPONSE = new RpcTcpResponseStage();
    public static final ChannelInboundHandlerAdapter STAGE_RPC_UDP_RESPONSE = new RpcUdpResponseStage();

    public static int getNewXid(String caller) {
        ++xid;
        return xid += caller.hashCode();
    }

    public static void sendRpcResponse(ChannelHandlerContext ctx, RpcResponse response) {
        ctx.fireChannelRead((Object)response);
    }

    public static ByteToMessageDecoder constructRpcFrameDecoder() {
        return new RpcFrameDecoder();
    }

    @ChannelHandler.Sharable
    private static final class RpcUdpResponseStage
    extends ChannelInboundHandlerAdapter {
        private RpcUdpResponseStage() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RpcResponse r = (RpcResponse)((Object)msg);
            ctx.channel().writeAndFlush((Object)r.data());
        }
    }

    @ChannelHandler.Sharable
    private static class RpcTcpResponseStage
    extends ChannelInboundHandlerAdapter {
        private RpcTcpResponseStage() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            RpcResponse r = (RpcResponse)((Object)msg);
            byte[] fragmentHeader = XDR.recordMark(r.data().readableBytes(), true);
            ByteBuf header = Unpooled.wrappedBuffer((byte[])fragmentHeader);
            ByteBuf d = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, r.data()});
            ctx.channel().writeAndFlush((Object)d);
        }
    }

    @ChannelHandler.Sharable
    static final class RpcMessageParserStage
    extends ChannelInboundHandlerAdapter {
        private static final Logger LOG = LoggerFactory.getLogger(RpcMessageParserStage.class);

        RpcMessageParserStage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            SocketAddress remoteAddress;
            ByteBuf buf;
            if (msg instanceof DatagramPacket) {
                DatagramPacket packet = (DatagramPacket)msg;
                buf = (ByteBuf)packet.content();
                remoteAddress = packet.sender();
            } else {
                buf = (ByteBuf)msg;
                remoteAddress = ctx.channel().remoteAddress();
            }
            ByteBuffer b = buf.nioBuffer().asReadOnlyBuffer();
            XDR in = new XDR(b, XDR.State.READING);
            RpcInfo info = null;
            try {
                RpcCall callHeader = RpcCall.read(in);
                ByteBuf dataBuffer = buf.slice(b.position(), b.remaining());
                info = new RpcInfo(callHeader, dataBuffer, ctx, ctx.channel(), remoteAddress);
            }
            catch (Exception exc) {
                LOG.info("Malformed RPC request from " + remoteAddress);
            }
            finally {
                if (info == null) {
                    buf.release();
                }
            }
            if (info != null) {
                ctx.fireChannelRead((Object)info);
            }
        }
    }

    static class RpcFrameDecoder
    extends ByteToMessageDecoder {
        public static final Logger LOG = LoggerFactory.getLogger(RpcFrameDecoder.class);
        private volatile boolean isLast;

        RpcFrameDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) {
            if (buf.readableBytes() < 4) {
                return;
            }
            buf.markReaderIndex();
            byte[] fragmentHeader = new byte[4];
            buf.readBytes(fragmentHeader);
            int length = XDR.fragmentSize(fragmentHeader);
            this.isLast = XDR.isLastFragment(fragmentHeader);
            if (buf.readableBytes() < length) {
                buf.resetReaderIndex();
                return;
            }
            ByteBuf newFragment = buf.readSlice(length);
            newFragment.retain();
            out.add(newFragment);
        }

        @VisibleForTesting
        public boolean isLast() {
            return this.isLast;
        }
    }
}

