/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.Cookie;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.ProxyUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpPrincipal;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class AmIpFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AmIpFilter.class);
    @Deprecated
    public static final String PROXY_HOST = "PROXY_HOST";
    @Deprecated
    public static final String PROXY_URI_BASE = "PROXY_URI_BASE";
    public static final String PROXY_HOSTS = "PROXY_HOSTS";
    public static final String PROXY_HOSTS_DELIMITER = ",";
    public static final String PROXY_URI_BASES = "PROXY_URI_BASES";
    public static final String PROXY_URI_BASES_DELIMITER = ",";
    private static final String PROXY_PATH = "/proxy";
    private static long updateInterval = TimeUnit.MINUTES.toMillis(5L);
    private List<String> proxyHosts = new ArrayList<String>();
    private Set<String> proxyAddresses = null;
    private long lastUpdate;
    @VisibleForTesting
    Map<String, String> proxyUriBases;
    String[] rmUrls = null;

    public void init(FilterConfig conf) throws ServletException {
        if (conf.getInitParameter(PROXY_HOST) != null && conf.getInitParameter(PROXY_URI_BASE) != null) {
            this.proxyHosts = new ArrayList<String>(1);
            this.proxyHosts.add(conf.getInitParameter(PROXY_HOST));
            this.proxyUriBases = new HashMap<String, String>(1);
            this.proxyUriBases.put("dummy", conf.getInitParameter(PROXY_URI_BASE));
        } else {
            this.proxyHosts = new ArrayList<String>(Arrays.asList(conf.getInitParameter(PROXY_HOSTS).split(",")));
            String[] proxyUriBasesArr = conf.getInitParameter(PROXY_URI_BASES).split(",");
            this.proxyUriBases = new HashMap<String, String>(proxyUriBasesArr.length);
            for (String proxyUriBase : proxyUriBasesArr) {
                try {
                    URL url = new URL(proxyUriBase);
                    this.proxyUriBases.put(url.getHost() + ":" + url.getPort(), proxyUriBase);
                }
                catch (MalformedURLException e) {
                    LOG.warn("{} does not appear to be a valid URL", (Object)proxyUriBase, (Object)e);
                }
            }
        }
        if (conf.getInitParameter("RM_HA_URLS") != null) {
            this.rmUrls = conf.getInitParameter("RM_HA_URLS").split(",");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getProxyAddresses() throws ServletException {
        long now = Time.monotonicNow();
        AmIpFilter amIpFilter = this;
        synchronized (amIpFilter) {
            if (this.proxyAddresses == null || this.lastUpdate + updateInterval <= now) {
                this.proxyAddresses = new HashSet<String>();
                for (String proxyHost : this.proxyHosts) {
                    try {
                        for (InetAddress add : InetAddress.getAllByName(proxyHost)) {
                            LOG.debug("proxy address is: {}", (Object)add.getHostAddress());
                            this.proxyAddresses.add(add.getHostAddress());
                        }
                        this.lastUpdate = now;
                    }
                    catch (UnknownHostException e) {
                        LOG.warn("Could not locate {} - skipping", (Object)proxyHost, (Object)e);
                    }
                }
                if (this.proxyAddresses.isEmpty()) {
                    throw new ServletException("Could not locate any of the proxy hosts");
                }
            }
            return this.proxyAddresses;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        ProxyUtils.rejectNonHttpRequests(req);
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        LOG.debug("Remote address for request is: {}", (Object)httpReq.getRemoteAddr());
        if (!this.getProxyAddresses().contains(httpReq.getRemoteAddr())) {
            String queryString;
            StringBuilder redirect = new StringBuilder(this.findRedirectUrl());
            redirect.append(httpReq.getRequestURI());
            int insertPoint = redirect.indexOf(PROXY_PATH);
            if (insertPoint >= 0) {
                redirect.insert(insertPoint += PROXY_PATH.length(), "/redirect");
            }
            if ((queryString = httpReq.getQueryString()) != null && !queryString.isEmpty()) {
                redirect.append("?");
                redirect.append(queryString);
            }
            ProxyUtils.sendRedirect(httpReq, httpResp, redirect.toString());
        } else {
            String user = null;
            if (httpReq.getCookies() != null) {
                for (Cookie c : httpReq.getCookies()) {
                    if (!"proxy-user".equals(c.getName())) continue;
                    user = c.getValue();
                    break;
                }
            }
            if (user == null) {
                LOG.debug("Could not find {} cookie, so user will not be set", (Object)"proxy-user");
                chain.doFilter(req, resp);
            } else {
                AmIpPrincipal principal = new AmIpPrincipal(user);
                AmIpServletRequestWrapper requestWrapper = new AmIpServletRequestWrapper(httpReq, principal);
                chain.doFilter((ServletRequest)requestWrapper, resp);
            }
        }
    }

    @VisibleForTesting
    public String findRedirectUrl() throws ServletException {
        String addr = null;
        YarnConfiguration conf = new YarnConfiguration();
        if (HAUtil.isCustomRMHAEnabled((Configuration)conf)) {
            String currentRMAddress = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)conf);
            String applicationWebProxy = System.getenv("APPLICATION_WEB_PROXY_BASE");
            if (applicationWebProxy == null || applicationWebProxy.isEmpty()) {
                for (Map.Entry<String, String> entry : this.proxyUriBases.entrySet()) {
                    String address = entry.getValue();
                    if (!address.contains("/proxy/application")) continue;
                    applicationWebProxy = address.substring(address.indexOf("/proxy/application"), address.length());
                    break;
                }
                if (applicationWebProxy == null) {
                    applicationWebProxy = "";
                }
            }
            addr = currentRMAddress.concat(applicationWebProxy);
            if (!this.isValidUrl(currentRMAddress)) {
                throw new ServletException("Could not determine the proxy server for redirection. Check your network configuration");
            }
            try {
                URL url = new URL(currentRMAddress);
                this.proxyUriBases.put(url.getHost() + ":" + url.getPort(), addr);
                this.proxyHosts.add(url.getHost());
            }
            catch (MalformedURLException e) {
                LOG.warn("{} does not appear to be a valid URL", (Object)currentRMAddress, (Object)e);
            }
        } else if (this.proxyUriBases.size() == 1) {
            addr = this.proxyUriBases.values().iterator().next();
        } else if (this.rmUrls != null) {
            for (String url : this.rmUrls) {
                String host = this.proxyUriBases.get(url);
                if (!this.isValidUrl(host)) continue;
                addr = host;
                break;
            }
        }
        if (addr == null) {
            throw new ServletException("Could not determine the proxy server for redirection");
        }
        return addr;
    }

    @VisibleForTesting
    public boolean isValidUrl(String url) {
        boolean isValid = false;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.connect();
            boolean bl = isValid = conn.getResponseCode() == 200;
            if (!isValid && UserGroupInformation.isSecurityEnabled()) {
                isValid = conn.getResponseCode() == 401 || conn.getResponseCode() == 403;
                return isValid;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to connect to " + url + ": " + e.toString());
        }
        return isValid;
    }

    @VisibleForTesting
    protected static void setUpdateInterval(long updateInterval) {
        AmIpFilter.updateInterval = updateInterval;
    }
}

