/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class IOStatisticsSnapshot
implements IOStatistics,
Serializable,
IOStatisticsAggregator {
    private static final long serialVersionUID = -1762522703841538084L;
    private static final Class[] DESERIALIZATION_CLASSES = new Class[]{IOStatisticsSnapshot.class, TreeMap.class, Long.class, MeanStatistic.class};
    @JsonProperty
    private transient Map<String, Long> counters;
    @JsonProperty
    private transient Map<String, Long> gauges;
    @JsonProperty
    private transient Map<String, Long> minimums;
    @JsonProperty
    private transient Map<String, Long> maximums;
    @JsonProperty(value="meanstatistics")
    private transient Map<String, MeanStatistic> meanStatistics;

    public IOStatisticsSnapshot() {
        this.createMaps();
    }

    public IOStatisticsSnapshot(IOStatistics source) {
        if (source != null) {
            this.snapshot(source);
        } else {
            this.createMaps();
        }
    }

    private synchronized void createMaps() {
        this.counters = new ConcurrentHashMap<String, Long>();
        this.gauges = new ConcurrentHashMap<String, Long>();
        this.minimums = new ConcurrentHashMap<String, Long>();
        this.maximums = new ConcurrentHashMap<String, Long>();
        this.meanStatistics = new ConcurrentHashMap<String, MeanStatistic>();
    }

    public synchronized void clear() {
        this.counters.clear();
        this.gauges.clear();
        this.minimums.clear();
        this.maximums.clear();
        this.meanStatistics.clear();
    }

    public synchronized void snapshot(IOStatistics source) {
        Preconditions.checkNotNull((Object)source);
        this.counters = IOStatisticsBinding.snapshotMap(source.counters());
        this.gauges = IOStatisticsBinding.snapshotMap(source.gauges());
        this.minimums = IOStatisticsBinding.snapshotMap(source.minimums());
        this.maximums = IOStatisticsBinding.snapshotMap(source.maximums());
        this.meanStatistics = IOStatisticsBinding.snapshotMap(source.meanStatistics(), MeanStatistic::copy);
    }

    @Override
    public synchronized boolean aggregate(@Nullable IOStatistics source) {
        if (source == null) {
            return false;
        }
        IOStatisticsBinding.aggregateMaps(this.counters, source.counters(), IOStatisticsBinding::aggregateCounters, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.gauges, source.gauges(), IOStatisticsBinding::aggregateGauges, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.minimums, source.minimums(), IOStatisticsBinding::aggregateMinimums, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.maximums, source.maximums(), IOStatisticsBinding::aggregateMaximums, IOStatisticsBinding::passthroughFn);
        IOStatisticsBinding.aggregateMaps(this.meanStatistics, source.meanStatistics(), IOStatisticsBinding::aggregateMeanStatistics, MeanStatistic::copy);
        return true;
    }

    @Override
    public synchronized Map<String, Long> counters() {
        return this.counters;
    }

    @Override
    public synchronized Map<String, Long> gauges() {
        return this.gauges;
    }

    @Override
    public synchronized Map<String, Long> minimums() {
        return this.minimums;
    }

    @Override
    public synchronized Map<String, Long> maximums() {
        return this.maximums;
    }

    @Override
    public synchronized Map<String, MeanStatistic> meanStatistics() {
        return this.meanStatistics;
    }

    public String toString() {
        return IOStatisticsLogging.ioStatisticsToString(this);
    }

    public static JsonSerialization<IOStatisticsSnapshot> serializer() {
        return new JsonSerialization<IOStatisticsSnapshot>(IOStatisticsSnapshot.class, false, true);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(new TreeMap<String, Long>(this.counters));
        s.writeObject(new TreeMap<String, Long>(this.gauges));
        s.writeObject(new TreeMap<String, Long>(this.minimums));
        s.writeObject(new TreeMap<String, Long>(this.maximums));
        s.writeObject(new TreeMap<String, MeanStatistic>(this.meanStatistics));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.counters = new ConcurrentHashMap<String, Long>((TreeMap)s.readObject());
        this.gauges = new ConcurrentHashMap<String, Long>((TreeMap)s.readObject());
        this.minimums = new ConcurrentHashMap<String, Long>((TreeMap)s.readObject());
        this.maximums = new ConcurrentHashMap<String, Long>((TreeMap)s.readObject());
        this.meanStatistics = new ConcurrentHashMap<String, MeanStatistic>((TreeMap)s.readObject());
    }

    public static List<Class> requiredSerializationClasses() {
        return Arrays.stream(DESERIALIZATION_CLASSES).collect(Collectors.toList());
    }
}

