/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowAccess;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.mapr.AbstractHTable;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    protected ClusterConnection connection;
    private final TableName tableName;
    private AbstractHTable maprTable_ = null;
    private volatile Configuration conf;
    @VisibleForTesting
    final ConcurrentLinkedQueue<Mutation> writeAsyncBuffer = new ConcurrentLinkedQueue();
    @VisibleForTesting
    AtomicLong currentWriteBufferSize = new AtomicLong(0L);
    @VisibleForTesting
    AtomicInteger undealtMutationCount = new AtomicInteger(0);
    private long writeBufferSize;
    private final int maxKeyValueSize;
    private boolean closed = false;
    private final boolean cleanupPoolOnClose_;
    private final ExecutorService pool;
    private int writeRpcTimeout;
    private int operationTimeout;
    @VisibleForTesting
    protected AsyncProcess ap = null;

    public BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        this(conn, rpcCallerFactory, rpcFactory, params, true);
    }

    public BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params, boolean cleanupPoolOnClose) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        if (this.tableName == null) {
            LOG.warn((Object)"BufferedMutator is constructed with tableName as null");
        }
        this.connection = conn;
        this.conf = this.connection.getConfiguration();
        if (this.conf == null) {
            LOG.warn((Object)"BufferedMutator is constructed with conf as null");
        }
        this.cleanupPoolOnClose_ = cleanupPoolOnClose;
        this.pool = params.getPool();
        this.listener = params.getListener();
        if (this.listener != null && this.pool == null) {
            throw new IllegalArgumentException("BufferedMutator for " + this.tableName + " has a listener, but does not have a pool");
        }
        ConnectionConfiguration connConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : connConf.getWriteBufferSize();
        int n = this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : connConf.getMaxKeyValueSize();
        if (!BaseTableMappingRules.isInHBaseService()) {
            if (this.connection instanceof AbstractMapRClusterConnection) {
                this.maprTable_ = AbstractMapRClusterConnection.createAbstractMapRTable(this.connection.getConfiguration(), this.tableName, this, this.listener, this.pool);
                if (this.maprTable_ == null) {
                    throw new IllegalArgumentException("Could not find table " + this.tableName + " through MapRClusterConnection.");
                }
            } else if (this.connection instanceof ConnectionManager.HConnectionImplementation) {
                BaseTableMappingRules tableMappingRule = null;
                try {
                    tableMappingRule = TableMappingRulesFactory.create(this.connection.getConfiguration());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not get tableMappingRule for table " + this.tableName + " through HConnection. Reason:" + e.getStackTrace());
                }
                if (tableMappingRule != null && tableMappingRule.isMapRTable(this.tableName)) {
                    this.maprTable_ = HTable.createMapRTable(this.connection.getConfiguration(), this.tableName, this, this.listener, this.pool);
                }
            } else {
                LOG.warn((Object)"Unknown connection type!");
            }
        }
        this.writeRpcTimeout = connConf.getWriteRpcTimeout();
        this.operationTimeout = connConf.getOperationTimeout();
        if (this.maprTable_ == null) {
            this.ap = new AsyncProcess(this.connection, this.conf, this.pool, rpcCallerFactory, true, rpcFactory, this.writeRpcTimeout);
        } else {
            this.maprTable_.setAutoFlush(false);
        }
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Arrays.asList(m));
    }

    @Override
    public void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        if (this.isMapRTable()) {
            for (Mutation mutation : ms) {
                try {
                    if (mutation instanceof Put) {
                        this.maprTable_.put((Put)mutation);
                    }
                    if (!(mutation instanceof Delete)) continue;
                    this.maprTable_.delete((Delete)mutation);
                }
                catch (IOException e) {
                    throw new InterruptedIOException("Cannot put to this mapr table. Reason: " + e);
                }
            }
            return;
        }
        long toAddSize = 0L;
        int toAddCount = 0;
        for (Mutation mutation : ms) {
            if (mutation instanceof Put) {
                this.validatePut((Put)mutation);
            }
            toAddSize += mutation.heapSize();
            ++toAddCount;
        }
        if (this.ap.hasError()) {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
            this.backgroundFlushCommits(true);
        } else {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
        }
        while (this.undealtMutationCount.get() != 0 && this.currentWriteBufferSize.get() > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    @Override
    public synchronized void close() throws IOException {
        block9: {
            try {
                boolean terminated;
                if (this.closed) {
                    return;
                }
                this.backgroundFlushCommits(true);
                if (this.isMapRTable()) {
                    this.maprTable_.close();
                    this.maprTable_ = null;
                }
                if (!this.cleanupPoolOnClose_) break block9;
                this.pool.shutdown();
                int loopCnt = 0;
                do {
                    terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                    if (++loopCnt < 10) continue;
                    LOG.warn((Object)"close() failed to terminate pool after 10 minutes. Abandoning pool.");
                    break;
                } while (!terminated);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"waitForTermination interrupted");
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        QueueRowAccess taker;
        if (this.isMapRTable()) {
            this.maprTable_.flushCommits();
            return;
        }
        if (!synchronous && this.writeAsyncBuffer.isEmpty()) {
            return;
        }
        if (!synchronous) {
            taker = this.createQueueRowAccess();
            try {
                this.ap.submit(this.tableName, taker, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug((Object)(this.tableName + ": One or more of the operations have failed - waiting for all operation in progress to finish (successfully or not)"));
                }
            }
            finally {
                if (taker != null) {
                    taker.close();
                }
            }
        }
        if (synchronous || this.ap.hasError()) {
            while (true) {
                taker = this.createQueueRowAccess();
                try {
                    if (taker.isEmpty()) break;
                    this.ap.submit(this.tableName, taker, true, null, false);
                    continue;
                }
                finally {
                    if (taker == null) continue;
                    taker.close();
                    continue;
                }
                break;
            }
            RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName.getNameAsString());
            if (error != null) {
                if (this.listener == null) {
                    throw error;
                }
                this.listener.onException(error, this);
            }
        }
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        if (this.isMapRTable()) {
            try {
                this.maprTable_.setWriteBufferSize(writeBufferSize);
            }
            catch (IOException e) {
                throw new InterruptedIOException("Cannot set write buffer size for this mapr table. Reason:" + e);
            }
            return;
        }
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize.get() > writeBufferSize) {
            this.flush();
        }
    }

    private boolean isMapRTable() {
        return this.maprTable_ != null;
    }

    @Override
    public long getWriteBufferSize() {
        if (this.isMapRTable()) {
            return this.maprTable_.getWriteBufferSize();
        }
        return this.writeBufferSize;
    }

    public void setRpcTimeout(int writeRpcTimeout) {
        this.writeRpcTimeout = writeRpcTimeout;
        if (!this.isMapRTable()) {
            this.ap.setRpcTimeout(writeRpcTimeout);
        }
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        if (!this.isMapRTable()) {
            this.ap.setOperationTimeout(operationTimeout);
        }
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        if (this.isMapRTable()) {
            return null;
        }
        return Arrays.asList(this.writeAsyncBuffer.toArray(new Row[0]));
    }

    @VisibleForTesting
    QueueRowAccess createQueueRowAccess() {
        return new QueueRowAccess();
    }

    @VisibleForTesting
    class QueueRowAccess
    implements RowAccess<Row>,
    Closeable {
        private int remainder;
        private Mutation last;

        QueueRowAccess() {
            this.remainder = BufferedMutatorImpl.this.undealtMutationCount.getAndSet(0);
            this.last = null;
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                private int countDown;
                {
                    this.countDown = QueueRowAccess.this.remainder;
                }

                @Override
                public boolean hasNext() {
                    return this.countDown > 0;
                }

                @Override
                public Row next() {
                    QueueRowAccess.this.restoreLastMutation();
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    QueueRowAccess.this.last = BufferedMutatorImpl.this.writeAsyncBuffer.poll();
                    if (QueueRowAccess.this.last == null) {
                        throw new NoSuchElementException();
                    }
                    BufferedMutatorImpl.this.currentWriteBufferSize.addAndGet(-QueueRowAccess.this.last.heapSize());
                    --this.countDown;
                    return QueueRowAccess.this.last;
                }

                @Override
                public void remove() {
                    if (QueueRowAccess.this.last == null) {
                        throw new IllegalStateException();
                    }
                    --QueueRowAccess.this.remainder;
                    QueueRowAccess.this.last = null;
                }
            };
        }

        private void restoreLastMutation() {
            if (this.last != null) {
                BufferedMutatorImpl.this.writeAsyncBuffer.add(this.last);
                BufferedMutatorImpl.this.currentWriteBufferSize.addAndGet(this.last.heapSize());
                this.last = null;
            }
        }

        @Override
        public int size() {
            return this.remainder;
        }

        @Override
        public boolean isEmpty() {
            return this.remainder <= 0;
        }

        @Override
        public void close() {
            this.restoreLastMutation();
            if (this.remainder > 0) {
                BufferedMutatorImpl.this.undealtMutationCount.addAndGet(this.remainder);
                this.remainder = 0;
            }
        }
    }
}

