/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;

public class QueueCapacities {
    private static final String NL = "";
    private static final float LABEL_DOESNT_EXIST_CAP = 0.0f;
    private Map<String, Capacities> capacitiesMap;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private final boolean isRoot;

    public QueueCapacities(boolean isRoot) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.capacitiesMap = new HashMap<String, Capacities>();
        this.isRoot = isRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float _get(String label, CapacityType type) {
        this.readLock.lock();
        try {
            Capacities cap = this.capacitiesMap.get(label);
            if (null == cap) {
                float f = 0.0f;
                return f;
            }
            float f = cap.capacitiesArr[type.idx];
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _set(String label, CapacityType type, float value) {
        this.writeLock.lock();
        try {
            Capacities cap = this.capacitiesMap.get(label);
            if (null == cap) {
                cap = new Capacities();
                this.capacitiesMap.put(label, cap);
            }
            ((Capacities)cap).capacitiesArr[((CapacityType)type).idx] = value;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public float getUsedCapacity() {
        return this._get(NL, CapacityType.USED_CAP);
    }

    public float getUsedCapacity(String label) {
        return this._get(label, CapacityType.USED_CAP);
    }

    public void setUsedCapacity(float value) {
        this._set(NL, CapacityType.USED_CAP, value);
    }

    public void setUsedCapacity(String label, float value) {
        this._set(label, CapacityType.USED_CAP, value);
    }

    public float getAbsoluteUsedCapacity() {
        return this._get(NL, CapacityType.ABS_USED_CAP);
    }

    public float getAbsoluteUsedCapacity(String label) {
        return this._get(label, CapacityType.ABS_USED_CAP);
    }

    public void setAbsoluteUsedCapacity(float value) {
        this._set(NL, CapacityType.ABS_USED_CAP, value);
    }

    public void setAbsoluteUsedCapacity(String label, float value) {
        this._set(label, CapacityType.ABS_USED_CAP, value);
    }

    public float getCapacity() {
        return this._get(NL, CapacityType.CAP);
    }

    public float getCapacity(String label) {
        if (StringUtils.equals((CharSequence)label, (CharSequence)NL) && this.isRoot) {
            return 1.0f;
        }
        return this._get(label, CapacityType.CAP);
    }

    public void setCapacity(float value) {
        this._set(NL, CapacityType.CAP, value);
    }

    public void setCapacity(String label, float value) {
        this._set(label, CapacityType.CAP, value);
    }

    public float getAbsoluteCapacity() {
        return this._get(NL, CapacityType.ABS_CAP);
    }

    public float getAbsoluteCapacity(String label) {
        if (StringUtils.equals((CharSequence)label, (CharSequence)NL) && this.isRoot) {
            return 1.0f;
        }
        return this._get(label, CapacityType.ABS_CAP);
    }

    public void setAbsoluteCapacity(float value) {
        this._set(NL, CapacityType.ABS_CAP, value);
    }

    public void setAbsoluteCapacity(String label, float value) {
        this._set(label, CapacityType.ABS_CAP, value);
    }

    public float getMaximumCapacity() {
        return this._get(NL, CapacityType.MAX_CAP);
    }

    public float getMaximumCapacity(String label) {
        return this._get(label, CapacityType.MAX_CAP);
    }

    public void setMaximumCapacity(float value) {
        this._set(NL, CapacityType.MAX_CAP, value);
    }

    public void setMaximumCapacity(String label, float value) {
        this._set(label, CapacityType.MAX_CAP, value);
    }

    public float getAbsoluteMaximumCapacity() {
        return this._get(NL, CapacityType.ABS_MAX_CAP);
    }

    public float getAbsoluteMaximumCapacity(String label) {
        return this._get(label, CapacityType.ABS_MAX_CAP);
    }

    public void setAbsoluteMaximumCapacity(float value) {
        this._set(NL, CapacityType.ABS_MAX_CAP, value);
    }

    public void setAbsoluteMaximumCapacity(String label, float value) {
        this._set(label, CapacityType.ABS_MAX_CAP, value);
    }

    public float getMaxAMResourcePercentage() {
        return this._get(NL, CapacityType.MAX_AM_PERC);
    }

    public float getMaxAMResourcePercentage(String label) {
        return this._get(label, CapacityType.MAX_AM_PERC);
    }

    public void setMaxAMResourcePercentage(String label, float value) {
        this._set(label, CapacityType.MAX_AM_PERC, value);
    }

    public void setMaxAMResourcePercentage(float value) {
        this._set(NL, CapacityType.MAX_AM_PERC, value);
    }

    public float getReservedCapacity() {
        return this._get(NL, CapacityType.RESERVED_CAP);
    }

    public float getReservedCapacity(String label) {
        return this._get(label, CapacityType.RESERVED_CAP);
    }

    public void setReservedCapacity(float value) {
        this._set(NL, CapacityType.RESERVED_CAP, value);
    }

    public void setReservedCapacity(String label, float value) {
        this._set(label, CapacityType.RESERVED_CAP, value);
    }

    public float getAbsoluteReservedCapacity() {
        return this._get(NL, CapacityType.ABS_RESERVED_CAP);
    }

    public float getAbsoluteReservedCapacity(String label) {
        return this._get(label, CapacityType.ABS_RESERVED_CAP);
    }

    public void setAbsoluteReservedCapacity(float value) {
        this._set(NL, CapacityType.ABS_RESERVED_CAP, value);
    }

    public void setAbsoluteReservedCapacity(String label, float value) {
        this._set(label, CapacityType.ABS_RESERVED_CAP, value);
    }

    public void clearConfigurableFields() {
        this.writeLock.lock();
        try {
            for (String label : this.capacitiesMap.keySet()) {
                this._set(label, CapacityType.CAP, 0.0f);
                this._set(label, CapacityType.MAX_CAP, 0.0f);
                this._set(label, CapacityType.ABS_CAP, 0.0f);
                this._set(label, CapacityType.ABS_MAX_CAP, 0.0f);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getExistingNodeLabels() {
        this.readLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.capacitiesMap.keySet());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.capacitiesMap.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> getNodePartitionsSet() {
        this.readLock.lock();
        try {
            Set<String> set = this.capacitiesMap.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class Capacities {
        private float[] capacitiesArr = new float[CapacityType.values().length];

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{used=" + this.capacitiesArr[0] + "%, ").append("abs_used=" + this.capacitiesArr[1] + "%, ").append("max_cap=" + this.capacitiesArr[2] + "%, ").append("abs_max_cap=" + this.capacitiesArr[3] + "%, ").append("cap=" + this.capacitiesArr[4] + "%, ").append("abs_cap=" + this.capacitiesArr[5] + "%}").append("max_am_perc=" + this.capacitiesArr[6] + "%}").append("reserved_cap=" + this.capacitiesArr[7] + "%}").append("abs_reserved_cap=" + this.capacitiesArr[8] + "%}");
            return sb.toString();
        }
    }

    private static enum CapacityType {
        USED_CAP(0),
        ABS_USED_CAP(1),
        MAX_CAP(2),
        ABS_MAX_CAP(3),
        CAP(4),
        ABS_CAP(5),
        MAX_AM_PERC(6),
        RESERVED_CAP(7),
        ABS_RESERVED_CAP(8);

        private int idx;

        private CapacityType(int idx) {
            this.idx = idx;
        }
    }
}

