/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateTest.class);
    File dataDir1;
    File dataDir2;
    File dataDir3;

    @Before
    public void setUp() throws IOException {
        this.dataDir1 = ClientBase.createTmpDir();
        this.dataDir2 = ClientBase.createTmpDir();
        this.dataDir3 = ClientBase.createTmpDir();
    }

    @After
    public void tearDown() {
        ClientBase.recursiveDelete(this.dataDir1);
        ClientBase.recursiveDelete(this.dataDir2);
        ClientBase.recursiveDelete(this.dataDir3);
    }

    @Test
    public void testTruncationStreamReset() throws Exception {
        File tmpdir = ClientBase.createTmpDir();
        FileTxnSnapLog snaplog = new FileTxnSnapLog(tmpdir, tmpdir);
        ZKDatabase zkdb = new ZKDatabase(snaplog);
        snaplog.save(zkdb.getDataTree(), zkdb.getSessionWithTimeOuts());
        for (int i = 1; i <= 100; ++i) {
            this.append(zkdb, i);
        }
        zkdb.truncateLog(1L);
        this.append(zkdb, 200);
        zkdb.close();
        FileTxnLog txnlog = new FileTxnLog(new File(tmpdir, "version-2"));
        TxnLog.TxnIterator iter = txnlog.read(1L);
        TxnHeader hdr = iter.getHeader();
        Record txn = iter.getTxn();
        Assert.assertEquals((long)1L, (long)hdr.getZxid());
        Assert.assertTrue((boolean)(txn instanceof SetDataTxn));
        iter.next();
        hdr = iter.getHeader();
        txn = iter.getTxn();
        Assert.assertEquals((long)200L, (long)hdr.getZxid());
        Assert.assertTrue((boolean)(txn instanceof SetDataTxn));
        iter.close();
        ClientBase.recursiveDelete(tmpdir);
    }

    @Test
    public void testTruncationNullLog() throws Exception {
        File tmpdir = ClientBase.createTmpDir();
        FileTxnSnapLog snaplog = new FileTxnSnapLog(tmpdir, tmpdir);
        ZKDatabase zkdb = new ZKDatabase(snaplog);
        for (int i = 1; i <= 100; ++i) {
            this.append(zkdb, i);
        }
        zkdb.close();
        File[] logs = snaplog.getDataDir().listFiles();
        for (int i = 0; i < logs.length; ++i) {
            LOG.debug("Deleting: {}", (Object)logs[i].getName());
            Assert.assertTrue((String)("Failed to delete log file: " + logs[i].getName()), (boolean)logs[i].delete());
        }
        try {
            zkdb.truncateLog(1L);
            Assert.assertTrue((String)"Should not get here", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Should have received an IOException", (boolean)true);
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"This should not throw NPE!");
        }
        ClientBase.recursiveDelete(tmpdir);
    }

    private void append(ZKDatabase zkdb, int i) throws IOException {
        TxnHeader hdr = new TxnHeader(1L, 1, (long)i, 1L, 5);
        SetDataTxn txn = new SetDataTxn("/foo" + i, new byte[0], 1);
        Request req = new Request(0L, 0, 0, hdr, (Record)txn, 0L);
        zkdb.append(req);
        zkdb.commit();
    }

    @Test
    public void testTruncate() throws Exception {
        String hostPort = "127.0.0.1:" + PortAssignment.unique();
        int maxCnxns = 100;
        ServerCnxnFactory factory = ClientBase.createNewServerInstance(null, hostPort, maxCnxns);
        ClientBase.startServerInstance(this.dataDir1, factory, hostPort, 1);
        ClientBase.shutdownServerInstance(factory, hostPort);
        File origfile = new File(new File(this.dataDir1, "version-2"), "snapshot.0");
        File newfile = new File(new File(this.dataDir1, "version-2"), "snapshot.100000000");
        origfile.renameTo(newfile);
        factory = ClientBase.createNewServerInstance(null, hostPort, maxCnxns);
        ClientBase.startServerInstance(this.dataDir1, factory, hostPort, 1);
        ZooKeeper zk = ClientBase.createZKClient(hostPort, 15000);
        for (int i = 0; i < 50; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        ZooKeeperServer zs = ClientBase.getServer(factory);
        ZKDatabase zkDb = zs.getZKDatabase();
        factory.shutdown();
        try {
            zkDb.close();
        }
        catch (IOException ie) {
            LOG.warn("Error closing logs ", (Throwable)ie);
        }
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        int port1 = PortAssignment.unique();
        int port2 = PortAssignment.unique();
        int port3 = PortAssignment.unique();
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", port1)));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", port2)));
        peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", port3)));
        QuorumPeer s2 = new QuorumPeer(peers, this.dataDir2, this.dataDir2, port2, 0, 2L, tickTime, initLimit, syncLimit);
        s2.start();
        QuorumPeer s3 = new QuorumPeer(peers, this.dataDir3, this.dataDir3, port3, 0, 3L, tickTime, initLimit, syncLimit);
        s3.start();
        zk = ClientBase.createZKClient("127.0.0.1:" + port2, 15000);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        ZooKeeper zk2 = ClientBase.createZKClient("127.0.0.1:" + port2, 15000);
        zk2.getData("/9", false, new Stat());
        try {
            zk2.getData("/10", false, new Stat());
            Assert.fail((String)"Should have gotten an error");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        QuorumPeer s1 = new QuorumPeer(peers, this.dataDir1, this.dataDir1, port1, 0, 1L, tickTime, initLimit, syncLimit);
        s1.start();
        ZooKeeper zk1 = ClientBase.createZKClient("127.0.0.1:" + port1, 15000);
        zk1.getData("/9", false, new Stat());
        try {
            zk1.getData("/12", false, new Stat());
            Assert.fail((String)"Should have gotten an error");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        zk1.close();
        QuorumBase.shutdown(s1);
        QuorumBase.shutdown(s2);
        QuorumBase.shutdown(s3);
    }
}

