/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSessionsOnlyTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalSessionsOnlyTest.class);
    public static final int CONNECTION_TIMEOUT = ClientBase.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();

    @Before
    public void setUp() throws Exception {
        LOG.info("STARTING quorum " + this.getClass().getName());
        this.qb.localSessionsEnabled = true;
        this.qb.localSessionsUpgradingEnabled = false;
        this.qb.setUp();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum " + this.getClass().getName());
        this.qb.tearDown();
    }

    @Test
    public void testLocalSessionsOnFollower() throws Exception {
        this.testLocalSessions(false);
    }

    @Test
    public void testLocalSessionsOnLeader() throws Exception {
        this.testLocalSessions(true);
    }

    private void testLocalSessions(boolean testLeader) throws Exception {
        String nodePrefix = "/testLocalSessions-" + (testLeader ? "leaderTest-" : "followerTest-");
        int leaderIdx = this.qb.getLeaderIndex();
        Assert.assertFalse((String)"No leader in quorum?", (leaderIdx == -1 ? 1 : 0) != 0);
        int followerIdx = (leaderIdx + 1) % 5;
        int testPeerIdx = testLeader ? leaderIdx : followerIdx;
        String[] hostPorts = this.qb.hostPort.split(",");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = this.qb.createClient(watcher, hostPorts[testPeerIdx], CONNECTION_TIMEOUT);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        long localSessionId = zk.getSessionId();
        for (int i = 0; i < 5; ++i) {
            zk.create(nodePrefix + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        try {
            zk.create(nodePrefix + "ephemeral", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Assert.fail((String)"Ephemeral node creation should fail.");
        }
        catch (KeeperException.EphemeralOnLocalSessionException i) {
            // empty catch block
        }
        zk.close();
        HashMap<String, Integer> peers = new HashMap<String, Integer>();
        peers.put("leader", leaderIdx);
        peers.put("follower", followerIdx);
        for (Map.Entry entry : peers.entrySet()) {
            watcher.reset();
            zk = this.qb.createClient(watcher, hostPorts[(Integer)entry.getValue()], CONNECTION_TIMEOUT);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            long newSessionId = zk.getSessionId();
            Assert.assertFalse((newSessionId == localSessionId ? 1 : 0) != 0);
            for (int i = 0; i < 5; ++i) {
                Assert.assertNotNull((String)("Data not exists in " + (String)entry.getKey()), (Object)zk.exists(nodePrefix + i, null));
            }
            Assert.assertNull((String)("Data exists in " + (String)entry.getKey()), (Object)zk.exists(nodePrefix + "ephemeral", null));
            zk.close();
        }
        this.qb.shutdownServers();
    }
}

