/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.IOUtils;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactoryAccessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FilePadding;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.OSMXBean;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientBase.class);
    public static int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = new File(System.getProperty("build.test.dir", "build"));
    protected String hostPort = "127.0.0.1:" + PortAssignment.unique();
    protected int maxCnxns = 0;
    protected ServerCnxnFactory serverFactory = null;
    protected File tmpDir = null;
    long initialFdCount;
    private LinkedList<ZooKeeper> allClients;
    private boolean allClientsSetup = false;

    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher) throws IOException, InterruptedException {
        return this.createClient(watcher, this.hostPort);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp) throws IOException, InterruptedException {
        return this.createClient(watcher, hp, CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp, int timeout) throws IOException, InterruptedException {
        watcher.reset();
        TestableZooKeeper zk = new TestableZooKeeper(hp, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        ClientBase clientBase = this;
        synchronized (clientBase) {
            if (!this.allClientsSetup) {
                LOG.error("allClients never setup");
                Assert.fail((String)"allClients never setup");
            }
            if (this.allClients != null) {
                this.allClients.add((ZooKeeper)zk);
                JMXEnv.ensureAll(ClientBase.getHexSessionId(zk.getSessionId()));
            } else {
                zk.close();
            }
        }
        return zk;
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        return ClientBase.waitForServerUp(hp, timeout, false);
    }

    public static boolean waitForServerUp(String hp, long timeout, boolean secure) {
        long start = Time.currentElapsedTime();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                String result = FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)"stat", (boolean)secure);
                if (result.startsWith("Zookeeper version:") && !result.contains("READ-ONLY")) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("server {} not up", (Object)hp, (Object)e);
            }
            catch (X509Exception.SSLContextException e) {
                LOG.error("server {} not up", (Object)hp, (Object)e);
            }
            if (Time.currentElapsedTime() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        return ClientBase.waitForServerDown(hp, timeout, false);
    }

    public static boolean waitForServerDown(String hp, long timeout, boolean secure) {
        long start = Time.currentElapsedTime();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)"stat", (boolean)secure);
            }
            catch (IOException e) {
                return true;
            }
            catch (X509Exception.SSLContextException e) {
                return true;
            }
            if (Time.currentElapsedTime() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static boolean waitForServerState(QuorumPeer qp, int timeout, String ... serverStates) {
        long start = Time.currentElapsedTime();
        do {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (String state : serverStates) {
                if (!qp.getServerState().equals(state)) continue;
                return true;
            }
        } while (Time.currentElapsedTime() <= start + (long)timeout);
        return false;
    }

    static void verifyThreadTerminated(Thread thread, long millis) throws InterruptedException {
        thread.join(millis);
        if (thread.isAlive()) {
            LOG.error("Thread " + thread.getName() + " : " + Arrays.toString(thread.getStackTrace()));
            Assert.assertFalse((String)("thread " + thread.getName() + " still alive after join"), (boolean)true);
        }
    }

    public static File createEmptyTestDir() throws IOException {
        return ClientBase.createTmpDir(BASETEST, false);
    }

    public static File createTmpDir() throws IOException {
        return ClientBase.createTmpDir(BASETEST, true);
    }

    static File createTmpDir(File parentDir, boolean createInitFile) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        if (createInitFile) {
            ClientBase.createInitializeFile(tmpDir);
        }
        return tmpDir;
    }

    public static void createInitializeFile(File dir) throws IOException {
        File initFile = new File(dir, "initialize");
        if (!initFile.exists()) {
            Assert.assertTrue((boolean)initFile.createNewFile());
        }
    }

    private static int getPort(String hostPort) {
        String[] split = hostPort.split(":");
        String portstr = split[split.length - 1];
        String[] pc = portstr.split("/");
        if (pc.length > 1) {
            portstr = pc[0];
        }
        return Integer.parseInt(portstr);
    }

    public static void startServerInstance(File dataDir, ServerCnxnFactory factory, String hostPort, int serverId) throws IOException, InterruptedException {
        int port = ClientBase.getPort(hostPort);
        LOG.info("STARTING server instance 127.0.0.1:{}", (Object)port);
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        zks.setCreateSessionTrackerServerId(serverId);
        factory.startup(zks);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + port, CONNECTION_TIMEOUT, factory.isSecure()));
    }

    public static ServerCnxnFactory createNewServerInstance(ServerCnxnFactory factory, String hostPort, int maxCnxns) throws IOException, InterruptedException {
        int port = ClientBase.getPort(hostPort);
        LOG.info("CREATING server instance 127.0.0.1:{}", (Object)port);
        if (factory == null) {
            factory = ServerCnxnFactory.createFactory((int)port, (int)maxCnxns);
        }
        return factory;
    }

    static void shutdownServerInstance(ServerCnxnFactory factory, String hostPort) {
        if (factory != null) {
            ZKDatabase zkDb = null;
            ZooKeeperServer zs = ClientBase.getServer(factory);
            if (zs != null) {
                zkDb = zs.getZKDatabase();
            }
            factory.shutdown();
            try {
                if (zkDb != null) {
                    zkDb.close();
                }
            }
            catch (IOException ie) {
                LOG.warn("Error closing logs ", (Throwable)ie);
            }
            int PORT = ClientBase.getPort(hostPort);
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, CONNECTION_TIMEOUT, factory.isSecure()));
        }
    }

    public static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FilePadding.setPreallocSize((long)102400L);
    }

    protected void setUpAll() throws Exception {
        this.allClients = new LinkedList();
        this.allClientsSetup = true;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpWithServerId(1);
    }

    protected void setUpWithServerId(int serverId) throws Exception {
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            this.initialFdCount = osMbean.getOpenFileDescriptorCount();
            LOG.info("Initial fdcount is: " + this.initialFdCount);
        }
        ClientBase.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.tmpDir = ClientBase.createTmpDir(BASETEST, true);
        this.startServer(serverId);
        LOG.info("Client test setup finished");
    }

    protected void startServer() throws Exception {
        this.startServer(1);
    }

    private void startServer(int serverId) throws Exception {
        LOG.info("STARTING server");
        this.serverFactory = ClientBase.createNewServerInstance(this.serverFactory, this.hostPort, this.maxCnxns);
        ClientBase.startServerInstance(this.tmpDir, this.serverFactory, this.hostPort, serverId);
        Set<ObjectName> children = JMXEnv.ensureParent("InMemoryDataTree", "StandaloneServer_port");
        this.verifyUnexpectedBeans(children);
    }

    private void verifyUnexpectedBeans(Set<ObjectName> children) {
        if (this.allClients != null) {
            for (ZooKeeper zkc : this.allClients) {
                Iterator<ObjectName> childItr = children.iterator();
                while (childItr.hasNext()) {
                    ObjectName clientBean = childItr.next();
                    if (!clientBean.toString().contains(ClientBase.getHexSessionId(zkc.getSessionId()))) continue;
                    LOG.info("found name:" + zkc.getSessionId() + " client bean:" + clientBean.toString());
                    childItr.remove();
                }
            }
        }
        for (ObjectName bean : children) {
            LOG.info("unexpected:" + bean.toString());
        }
        Assert.assertEquals((String)"Unexpected bean exists!", (long)0L, (long)children.size());
    }

    protected static String getHexSessionId(long sessionId) {
        return "0x" + Long.toHexString(sessionId);
    }

    protected void stopServer() throws Exception {
        LOG.info("STOPPING server");
        ClientBase.shutdownServerInstance(this.serverFactory, this.hostPort);
        this.serverFactory = null;
        JMXEnv.ensureOnly(new String[0]);
    }

    protected static ZooKeeperServer getServer(ServerCnxnFactory fac) {
        ZooKeeperServer zs = ServerCnxnFactoryAccessor.getZkServer(fac);
        return zs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownAll() throws Exception {
        ClientBase clientBase = this;
        synchronized (clientBase) {
            if (this.allClients != null) {
                for (ZooKeeper zk : this.allClients) {
                    try {
                        if (zk == null) continue;
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("ignoring interrupt", (Throwable)e);
                    }
                }
            }
            this.allClients = null;
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        this.tearDownAll();
        this.stopServer();
        if (this.tmpDir != null) {
            Assert.assertTrue((String)("delete " + this.tmpDir.toString()), (boolean)ClientBase.recursiveDelete(this.tmpDir));
        }
        this.serverFactory = null;
        JMXEnv.tearDown();
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            long fdCount = osMbean.getOpenFileDescriptorCount();
            String message = "fdcount after test is: " + fdCount + " at start it was " + this.initialFdCount;
            LOG.info(message);
            if (fdCount > this.initialFdCount) {
                LOG.info("sleeping for 20 secs");
            }
        }
    }

    public static MBeanServerConnection jmxConn() throws IOException {
        return JMXEnv.conn();
    }

    public static boolean recursiveDelete(File d) {
        return TestUtils.deleteFileRecursively(d, true);
    }

    public static void logAllStackTraces() {
        StringBuilder sb = new StringBuilder();
        sb.append("Starting logAllStackTraces()\n");
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : threads.entrySet()) {
            sb.append("Thread " + e.getKey().getName() + "\n");
            for (StackTraceElement elem : e.getValue()) {
                sb.append("\tat " + elem + "\n");
            }
        }
        sb.append("Ending logAllStackTraces()\n");
        LOG.error(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyRootOfAllServersMatch(String hostPort) throws InterruptedException, KeeperException, IOException {
        String[] parts = hostPort.split(",");
        int[] counts = new int[parts.length];
        int failed = 0;
        for (int j = 0; j < 100; ++j) {
            int[] newcounts = new int[parts.length];
            int i = 0;
            for (String hp : parts) {
                try (TestableZooKeeper zk = this.createClient(hp);){
                    newcounts[i++] = zk.getChildren("/", false).size();
                }
                catch (Throwable t) {
                    ++failed;
                    ClientBase.logAllStackTraces();
                }
            }
            if (Arrays.equals(newcounts, counts)) {
                LOG.info("Found match with array:" + Arrays.toString(newcounts));
                counts = newcounts;
                break;
            }
            counts = newcounts;
            Thread.sleep(10000L);
            if (failed > 10) break;
        }
        String logmsg = "node count not consistent{} {}";
        for (int i = 1; i < parts.length; ++i) {
            if (counts[i - 1] != counts[i]) {
                LOG.error(logmsg, (Object)counts[i - 1], (Object)counts[i]);
                continue;
            }
            LOG.info(logmsg, (Object)counts[i - 1], (Object)counts[i]);
        }
    }

    public static String readFile(File file) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)1024, (boolean)true);
        }
        return os.toString();
    }

    public static String join(String separator, Object[] parts) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object part : parts) {
            if (!first) {
                sb.append(separator);
                first = false;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static ZooKeeper createZKClient(String cxnString) throws Exception {
        return ClientBase.createZKClient(cxnString, CONNECTION_TIMEOUT);
    }

    public static ZooKeeper createZKClient(String cxnString, int sessionTimeout) throws IOException {
        CountdownWatcher watcher = new CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(cxnString, sessionTimeout, (Watcher)watcher);
        try {
            watcher.waitForConnected(CONNECTION_TIMEOUT);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)("ZooKeeper client can not connect to " + cxnString));
        }
        return zk;
    }

    public static class HostPort {
        String host;
        int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    public static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected;
        volatile boolean connected;
        volatile boolean syncConnected;
        volatile boolean readOnlyConnected;

        public CountdownWatcher() {
            this.reset();
        }

        public synchronized void reset() {
            this.clientConnected = new CountDownLatch(1);
            this.connected = false;
            this.syncConnected = false;
            this.readOnlyConnected = false;
        }

        public synchronized void process(WatchedEvent event) {
            Watcher.Event.KeeperState state = event.getState();
            if (state == Watcher.Event.KeeperState.SyncConnected) {
                this.connected = true;
                this.syncConnected = true;
                this.readOnlyConnected = false;
            } else if (state == Watcher.Event.KeeperState.ConnectedReadOnly) {
                this.connected = true;
                this.syncConnected = false;
                this.readOnlyConnected = true;
            } else {
                this.connected = false;
                this.syncConnected = false;
                this.readOnlyConnected = false;
            }
            this.notifyAll();
            if (this.connected) {
                this.clientConnected.countDown();
            }
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }

        public synchronized void waitForConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = Time.currentElapsedTime() + timeout;
            long left = timeout;
            while (!this.connected && left > 0L) {
                this.wait(left);
                left = expire - Time.currentElapsedTime();
            }
            if (!this.connected) {
                throw new TimeoutException("Failed to connect to ZooKeeper server.");
            }
        }

        public synchronized void waitForSyncConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = Time.currentElapsedTime() + timeout;
            long left = timeout;
            while (!this.syncConnected && left > 0L) {
                this.wait(left);
                left = expire - Time.currentElapsedTime();
            }
            if (!this.syncConnected) {
                throw new TimeoutException("Failed to connect to read-write ZooKeeper server.");
            }
        }

        public synchronized void waitForReadOnlyConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (!this.readOnlyConnected && left > 0L) {
                this.wait(left);
                left = expire - System.currentTimeMillis();
            }
            if (!this.readOnlyConnected) {
                throw new TimeoutException("Failed to connect in read-only mode to ZooKeeper server.");
            }
        }

        public synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = Time.currentElapsedTime() + timeout;
            long left = timeout;
            while (this.connected && left > 0L) {
                this.wait(left);
                left = expire - Time.currentElapsedTime();
            }
            if (this.connected) {
                throw new TimeoutException("Did not disconnect");
            }
        }
    }

    protected static class NullWatcher
    implements Watcher {
        protected NullWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

