/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigDuringLeaderSyncTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ReconfigDuringLeaderSyncTest.class);
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt;

    @Before
    public void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
    }

    @Test
    public void testDuringLeaderSync() throws Exception {
        int i;
        int[] clientPorts = new int[SERVER_COUNT + 1];
        StringBuilder sb = new StringBuilder();
        String[] serverConfig = new String[SERVER_COUNT + 1];
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            serverConfig[i2] = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(serverConfig[i2] + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        this.mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT + 1];
        for (i = 0; i < SERVER_COUNT; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            this.mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        ClientBase.CountdownWatcher watch = new ClientBase.CountdownWatcher();
        ZooKeeperAdmin preReconfigClient = new ZooKeeperAdmin("127.0.0.1:" + clientPorts[0], ClientBase.CONNECTION_TIMEOUT, (Watcher)watch);
        preReconfigClient.addAuthInfo("digest", "super:test".getBytes());
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        int joinerId = SERVER_COUNT;
        clientPorts[joinerId] = PortAssignment.unique();
        serverConfig[joinerId] = "server." + joinerId + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[joinerId];
        int leaderId = -1;
        for (int i3 = 0; i3 < SERVER_COUNT; ++i3) {
            if (this.mt[i3].main.quorumPeer.leader == null) continue;
            leaderId = i3;
            break;
        }
        Assert.assertFalse((leaderId == -1 ? 1 : 0) != 0);
        sb = new StringBuilder();
        sb.append(serverConfig[leaderId] + "\n").append(serverConfig[joinerId] + "\n");
        this.mt[joinerId] = new QuorumPeerTestBase.MainThread(joinerId, clientPorts[joinerId], sb.toString(), false){

            @Override
            public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                return new MockTestQPMain();
            }
        };
        this.mt[joinerId].start();
        CustomQuorumPeer qp = ReconfigDuringLeaderSyncTest.getCustomQuorumPeer(this.mt[joinerId]);
        String nextDynamicConfigFilename = qp.getNextDynamicConfigFilename();
        File nextDynaFile = new File(nextDynamicConfigFilename);
        nextDynaFile.delete();
        while (true) {
            if (qp.isNewLeaderMessage()) break;
            Thread.sleep(10L);
        }
        preReconfigClient.reconfigure(serverConfig[joinerId], null, null, -1L, null, null);
        watch = new ClientBase.CountdownWatcher();
        ZooKeeper postReconfigClient = new ZooKeeper("127.0.0.1:" + clientPorts[joinerId], ClientBase.CONNECTION_TIMEOUT, (Watcher)watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        postReconfigClient.create("/reconfigIssue", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertFalse((String)"zoo.cfg.dynamic.next is not deleted.", (boolean)nextDynaFile.exists());
        for (long j = 0L; j <= (long)SERVER_COUNT; ++j) {
            Assert.assertNotNull((String)("server " + j + " is not present in the new quorum"), qp.getQuorumVerifier().getVotingMembers().get(j));
        }
        preReconfigClient.close();
        postReconfigClient.close();
    }

    private static CustomQuorumPeer getCustomQuorumPeer(QuorumPeerTestBase.MainThread mt) {
        QuorumPeer quorumPeer;
        while (null == (quorumPeer = mt.getQuorumPeer())) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return (CustomQuorumPeer)quorumPeer;
    }

    @After
    public void tearDown() {
        if (null != this.mt) {
            for (int i = 0; i < this.mt.length; ++i) {
                try {
                    this.mt[i].shutdown();
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
                }
            }
        }
    }

    private static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        private MockTestQPMain() {
        }

        public void runFromConfig(QuorumPeerConfig config) throws IOException, AdminServer.AdminServerException {
            this.quorumPeer = new CustomQuorumPeer(config.getQuorumVerifier().getAllMembers(), config.getDataDir(), config.getDataLogDir(), config.getClientPortAddress().getPort(), config.getElectionAlg(), config.getServerId(), config.getTickTime(), config.getInitLimit(), config.getSyncLimit());
            this.quorumPeer.setConfigFileName(config.getConfigFilename());
            this.quorumPeer.start();
            try {
                this.quorumPeer.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Quorum Peer interrupted", (Throwable)e);
            }
        }
    }

    private static class CustomQuorumPeer
    extends QuorumPeer {
        private boolean newLeaderMessage = false;

        public CustomQuorumPeer(Map<Long, QuorumPeer.QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
            super(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, false, ServerCnxnFactory.createFactory((InetSocketAddress)new InetSocketAddress(clientPort), (int)-1), (QuorumVerifier)new QuorumMaj(quorumPeers));
        }

        public boolean isNewLeaderMessage() {
            return this.newLeaderMessage;
        }

        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            return new Follower(this, new FollowerZooKeeperServer(logFactory, (QuorumPeer)this, this.getZkDb())){

                void writePacket(QuorumPacket pp, boolean flush) throws IOException {
                    if (pp != null && pp.getType() == 3) {
                        newLeaderMessage = true;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    super.writePacket(pp, flush);
                }
            };
        }
    }
}

