/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.Assert;
import org.junit.Test;

public class QuorumPeerConfigTest {
    @Test
    public void testErrorMessageWhensecureClientPortNotSetButsecureClientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("secureClientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "secureClientPortAddress is set but secureClientPort is not set";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorMessageWhenclientPortNotSetButclientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("clientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assert.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "clientPortAddress is set but clientPort is not set";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testConfigureSSLAuthGetsConfiguredIfSecurePortConfigured() throws IOException, QuorumPeerConfig.ConfigException {
        String sslAuthProp = "zookeeper.authProvider.x509";
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("secureClientPort", "12345");
        quorumPeerConfig.parseProperties(zkProp);
        String expected = "org.apache.zookeeper.server.auth.X509AuthenticationProvider";
        String result = System.getProperty(sslAuthProp);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCustomSSLAuth() throws IOException {
        try (ClientX509Util x509Util = new ClientX509Util();){
            System.setProperty(x509Util.getSslAuthProviderProperty(), "y509");
            QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
            try {
                Properties zkProp = this.getDefaultZKProperties();
                zkProp.setProperty("secureClientPort", "12345");
                quorumPeerConfig.parseProperties(zkProp);
                Assert.fail((String)"ConfigException is expected");
            }
            catch (QuorumPeerConfig.ConfigException e) {
                Assert.assertNotNull((Object)e.getMessage());
            }
        }
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void testSamePortConfiguredForClientAndElection() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("server.1", "localhost:2888:2888");
        quorumPeerConfig.parseProperties(zkProp);
    }

    private Properties getDefaultZKProperties() {
        Properties zkProp = new Properties();
        zkProp.setProperty("dataDir", new File("myDataDir").getAbsolutePath());
        return zkProp;
    }
}

