/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.TestUtils;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;

public class LearnerTest
extends ZKTestCase {
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));

    @Test(expected=IOException.class)
    public void connectionRetryTimeoutTest() throws Exception {
        TimeoutLearner learner = new TimeoutLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addr = new InetSocketAddress(1111);
        learner.connectToLeader(addr, "");
    }

    @Test
    public void connectionInitLimitTimeoutTest() throws Exception {
        TimeoutLearner learner = new TimeoutLearner();
        learner.self = new QuorumPeer();
        learner.self.setTickTime(2000);
        learner.self.setInitLimit(5);
        learner.self.setSyncLimit(2);
        InetSocketAddress addr = new InetSocketAddress(1111);
        learner.setTimeMultiplier(4000000000L);
        learner.setPassConnectAttempt(5);
        try {
            learner.connectToLeader(addr, "");
            Assert.fail((String)"should have thrown IOException!");
        }
        catch (IOException e) {
            Assert.assertTrue((learner.nanoTime() > 1410065408L ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)learner.getSockConnectAttempt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void syncTest() throws Exception {
        File tmpFile = File.createTempFile("test", ".dir", testData);
        tmpFile.delete();
        try {
            FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpFile, tmpFile);
            SimpleLearner sl = new SimpleLearner(ftsl);
            long startZxid = sl.zk.getLastProcessedZxid();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)baos);
            sl.leaderOs = BinaryOutputArchive.getArchive((OutputStream)new ByteArrayOutputStream());
            sl.bufferedOutput = new BufferedOutputStream(System.out);
            sl.sock = new Socket();
            QuorumPacket qp = new QuorumPacket(15, 0L, null, null);
            oa.writeRecord((Record)qp, null);
            sl.zk.getZKDatabase().serializeSnapshot((OutputArchive)oa);
            oa.writeString("BenWasHere", "signature");
            TxnHeader hdr = new TxnHeader(0L, 0, 0L, 0L, 1);
            CreateTxn txn = new CreateTxn("/foo", new byte[0], new ArrayList(), false, sl.zk.getZKDatabase().getNode((String)"/").stat.getCversion());
            ByteArrayOutputStream tbaos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)tbaos);
            hdr.serialize((OutputArchive)boa, "hdr");
            txn.serialize((OutputArchive)boa, "txn");
            tbaos.close();
            qp = new QuorumPacket(2, 1L, tbaos.toByteArray(), null);
            oa.writeRecord((Record)qp, null);
            sl.leaderIs = BinaryInputArchive.getArchive((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            try {
                sl.syncWithLeader(3L);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            sl.zk.shutdown();
            sl = new SimpleLearner(ftsl);
            Assert.assertEquals((long)startZxid, (long)sl.zk.getLastProcessedZxid());
        }
        finally {
            TestUtils.deleteFileRecursively(tmpFile);
        }
    }

    static class TimeoutLearner
    extends Learner {
        int passSocketConnectOnAttempt = 10;
        int socketConnectAttempt = 0;
        long timeMultiplier = 0L;

        TimeoutLearner() {
        }

        public void setTimeMultiplier(long multiplier) {
            this.timeMultiplier = multiplier;
        }

        public void setPassConnectAttempt(int num) {
            this.passSocketConnectOnAttempt = num;
        }

        protected long nanoTime() {
            return (long)this.socketConnectAttempt * this.timeMultiplier;
        }

        protected int getSockConnectAttempt() {
            return this.socketConnectAttempt;
        }

        protected void sockConnect(Socket sock, InetSocketAddress addr, int timeout) throws IOException {
            if (++this.socketConnectAttempt < this.passSocketConnectOnAttempt) {
                throw new IOException("Test injected Socket.connect() error.");
            }
        }
    }

    static class SimpleLearner
    extends Learner {
        SimpleLearner(FileTxnSnapLog ftsl) throws IOException {
            this.self = new QuorumPeer();
            this.zk = new SimpleLearnerZooKeeperServer(ftsl, this.self);
            ((SimpleLearnerZooKeeperServer)this.zk).learner = this;
        }
    }

    static class SimpleLearnerZooKeeperServer
    extends LearnerZooKeeperServer {
        Learner learner;

        public SimpleLearnerZooKeeperServer(FileTxnSnapLog ftsl, QuorumPeer self) throws IOException {
            super(ftsl, 2000, 2000, 2000, new ZKDatabase(ftsl), self);
        }

        public Learner getLearner() {
            return this.learner;
        }
    }
}

