/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerMainTest;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzySnapshotRelatedTest
extends QuorumPeerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(FuzzySnapshotRelatedTest.class);
    QuorumPeerTestBase.MainThread[] mt = null;
    ZooKeeper[] zk = null;
    int leaderId;
    int followerA;

    @Before
    public void setup() throws Exception {
        int i;
        LOG.info("Start up a 3 server quorum");
        int ENSEMBLE_SERVERS = 3;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        this.mt = new QuorumPeerTestBase.MainThread[3];
        this.zk = new ZooKeeper[3];
        for (i = 0; i < 3; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return new CustomizedQPMain();
                }
            };
            this.mt[i].start();
            this.zk[i] = new ZooKeeper("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        }
        QuorumPeerMainTest.waitForAll(this.zk, ZooKeeper.States.CONNECTED);
        LOG.info("all servers started");
        this.leaderId = -1;
        this.followerA = -1;
        for (i = 0; i < 3; ++i) {
            if (this.mt[i].main.quorumPeer.leader != null) {
                this.leaderId = i;
                continue;
            }
            if (this.followerA != -1) continue;
            this.followerA = i;
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.mt != null) {
            for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
                mainThread.shutdown();
            }
        }
        if (this.zk != null) {
            for (QuorumPeerTestBase.MainThread mainThread : this.zk) {
                mainThread.close();
            }
        }
    }

    @Test
    public void testMultiOpConsistency() throws Exception {
        LOG.info("Create a parent node");
        String path = "/testMultiOpConsistency";
        this.createEmptyNode(this.zk[this.followerA], "/testMultiOpConsistency");
        LOG.info("Hook to catch the 2nd sub create node txn in multi-op");
        CustomDataTree dt = (CustomDataTree)this.mt[this.followerA].main.quorumPeer.getZkDb().getDataTree();
        final ZooKeeperServer zkServer = this.mt[this.followerA].main.quorumPeer.getActiveServer();
        String node1 = "/testMultiOpConsistency/1";
        String node2 = "/testMultiOpConsistency/2";
        dt.addNodeCreateListener(node2, new NodeCreateListener(){

            @Override
            public void process(String path) {
                LOG.info("Take a snapshot");
                zkServer.takeSnapshot();
            }
        });
        LOG.info("Issue a multi op to create 2 nodes");
        this.zk[this.followerA].multi(Arrays.asList(Op.create((String)node1, (byte[])node1.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)node2, (byte[])node2.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        LOG.info("Restart the server");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Make sure the node consistent with leader");
        Assert.assertEquals((Object)new String(this.zk[this.leaderId].getData(node2, null, null)), (Object)new String(this.zk[this.followerA].getData(node2, null, null)));
    }

    @Test
    public void testPZxidUpdatedDuringSnapSyncing() throws Exception {
        LOG.info("Enable force snapshot sync");
        System.setProperty("zookeeper.forceSnapshotSync", "true");
        String parent = "/testPZxidUpdatedWhenDeletingNonExistNode";
        String child = "/testPZxidUpdatedWhenDeletingNonExistNode/child";
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedWhenDeletingNonExistNode");
        this.createEmptyNode(this.zk[this.leaderId], "/testPZxidUpdatedWhenDeletingNonExistNode/child");
        LOG.info("shutdown follower {}", (Object)this.followerA);
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        LOG.info("Set up ZKDatabase to catch the node serializing in DataTree");
        this.addSerializeListener(this.leaderId, "/testPZxidUpdatedWhenDeletingNonExistNode", "/testPZxidUpdatedWhenDeletingNonExistNode/child");
        LOG.info("Restart follower A to trigger a SNAP sync with leader");
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Check and make sure the pzxid of the parent is the same on leader and follower A");
        this.compareStat("/testPZxidUpdatedWhenDeletingNonExistNode", this.leaderId, this.followerA);
    }

    @Test
    public void testPZxidUpdatedWhenLoadingSnapshot() throws Exception {
        String parent = "/testPZxidUpdatedDuringTakingSnapshot";
        String child = "/testPZxidUpdatedDuringTakingSnapshot/child";
        this.createEmptyNode(this.zk[this.followerA], "/testPZxidUpdatedDuringTakingSnapshot");
        this.createEmptyNode(this.zk[this.followerA], "/testPZxidUpdatedDuringTakingSnapshot/child");
        LOG.info("Set up ZKDatabase to catch the node serializing in DataTree");
        this.addSerializeListener(this.followerA, "/testPZxidUpdatedDuringTakingSnapshot", "/testPZxidUpdatedDuringTakingSnapshot/child");
        LOG.info("Take snapshot on follower A");
        ZooKeeperServer zkServer = this.mt[this.followerA].main.quorumPeer.getActiveServer();
        zkServer.takeSnapshot();
        LOG.info("Restarting follower A to load snapshot");
        this.mt[this.followerA].shutdown();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTING);
        this.mt[this.followerA].start();
        QuorumPeerMainTest.waitForOne(this.zk[this.followerA], ZooKeeper.States.CONNECTED);
        LOG.info("Check and make sure the pzxid of the parent is the same on leader and follower A");
        this.compareStat("/testPZxidUpdatedDuringTakingSnapshot", this.leaderId, this.followerA);
    }

    private void addSerializeListener(int sid, String parent, final String child) {
        final ZooKeeper zkClient = this.zk[this.followerA];
        CustomDataTree dt = (CustomDataTree)this.mt[sid].main.quorumPeer.getZkDb().getDataTree();
        dt.addListener(parent, new NodeSerializeListener(){

            @Override
            public void nodeSerialized(String path) {
                try {
                    zkClient.delete(child, -1);
                    LOG.info("Deleted the child node after the parent is serialized");
                }
                catch (Exception e) {
                    LOG.error("Error when deleting node {}", (Throwable)e);
                }
            }
        });
    }

    private void compareStat(String path, int sid, int compareWithSid) throws Exception {
        Stat stat1 = new Stat();
        this.zk[sid].getData(path, null, stat1);
        Stat stat2 = new Stat();
        this.zk[compareWithSid].getData(path, null, stat2);
        Assert.assertEquals((Object)stat1, (Object)stat2);
    }

    private void createEmptyNode(ZooKeeper zk, String path) throws Exception {
        zk.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    static class CustomizedQPMain
    extends QuorumPeerTestBase.TestQPMain {
        CustomizedQPMain() {
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new QuorumPeer(){

                public void setZKDatabase(ZKDatabase database) {
                    super.setZKDatabase(new ZKDatabase(this.getTxnFactory()){

                        public DataTree createDataTree() {
                            return new CustomDataTree();
                        }
                    });
                }
            };
        }
    }

    static interface NodeSerializeListener {
        public void nodeSerialized(String var1);
    }

    static class CustomDataTree
    extends DataTree {
        Map<String, NodeCreateListener> nodeCreateListeners = new HashMap<String, NodeCreateListener>();
        Map<String, NodeSerializeListener> listeners = new HashMap<String, NodeSerializeListener>();

        CustomDataTree() {
        }

        public void serializeNodeData(OutputArchive oa, String path, DataNode node) throws IOException {
            super.serializeNodeData(oa, path, node);
            NodeSerializeListener listener = this.listeners.get(path);
            if (listener != null) {
                listener.nodeSerialized(path);
            }
        }

        public void addListener(String path, NodeSerializeListener listener) {
            this.listeners.put(path, listener);
        }

        public void createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time, Stat outputStat) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
            NodeCreateListener listener = this.nodeCreateListeners.get(path);
            if (listener != null) {
                listener.process(path);
            }
            super.createNode(path, data, acl, ephemeralOwner, parentCVersion, zxid, time, outputStat);
        }

        public void addNodeCreateListener(String path, NodeCreateListener listener) {
            this.nodeCreateListeners.put(path, listener);
        }
    }

    static interface NodeCreateListener {
        public void process(String var1);
    }
}

