/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.WorkerService;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitProcessorConcurrencyTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(CommitProcessorConcurrencyTest.class);
    Boolean executedFlag = false;
    MockCommitProcessor processor;

    @Before
    public void setUp() throws Exception {
        this.processor = new MockCommitProcessor();
    }

    @After
    public void tearDown() throws Exception {
        this.processor.shutdown();
    }

    @Test
    public void raceTest() throws Exception {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        GetDataRequest getReq = new GetDataRequest("/testrace", false);
        getReq.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        Request readReq = new Request(null, 0L, 0, 4, bb, new ArrayList());
        boas.reset();
        SyncRequest syncReq = new SyncRequest("/testrace");
        syncReq.serialize((OutputArchive)boa, "request");
        bb = ByteBuffer.wrap(boas.toByteArray());
        Request writeReq = new Request(null, 0L, 0, 9, bb, new ArrayList());
        this.processor.addToCommittedRequests(writeReq);
        this.processor.addToQueuedRequests(readReq);
        this.processor.addToQueuedRequests(writeReq);
        this.processor.testStart();
        this.processor.testProcessCommitted();
        Assert.assertFalse((String)"Next request processor executed", (boolean)this.executedFlag);
    }

    class MockCommitProcessor
    extends CommitProcessor {
        MockCommitProcessor() {
            super(new RequestProcessor(){

                public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
                    CommitProcessorConcurrencyTest.this.executedFlag = true;
                }

                public void shutdown() {
                }
            }, "0", false, new ZooKeeperServerListener(){

                public void notifyStopping(String errMsg, int exitCode) {
                }
            });
        }

        public void testStart() {
            this.stopped = false;
            this.workerPool = new WorkerService("CommitProcWork", 1, true);
        }

        public void addToCommittedRequests(Request req) {
            this.committedRequests.add(req);
        }

        public void addToNextPending(Request req) {
            this.nextPending.set(req);
        }

        public void addToQueuedRequests(Request req) {
            this.queuedRequests.add(req);
        }

        public void testProcessCommitted() {
            this.processCommitted();
        }

        public void shutdown() {
            this.workerPool.stop();
        }
    }
}

