/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.ZooKeeperServerMainTest;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.JettyAdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAdminServerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(JettyAdminServerTest.class);
    private static final String URL_FORMAT = "http://localhost:%d/commands";
    private static final int jettyAdminPort = PortAssignment.unique();

    @Before
    public void enableServer() {
        System.setProperty("zookeeper.admin.enableServer", "true");
        System.setProperty("zookeeper.admin.serverPort", "" + jettyAdminPort);
    }

    @Test
    public void testJettyAdminServer() throws AdminServer.AdminServerException, IOException {
        JettyAdminServer server = new JettyAdminServer();
        try {
            server.start();
            this.queryAdminServer(jettyAdminPort);
        }
        finally {
            server.shutdown();
        }
    }

    @Test
    public void testStandalone() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        ZooKeeperServerMainTest.MainThread main = new ZooKeeperServerMainTest.MainThread(CLIENT_PORT, false, null);
        main.start();
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT));
        this.queryAdminServer(jettyAdminPort);
        main.shutdown();
        Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT));
    }

    @Test
    public void testQuorum() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int ADMIN_SERVER_PORT1 = PortAssignment.unique();
        int ADMIN_SERVER_PORT2 = PortAssignment.unique();
        String quorumCfgSection = String.format("server.1=127.0.0.1:%d:%d;%d\nserver.2=127.0.0.1:%d:%d;%d", PortAssignment.unique(), PortAssignment.unique(), CLIENT_PORT_QP1, PortAssignment.unique(), PortAssignment.unique(), CLIENT_PORT_QP2);
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, ADMIN_SERVER_PORT1, quorumCfgSection, null);
        q1.start();
        Thread.sleep(500L);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, ADMIN_SERVER_PORT2, quorumCfgSection, null);
        q2.start();
        Thread.sleep(500L);
        Assert.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        this.queryAdminServer(ADMIN_SERVER_PORT1);
        this.queryAdminServer(ADMIN_SERVER_PORT2);
        q1.shutdown();
        q2.shutdown();
        Assert.assertTrue((String)"waiting for server 1 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"waiting for server 2 down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
    }

    private void queryAdminServer(int port) throws MalformedURLException, IOException {
        this.queryAdminServer(String.format(URL_FORMAT, port));
    }

    private void queryAdminServer(String urlStr) throws MalformedURLException, IOException {
        URL url = new URL(urlStr);
        BufferedReader dis = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = dis.readLine();
        Assert.assertTrue((line.length() > 0 ? 1 : 0) != 0);
    }
}

