/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.webapp.AppsBlock;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed rgba(0,0,0,0.25)";
    static final String Q_OVER = "background:rgba(255, 140, 0, 0.8)";
    static final String Q_UNDER = "background:rgba(50, 205, 50, 0.8)";

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage.__> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css").__(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"}).__()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript").__(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    else q = '^' + q.substr(q.lastIndexOf('.') + 1) + '$';", "    $('#apps').dataTable().fnFilter(q, 4, true);", "  });", "  $('#cs').show();", "});"}).__()).__(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final CSQInfo csqinfo;

        @Inject
        QueuesBlock(ResourceManager rm, CSQInfo info) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            html.__(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top").__(new Object[]{"Application Queues"}).__()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END).__(new Object[]{"100% "}).__()).span(".q", "default").__()).__();
            } else {
                CapacitySchedulerInfo sinfo;
                CSQueue root = this.cs.getRootQueue();
                this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root);
                this.csqinfo.qinfo = null;
                float used = sinfo.getUsedCapacity() / 100.0f;
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold").__(new Object[]{"Legend:"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_GIVEN).__(new Object[]{"Capacity"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_UNDER).__(new Object[]{"Used"}).__()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_OVER).__(new Object[]{"Used (over capacity)"}).__()).span().$class("qlegend ui-corner-all ui-state-default").__(new Object[]{"Max Capacity"}).__()).__()).li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{"."}).__()).span(".q", "root").__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__()).__(QueueBlock.class).__();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul.__()).__()).script().$type("text/javascript").__(new Object[]{"$('#cs').hide();"}).__()).__()).__(AppsBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final CSQInfo csqinfo;

        @Inject
        QueueBlock(CSQInfo info) {
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            ArrayList<CapacitySchedulerQueueInfo> subQueues = this.csqinfo.qinfo == null ? this.csqinfo.csinfo.getQueues().getQueueInfoList() : this.csqinfo.qinfo.getQueues().getQueueInfoList();
            Hamlet.UL ul = html.ul("#pq");
            for (CapacitySchedulerQueueInfo info : subQueues) {
                float used = info.getUsedCapacity() / 100.0f;
                float absCap = info.getAbsoluteCapacity() / 100.0f;
                float absMaxCap = info.getAbsoluteMaxCapacity() / 100.0f;
                float absUsedCap = info.getAbsoluteUsedCapacity() / 100.0f;
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(absMaxCap * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"Absolute Capacity:", CapacitySchedulerPage.percent(absCap)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_GIVEN, ";font-size:1px;", CapacitySchedulerPage.width(absCap / absMaxCap)})).__(new Object[]{Character.valueOf('.')}).__()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(absUsedCap / absMaxCap), ";font-size:1px;left:0%;", absUsedCap > absCap ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER})).__(new Object[]{Character.valueOf('.')}).__()).span(".q", info.getQueuePath().substring(5)).__()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})}).__();
                this.csqinfo.qinfo = info;
                if (info.getQueues() == null) {
                    ((Hamlet.UL)li.ul("#lq").li().__(LeafQueueInfoBlock.class).__()).__();
                    ((Hamlet.UL)li.ul("#lq").li().__(QueueUsersInfoBlock.class).__()).__();
                } else {
                    li.__(QueueBlock.class);
                }
                li.__();
            }
            ul.__();
        }
    }

    static class QueueUsersInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;

        @Inject
        QueueUsersInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.table("#userinfo").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"User Name"}).__()).th().$class("ui-state-default").__(new Object[]{"Max Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Used Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Max AM Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Used AM Resource"}).__()).th().$class("ui-state-default").__(new Object[]{"Schedulable Apps"}).__()).th().$class("ui-state-default").__(new Object[]{"Non-Schedulable Apps"}).__()).__()).__()).tbody();
            ArrayList<UserInfo> users = this.lqinfo.getUsers().getUsersList();
            for (UserInfo userInfo : users) {
                tbody.tr().td(userInfo.getUsername()).td(userInfo.getUserResourceLimit().toString()).td(userInfo.getResourcesUsed().toString()).td(this.lqinfo.getUserAMResourceLimit().toString()).td(userInfo.getAMResourcesUsed().toString()).td(Integer.toString(userInfo.getNumActiveApplications())).td(Integer.toString(userInfo.getNumPendingApplications())).__();
            }
            html.div().$class("usersinfo").h5("Active Users Info").__();
            ((Hamlet.TABLE)tbody.__()).__();
        }
    }

    static class LeafQueueInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;

        @Inject
        LeafQueueInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
        }

        protected void render(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status").__("Queue State:", (Object)this.lqinfo.getQueueState()).__("Used Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getUsedCapacity() / 100.0f)).__("Absolute Used Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteUsedCapacity() / 100.0f)).__("Absolute Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteCapacity() / 100.0f)).__("Absolute Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteMaxCapacity() / 100.0f)).__("Used Resources:", (Object)this.lqinfo.getResourcesUsed().toString()).__("Num Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumActiveApplications())).__("Num Non-Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumPendingApplications())).__("Num Containers:", (Object)Integer.toString(this.lqinfo.getNumContainers())).__("Queue Label:", (Object)this.lqinfo.getLabel()).__("Queue Label Policy:", (Object)this.lqinfo.getLabelPolicy()).__("Max Applications:", (Object)Integer.toString(this.lqinfo.getMaxApplications())).__("Max Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxApplicationsPerUser())).__("Max Application Master Resources:", (Object)this.lqinfo.getAMResourceLimit().toString()).__("Used Application Master Resources:", (Object)this.lqinfo.getUsedAMResource().toString()).__("Max Application Master Resources Per User:", (Object)this.lqinfo.getUserAMResourceLimit().toString()).__("Configured Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getCapacity() / 100.0f)).__("Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getMaxCapacity() / 100.0f)).__("Configured Minimum User Limit Percent:", (Object)(Integer.toString(this.lqinfo.getUserLimit()) + "%")).__("Configured User Limit Factor:", (Object)String.format("%.1f", Float.valueOf(this.lqinfo.getUserLimitFactor()))).__("Accessible Node Labels:", (Object)StringUtils.join((CharSequence)",", this.lqinfo.getNodeLabels())).__("Preemption:", (Object)(this.lqinfo.getPreemptionDisabled() ? "disabled" : "enabled"));
            html.__(InfoBlock.class);
            ri.clear();
        }
    }

    @RequestScoped
    static class CSQInfo {
        CapacitySchedulerInfo csinfo;
        CapacitySchedulerQueueInfo qinfo;

        CSQInfo() {
        }
    }
}

