/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationAttemptStateDataPBImpl
extends ApplicationAttemptStateData {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationAttemptStateDataPBImpl.class);
    YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto proto = YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.getDefaultInstance();
    YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationAttemptId attemptId = null;
    private Container masterContainer = null;
    private ByteBuffer appAttemptTokens = null;
    private static String RM_APP_ATTEMPT_PREFIX = "RMATTEMPT_";

    public ApplicationAttemptStateDataPBImpl() {
        this.builder = YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.newBuilder();
    }

    public ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.attemptId != null) {
            this.builder.setAttemptId(((ApplicationAttemptIdPBImpl)this.attemptId).getProto());
        }
        if (this.masterContainer != null) {
            this.builder.setMasterContainer(((ContainerPBImpl)this.masterContainer).getProto());
        }
        if (this.appAttemptTokens != null) {
            this.builder.setAppAttemptTokens(ProtoUtils.convertToProtoFormat((ByteBuffer)this.appAttemptTokens));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ApplicationAttemptId getAttemptId() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.attemptId != null) {
            return this.attemptId;
        }
        if (!p.hasAttemptId()) {
            return null;
        }
        this.attemptId = new ApplicationAttemptIdPBImpl(p.getAttemptId());
        return this.attemptId;
    }

    @Override
    public void setAttemptId(ApplicationAttemptId attemptId) {
        this.maybeInitBuilder();
        if (attemptId == null) {
            this.builder.clearAttemptId();
        }
        this.attemptId = attemptId;
    }

    @Override
    public Container getMasterContainer() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.masterContainer != null) {
            return this.masterContainer;
        }
        if (!p.hasMasterContainer()) {
            return null;
        }
        this.masterContainer = new ContainerPBImpl(p.getMasterContainer());
        return this.masterContainer;
    }

    @Override
    public void setMasterContainer(Container container) {
        this.maybeInitBuilder();
        if (container == null) {
            this.builder.clearMasterContainer();
        }
        this.masterContainer = container;
    }

    @Override
    public Credentials getAppAttemptTokens() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.appAttemptTokens != null) {
            return ApplicationAttemptStateDataPBImpl.convertCredentialsFromByteBuffer(this.appAttemptTokens);
        }
        if (!p.hasAppAttemptTokens()) {
            return null;
        }
        this.appAttemptTokens = ProtoUtils.convertFromProtoFormat((ByteString)p.getAppAttemptTokens());
        return ApplicationAttemptStateDataPBImpl.convertCredentialsFromByteBuffer(this.appAttemptTokens);
    }

    @Override
    public void setAppAttemptTokens(Credentials attemptTokens) {
        this.maybeInitBuilder();
        if (attemptTokens == null) {
            this.builder.clearAppAttemptTokens();
            return;
        }
        this.appAttemptTokens = ApplicationAttemptStateDataPBImpl.convertCredentialsToByteBuffer(attemptTokens);
    }

    @Override
    public RMAppAttemptState getState() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAppAttemptState()) {
            return null;
        }
        return ApplicationAttemptStateDataPBImpl.convertFromProtoFormat(p.getAppAttemptState());
    }

    @Override
    public void setState(RMAppAttemptState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearAppAttemptState();
            return;
        }
        this.builder.setAppAttemptState(ApplicationAttemptStateDataPBImpl.convertToProtoFormat(state));
    }

    @Override
    public String getFinalTrackingUrl() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasFinalTrackingUrl()) {
            return null;
        }
        return p.getFinalTrackingUrl();
    }

    @Override
    public void setFinalTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearFinalTrackingUrl();
            return;
        }
        this.builder.setFinalTrackingUrl(url);
    }

    @Override
    public String getDiagnostics() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnostics()) {
            return null;
        }
        return p.getDiagnostics();
    }

    @Override
    public void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        if (diagnostics == null) {
            this.builder.clearDiagnostics();
            return;
        }
        this.builder.setDiagnostics(diagnostics);
    }

    @Override
    public long getStartTime() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getStartTime();
    }

    @Override
    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        this.builder.setStartTime(startTime);
    }

    @Override
    public long getMemorySeconds() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMemorySeconds();
    }

    @Override
    public long getVcoreSeconds() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getVcoreSeconds();
    }

    @Override
    public void setMemorySeconds(long memorySeconds) {
        this.maybeInitBuilder();
        this.builder.setMemorySeconds(memorySeconds);
    }

    @Override
    public void setVcoreSeconds(long vcoreSeconds) {
        this.maybeInitBuilder();
        this.builder.setVcoreSeconds(vcoreSeconds);
    }

    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p;
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder applicationAttemptStateDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasFinalApplicationStatus()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getFinalApplicationStatus());
    }

    @Override
    public void setFinalApplicationStatus(FinalApplicationStatus finishState) {
        this.maybeInitBuilder();
        if (finishState == null) {
            this.builder.clearFinalApplicationStatus();
            return;
        }
        this.builder.setFinalApplicationStatus(this.convertToProtoFormat(finishState));
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    @Override
    public int getAMContainerExitStatus() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getAmContainerExitStatus();
    }

    @Override
    public void setAMContainerExitStatus(int exitStatus) {
        this.maybeInitBuilder();
        this.builder.setAmContainerExitStatus(exitStatus);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationAttemptStateDataPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    public static YarnServerResourceManagerRecoveryProtos.RMAppAttemptStateProto convertToProtoFormat(RMAppAttemptState e) {
        return YarnServerResourceManagerRecoveryProtos.RMAppAttemptStateProto.valueOf(RM_APP_ATTEMPT_PREFIX + e.name());
    }

    public static RMAppAttemptState convertFromProtoFormat(YarnServerResourceManagerRecoveryProtos.RMAppAttemptStateProto e) {
        return RMAppAttemptState.valueOf(e.name().replace(RM_APP_ATTEMPT_PREFIX, ""));
    }

    private YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus s) {
        return ProtoUtils.convertToProtoFormat((FinalApplicationStatus)s);
    }

    private FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto s) {
        return ProtoUtils.convertFromProtoFormat((YarnProtos.FinalApplicationStatusProto)s);
    }

    @Override
    public long getFinishTime() {
        YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    @Override
    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer convertCredentialsToByteBuffer(Credentials credentials) {
        ByteBuffer appAttemptTokens = null;
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            if (credentials != null) {
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
                appAttemptTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            }
            ByteBuffer byteBuffer = appAttemptTokens;
            return byteBuffer;
        }
        catch (IOException e) {
            LOG.error("Failed to convert Credentials to ByteBuffer.");
            assert (false);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            IOUtils.closeStream((Closeable)dob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Credentials convertCredentialsFromByteBuffer(ByteBuffer appAttemptTokens) {
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        try {
            Credentials credentials = null;
            if (appAttemptTokens != null) {
                credentials = new Credentials();
                ((Buffer)appAttemptTokens).rewind();
                dibb.reset(new ByteBuffer[]{appAttemptTokens});
                credentials.readTokenStorageStream((DataInputStream)dibb);
            }
            Credentials credentials2 = credentials;
            return credentials2;
        }
        catch (IOException e) {
            LOG.error("Failed to convert Credentials from ByteBuffer.");
            assert (false);
            Credentials credentials = null;
            return credentials;
        }
        finally {
            IOUtils.closeStream((Closeable)dibb);
        }
    }
}

