/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/timeline")
public class TimelineWebServices {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineWebServices.class);
    private TimelineDataManager timelineDataManager;

    @Inject
    public TimelineWebServices(TimelineDataManager timelineDataManager) {
        this.timelineDataManager = timelineDataManager;
    }

    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public AboutInfo about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return new AboutInfo("Timeline API");
    }

    @GET
    @Path(value="/{entityType}")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntities getEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @QueryParam(value="primaryFilter") String primaryFilter, @QueryParam(value="secondaryFilter") String secondaryFilter, @QueryParam(value="windowStart") String windowStart, @QueryParam(value="windowEnd") String windowEnd, @QueryParam(value="fromId") String fromId, @QueryParam(value="fromTs") String fromTs, @QueryParam(value="limit") String limit, @QueryParam(value="fields") String fields) {
        this.init(res);
        try {
            return this.timelineDataManager.getEntities(TimelineWebServices.parseStr(entityType), TimelineWebServices.parsePairStr(primaryFilter, ":"), TimelineWebServices.parsePairsStr(secondaryFilter, ",", ":"), TimelineWebServices.parseLongStr(windowStart), TimelineWebServices.parseLongStr(windowEnd), TimelineWebServices.parseStr(fromId), TimelineWebServices.parseLongStr(fromTs), TimelineWebServices.parseLongStr(limit), TimelineWebServices.parseFieldsStr(fields, ","), TimelineWebServices.getUser(req));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("windowStart, windowEnd or limit is not a numeric value.");
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("requested invalid field.");
        }
        catch (Exception e) {
            LOG.error("Error getting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/{entityType}/{entityId}")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getEntity(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") String entityId, @QueryParam(value="fields") String fields) {
        this.init(res);
        TimelineEntity entity = null;
        try {
            entity = this.timelineDataManager.getEntity(TimelineWebServices.parseStr(entityType), TimelineWebServices.parseStr(entityId), TimelineWebServices.parseFieldsStr(fields, ","), TimelineWebServices.getUser(req));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("requested invalid field.");
        }
        catch (Exception e) {
            LOG.error("Error getting entity", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity == null) {
            throw new NotFoundException("Timeline entity " + new EntityIdentifier(TimelineWebServices.parseStr(entityId), TimelineWebServices.parseStr(entityType)) + " is not found");
        }
        return entity;
    }

    @GET
    @Path(value="/{entityType}/events")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEvents getEvents(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @QueryParam(value="entityId") String entityId, @QueryParam(value="eventType") String eventType, @QueryParam(value="windowStart") String windowStart, @QueryParam(value="windowEnd") String windowEnd, @QueryParam(value="limit") String limit) {
        this.init(res);
        try {
            return this.timelineDataManager.getEvents(TimelineWebServices.parseStr(entityType), TimelineWebServices.parseArrayStr(entityId, ","), TimelineWebServices.parseArrayStr(eventType, ","), TimelineWebServices.parseLongStr(windowStart), TimelineWebServices.parseLongStr(windowEnd), TimelineWebServices.parseLongStr(limit), TimelineWebServices.getUser(req));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("windowStart, windowEnd or limit is not a numeric value.");
        }
        catch (Exception e) {
            LOG.error("Error getting entity timelines", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public TimelinePutResponse postEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, TimelineEntities entities) {
        this.init(res);
        UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
        if (callerUGI == null) {
            String msg = "The owner of the posted timeline entities is not set";
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
        try {
            return this.timelineDataManager.postEntities(entities, callerUGI);
        }
        catch (Exception e) {
            LOG.error("Error putting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/domain")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public TimelinePutResponse putDomain(@Context HttpServletRequest req, @Context HttpServletResponse res, TimelineDomain domain) {
        this.init(res);
        UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
        if (callerUGI == null) {
            String msg = "The owner of the posted timeline domain is not set";
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
        domain.setOwner(callerUGI.getShortUserName());
        try {
            this.timelineDataManager.putDomain(domain, callerUGI);
        }
        catch (YarnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error putting domain", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new TimelinePutResponse();
    }

    @GET
    @Path(value="/domain/{domainId}")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineDomain getDomain(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="domainId") String domainId) {
        this.init(res);
        domainId = TimelineWebServices.parseStr(domainId);
        if (domainId == null || domainId.length() == 0) {
            throw new BadRequestException("Domain ID is not specified.");
        }
        TimelineDomain domain = null;
        try {
            domain = this.timelineDataManager.getDomain(TimelineWebServices.parseStr(domainId), TimelineWebServices.getUser(req));
        }
        catch (Exception e) {
            LOG.error("Error getting domain", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (domain == null) {
            throw new NotFoundException("Timeline domain [" + domainId + "] is not found");
        }
        return domain;
    }

    @GET
    @Path(value="/domain")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineDomains getDomains(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="owner") String owner) {
        this.init(res);
        owner = TimelineWebServices.parseStr(owner);
        UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
        if (owner == null || owner.length() == 0) {
            if (callerUGI == null) {
                throw new BadRequestException("Domain owner is not specified.");
            }
            owner = callerUGI.getShortUserName();
        }
        try {
            return this.timelineDataManager.getDomains(owner, callerUGI);
        }
        catch (Exception e) {
            LOG.error("Error getting domains", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void init(HttpServletResponse response) {
        response.setContentType(null);
    }

    private static UserGroupInformation getUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    private static SortedSet<String> parseArrayStr(String str, String delimiter) {
        String[] strs;
        if (str == null) {
            return null;
        }
        TreeSet<String> strSet = new TreeSet<String>();
        for (String aStr : strs = str.split(delimiter)) {
            strSet.add(aStr.trim());
        }
        return strSet;
    }

    private static NameValuePair parsePairStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter, 2);
        try {
            return new NameValuePair(strs[0].trim(), GenericObjectMapper.OBJECT_READER.readValue(strs[1].trim()));
        }
        catch (Exception e) {
            return new NameValuePair(strs[0].trim(), strs[1].trim());
        }
    }

    private static Collection<NameValuePair> parsePairsStr(String str, String aDelimiter, String pDelimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(aDelimiter);
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        for (String aStr : strs) {
            pairs.add(TimelineWebServices.parsePairStr(aStr, pDelimiter));
        }
        return pairs;
    }

    private static EnumSet<TimelineReader.Field> parseFieldsStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter);
        ArrayList<TimelineReader.Field> fieldList = new ArrayList<TimelineReader.Field>();
        for (String s : strs) {
            if ((s = StringUtils.toUpperCase((String)s.trim())).equals("EVENTS")) {
                fieldList.add(TimelineReader.Field.EVENTS);
                continue;
            }
            if (s.equals("LASTEVENTONLY")) {
                fieldList.add(TimelineReader.Field.LAST_EVENT_ONLY);
                continue;
            }
            if (s.equals("RELATEDENTITIES")) {
                fieldList.add(TimelineReader.Field.RELATED_ENTITIES);
                continue;
            }
            if (s.equals("PRIMARYFILTERS")) {
                fieldList.add(TimelineReader.Field.PRIMARY_FILTERS);
                continue;
            }
            if (s.equals("OTHERINFO")) {
                fieldList.add(TimelineReader.Field.OTHER_INFO);
                continue;
            }
            throw new IllegalArgumentException("Requested nonexistent field " + s);
        }
        if (fieldList.size() == 0) {
            return null;
        }
        TimelineReader.Field f1 = (TimelineReader.Field)((Object)fieldList.remove(fieldList.size() - 1));
        if (fieldList.size() == 0) {
            return EnumSet.of(f1);
        }
        return EnumSet.of(f1, fieldList.toArray(new TimelineReader.Field[fieldList.size()]));
    }

    private static Long parseLongStr(String str) {
        return str == null ? null : Long.valueOf(Long.parseLong(str.trim()));
    }

    private static String parseStr(String str) {
        return str == null ? null : str.trim();
    }

    @XmlRootElement(name="about")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class AboutInfo {
        private String about;

        public AboutInfo() {
        }

        public AboutInfo(String about) {
            this.about = about;
        }

        @XmlElement(name="About")
        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }
    }
}

